/*
 * Decompiled with CFR 0.152.
 */
package org.pgpainless.wot;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.bouncycastle.openpgp.PGPPublicKeyRing;
import org.jetbrains.annotations.NotNull;
import org.pgpainless.PGPainless;
import org.pgpainless.authentication.CertificateAuthenticity;
import org.pgpainless.authentication.CertificateAuthority;
import org.pgpainless.key.OpenPgpFingerprint;
import org.pgpainless.wot.PGPNetworkParser;
import org.pgpainless.wot.api.AuthenticateAPI;
import org.pgpainless.wot.api.Binding;
import org.pgpainless.wot.api.IdentifyAPI;
import org.pgpainless.wot.api.LookupAPI;
import org.pgpainless.wot.api.WebOfTrustAPI;
import org.pgpainless.wot.network.Edge;
import org.pgpainless.wot.network.Identifier;
import org.pgpainless.wot.network.Network;
import org.pgpainless.wot.network.TrustRoot;
import org.pgpainless.wot.query.Path;
import org.pgpainless.wot.query.ShortestPathAlgorithmFactory;
import pgp.certificate_store.PGPCertificateStore;
import pgp.certificate_store.certificate.Certificate;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 !2\u00020\u0001:\u0001!B+\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\n\u00a2\u0006\u0002\u0010\u000bJ0\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0017H\u0016J&\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\r0\u00192\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0017H\u0016J.\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\r0\u00192\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0017H\u0016J\u0018\u0010\u001b\u001a\u00020\r2\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u0016\u001a\u00020\u0017H\u0002J\u0010\u0010\u001e\u001a\u00020\u001f2\u0006\u0010\u000e\u001a\u00020 H\u0002R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\""}, d2={"Lorg/pgpainless/wot/CertificateAuthorityImpl;", "Lorg/pgpainless/authentication/CertificateAuthority;", "network", "Lorg/pgpainless/wot/network/Network;", "trustRoots", "", "Lorg/pgpainless/wot/network/TrustRoot;", "certificateStore", "Lpgp/certificate_store/PGPCertificateStore;", "shortestPathAlgorithmFactory", "Lorg/pgpainless/wot/query/ShortestPathAlgorithmFactory;", "(Lorg/pgpainless/wot/network/Network;Ljava/util/Set;Lpgp/certificate_store/PGPCertificateStore;Lorg/pgpainless/wot/query/ShortestPathAlgorithmFactory;)V", "authenticateBinding", "Lorg/pgpainless/authentication/CertificateAuthenticity;", "fingerprint", "Lorg/pgpainless/key/OpenPgpFingerprint;", "userId", "", "email", "", "referenceTime", "Ljava/util/Date;", "targetAmount", "", "identifyByFingerprint", "", "lookupByUserId", "mapToAuthenticity", "binding", "Lorg/pgpainless/wot/api/Binding;", "readPublicKeyRing", "Lorg/bouncycastle/openpgp/PGPPublicKeyRing;", "Lorg/pgpainless/wot/network/Identifier;", "Companion", "pgpainless-wot"})
@SourceDebugExtension(value={"SMAP\nCertificateAuthorityImpl.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CertificateAuthorityImpl.kt\norg/pgpainless/wot/CertificateAuthorityImpl\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,104:1\n1549#2:105\n1620#2,3:106\n1549#2:109\n1620#2,3:110\n*S KotlinDebug\n*F\n+ 1 CertificateAuthorityImpl.kt\norg/pgpainless/wot/CertificateAuthorityImpl\n*L\n71#1:105\n71#1:106,3\n78#1:109\n78#1:110,3\n*E\n"})
public final class CertificateAuthorityImpl
implements CertificateAuthority {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Network network;
    @NotNull
    private final Set<TrustRoot> trustRoots;
    @NotNull
    private final PGPCertificateStore certificateStore;
    @NotNull
    private final ShortestPathAlgorithmFactory shortestPathAlgorithmFactory;

    public CertificateAuthorityImpl(@NotNull Network network, @NotNull Set<TrustRoot> trustRoots, @NotNull PGPCertificateStore certificateStore, @NotNull ShortestPathAlgorithmFactory shortestPathAlgorithmFactory) {
        Intrinsics.checkNotNullParameter((Object)network, (String)"network");
        Intrinsics.checkNotNullParameter(trustRoots, (String)"trustRoots");
        Intrinsics.checkNotNullParameter((Object)certificateStore, (String)"certificateStore");
        Intrinsics.checkNotNullParameter((Object)shortestPathAlgorithmFactory, (String)"shortestPathAlgorithmFactory");
        this.network = network;
        this.trustRoots = trustRoots;
        this.certificateStore = certificateStore;
        this.shortestPathAlgorithmFactory = shortestPathAlgorithmFactory;
    }

    @NotNull
    public CertificateAuthenticity authenticateBinding(@NotNull OpenPgpFingerprint fingerprint, @NotNull String userId, boolean email, @NotNull Date referenceTime, int targetAmount) {
        Intrinsics.checkNotNullParameter((Object)fingerprint, (String)"fingerprint");
        Intrinsics.checkNotNullParameter((Object)userId, (String)"userId");
        Intrinsics.checkNotNullParameter((Object)referenceTime, (String)"referenceTime");
        WebOfTrustAPI api = new WebOfTrustAPI(this.network, this.trustRoots, false, false, targetAmount, referenceTime, this.shortestPathAlgorithmFactory);
        String string = fingerprint.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"fingerprint.toString()");
        AuthenticateAPI.Result result = api.authenticate(new Identifier(string), userId, email);
        return this.mapToAuthenticity(result.getBinding(), targetAmount);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public List<CertificateAuthenticity> lookupByUserId(@NotNull String userId, boolean email, @NotNull Date referenceTime, int targetAmount) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)userId, (String)"userId");
        Intrinsics.checkNotNullParameter((Object)referenceTime, (String)"referenceTime");
        WebOfTrustAPI api = new WebOfTrustAPI(this.network, this.trustRoots, false, false, targetAmount, referenceTime, this.shortestPathAlgorithmFactory);
        LookupAPI.Result result = api.lookup(userId, email);
        Iterable $this$map$iv = result.getBindings();
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            Binding binding = (Binding)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(this.mapToAuthenticity((Binding)it, targetAmount));
        }
        return (List)destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public List<CertificateAuthenticity> identifyByFingerprint(@NotNull OpenPgpFingerprint fingerprint, @NotNull Date referenceTime, int targetAmount) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)fingerprint, (String)"fingerprint");
        Intrinsics.checkNotNullParameter((Object)referenceTime, (String)"referenceTime");
        WebOfTrustAPI api = new WebOfTrustAPI(this.network, this.trustRoots, false, false, targetAmount, referenceTime, this.shortestPathAlgorithmFactory);
        String string = fingerprint.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"fingerprint.toString()");
        IdentifyAPI.Result result = api.identify(new Identifier(string));
        Iterable $this$map$iv = result.getBindings();
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            Binding binding = (Binding)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(this.mapToAuthenticity((Binding)it, targetAmount));
        }
        return (List)destination$iv$iv;
    }

    private final CertificateAuthenticity mapToAuthenticity(Binding binding, int targetAmount) {
        PGPPublicKeyRing publicKeyRing = this.readPublicKeyRing(binding.getFingerprint());
        Map certificationChains = new LinkedHashMap();
        for (Map.Entry entry : binding.getPaths().getItems()) {
            Path path = (Path)entry.getKey();
            int amount = ((Number)entry.getValue()).intValue();
            List links = new ArrayList();
            links.add(new CertificateAuthenticity.ChainLink(this.readPublicKeyRing(path.getRoot().getFingerprint())));
            for (Edge.Component edge : path.getCertifications()) {
                PGPPublicKeyRing target = this.readPublicKeyRing(edge.getTarget().getFingerprint());
                links.add(new CertificateAuthenticity.ChainLink(target));
            }
            Integer n = amount;
            certificationChains.put(new CertificateAuthenticity.CertificationChain(path.getAmount(), links), n);
        }
        return new CertificateAuthenticity(publicKeyRing, binding.getUserId(), certificationChains, targetAmount);
    }

    private final PGPPublicKeyRing readPublicKeyRing(Identifier fingerprint) {
        Certificate certificate = this.certificateStore.getCertificate(fingerprint.toString());
        PGPPublicKeyRing pGPPublicKeyRing = PGPainless.readKeyRing().publicKeyRing(certificate.getInputStream());
        Intrinsics.checkNotNull((Object)pGPPublicKeyRing);
        return pGPPublicKeyRing;
    }

    @JvmStatic
    @NotNull
    public static final CertificateAuthorityImpl webOfTrustFromCertificateStore(@NotNull PGPCertificateStore certificateStore, @NotNull Set<TrustRoot> trustRoots, @NotNull Date referenceTime, @NotNull ShortestPathAlgorithmFactory shortestPathAlgorithmFactory) {
        return Companion.webOfTrustFromCertificateStore(certificateStore, trustRoots, referenceTime, shortestPathAlgorithmFactory);
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J.\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0007\u00a8\u0006\u000e"}, d2={"Lorg/pgpainless/wot/CertificateAuthorityImpl$Companion;", "", "()V", "webOfTrustFromCertificateStore", "Lorg/pgpainless/wot/CertificateAuthorityImpl;", "certificateStore", "Lpgp/certificate_store/PGPCertificateStore;", "trustRoots", "", "Lorg/pgpainless/wot/network/TrustRoot;", "referenceTime", "Ljava/util/Date;", "shortestPathAlgorithmFactory", "Lorg/pgpainless/wot/query/ShortestPathAlgorithmFactory;", "pgpainless-wot"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @NotNull
        public final CertificateAuthorityImpl webOfTrustFromCertificateStore(@NotNull PGPCertificateStore certificateStore, @NotNull Set<TrustRoot> trustRoots, @NotNull Date referenceTime, @NotNull ShortestPathAlgorithmFactory shortestPathAlgorithmFactory) {
            Intrinsics.checkNotNullParameter((Object)certificateStore, (String)"certificateStore");
            Intrinsics.checkNotNullParameter(trustRoots, (String)"trustRoots");
            Intrinsics.checkNotNullParameter((Object)referenceTime, (String)"referenceTime");
            Intrinsics.checkNotNullParameter((Object)shortestPathAlgorithmFactory, (String)"shortestPathAlgorithmFactory");
            Network network = PGPNetworkParser.buildNetwork$default(new PGPNetworkParser(certificateStore), null, referenceTime, 1, null);
            return new CertificateAuthorityImpl(network, trustRoots, certificateStore, shortestPathAlgorithmFactory);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

