/*
 * Decompiled with CFR 0.152.
 */
package org.pgpainless.wot.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.bouncycastle.bcpg.sig.RegularExpression;
import org.bouncycastle.bcpg.sig.SignatureCreationTime;
import org.bouncycastle.bcpg.sig.TrustSignature;
import org.bouncycastle.openpgp.PGPSignature;
import org.jetbrains.annotations.NotNull;
import org.pgpainless.signature.subpackets.SignatureSubpacketsUtil;
import org.pgpainless.wot.network.Edge;
import org.pgpainless.wot.network.Node;
import org.pgpainless.wot.network.RegexSet;
import org.pgpainless.wot.network.TrustDepth;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\u0018\u0000 \u00032\u00020\u0001:\u0001\u0003B\u0005\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0004"}, d2={"Lorg/pgpainless/wot/util/CertificationFactory;", "", "()V", "Companion", "pgpainless-wot"})
public final class CertificationFactory {
    @NotNull
    public static final Companion Companion = new Companion(null);

    @JvmStatic
    @NotNull
    public static final Edge.Component fromDelegation(@NotNull Node issuer, @NotNull Node target, @NotNull PGPSignature signature) {
        return Companion.fromDelegation(issuer, target, signature);
    }

    @JvmStatic
    @NotNull
    public static final Edge.Component fromCertification(@NotNull Node issuer, @NotNull Node target, @NotNull String targetUserId, @NotNull PGPSignature signature) {
        return Companion.fromCertification(issuer, target, targetUserId, signature);
    }

    @JvmStatic
    private static final int getTrustAmountFrom(PGPSignature signature) {
        return CertificationFactory.Companion.getTrustAmountFrom(signature);
    }

    @JvmStatic
    private static final TrustDepth getTrustDepthFrom(PGPSignature signature) {
        return CertificationFactory.Companion.getTrustDepthFrom(signature);
    }

    @JvmStatic
    private static final RegexSet regexSetFrom(PGPSignature signature) {
        return CertificationFactory.Companion.regexSetFrom(signature);
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J(\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00062\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0007J \u0010\f\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00062\u0006\u0010\n\u001a\u00020\u000bH\u0007J\u0010\u0010\r\u001a\u00020\u000e2\u0006\u0010\n\u001a\u00020\u000bH\u0003J\u0010\u0010\u000f\u001a\u00020\u00102\u0006\u0010\n\u001a\u00020\u000bH\u0003J\u0010\u0010\u0011\u001a\u00020\u00122\u0006\u0010\n\u001a\u00020\u000bH\u0003\u00a8\u0006\u0013"}, d2={"Lorg/pgpainless/wot/util/CertificationFactory$Companion;", "", "()V", "fromCertification", "Lorg/pgpainless/wot/network/Edge$Component;", "issuer", "Lorg/pgpainless/wot/network/Node;", "target", "targetUserId", "", "signature", "Lorg/bouncycastle/openpgp/PGPSignature;", "fromDelegation", "getTrustAmountFrom", "", "getTrustDepthFrom", "Lorg/pgpainless/wot/network/TrustDepth;", "regexSetFrom", "Lorg/pgpainless/wot/network/RegexSet;", "pgpainless-wot"})
    @SourceDebugExtension(value={"SMAP\nCertificationFactory.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CertificationFactory.kt\norg/pgpainless/wot/util/CertificationFactory$Companion\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,75:1\n1620#2,3:76\n*S KotlinDebug\n*F\n+ 1 CertificationFactory.kt\norg/pgpainless/wot/util/CertificationFactory$Companion\n*L\n71#1:76,3\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @NotNull
        public final Edge.Component fromDelegation(@NotNull Node issuer, @NotNull Node target, @NotNull PGPSignature signature) {
            Intrinsics.checkNotNullParameter((Object)issuer, (String)"issuer");
            Intrinsics.checkNotNullParameter((Object)target, (String)"target");
            Intrinsics.checkNotNullParameter((Object)signature, (String)"signature");
            SignatureCreationTime signatureCreationTime = SignatureSubpacketsUtil.getSignatureCreationTime((PGPSignature)signature);
            Intrinsics.checkNotNull((Object)signatureCreationTime);
            Date date = signatureCreationTime.getTime();
            Intrinsics.checkNotNullExpressionValue((Object)date, (String)"getSignatureCreationTime(signature)!!.time");
            return (Edge.Component)new Edge.Delegation(issuer, target, date, SignatureSubpacketsUtil.getSignatureExpirationTimeAsDate((PGPSignature)signature), SignatureSubpacketsUtil.isExportable((PGPSignature)signature), this.getTrustAmountFrom(signature), this.getTrustDepthFrom(signature), this.regexSetFrom(signature));
        }

        @JvmStatic
        @NotNull
        public final Edge.Component fromCertification(@NotNull Node issuer, @NotNull Node target, @NotNull String targetUserId, @NotNull PGPSignature signature) {
            Intrinsics.checkNotNullParameter((Object)issuer, (String)"issuer");
            Intrinsics.checkNotNullParameter((Object)target, (String)"target");
            Intrinsics.checkNotNullParameter((Object)targetUserId, (String)"targetUserId");
            Intrinsics.checkNotNullParameter((Object)signature, (String)"signature");
            SignatureCreationTime signatureCreationTime = SignatureSubpacketsUtil.getSignatureCreationTime((PGPSignature)signature);
            Intrinsics.checkNotNull((Object)signatureCreationTime);
            Date date = signatureCreationTime.getTime();
            Intrinsics.checkNotNullExpressionValue((Object)date, (String)"getSignatureCreationTime(signature)!!.time");
            return (Edge.Component)new Edge.Certification(issuer, target, targetUserId, date, SignatureSubpacketsUtil.getSignatureExpirationTimeAsDate((PGPSignature)signature), SignatureSubpacketsUtil.isExportable((PGPSignature)signature), Integer.valueOf(this.getTrustAmountFrom(signature)), this.getTrustDepthFrom(signature), this.regexSetFrom(signature));
        }

        @JvmStatic
        private final int getTrustAmountFrom(PGPSignature signature) {
            TrustSignature packet;
            int[] nArray = new int[]{32, 48};
            if (ArraysKt.contains((int[])nArray, (int)signature.getSignatureType())) {
                return 0;
            }
            TrustSignature trustSignature = packet = SignatureSubpacketsUtil.getTrustSignature((PGPSignature)signature);
            return trustSignature != null ? trustSignature.getTrustAmount() : 120;
        }

        @JvmStatic
        private final TrustDepth getTrustDepthFrom(PGPSignature signature) {
            TrustSignature packet;
            int[] nArray = new int[]{32, 48};
            if (ArraysKt.contains((int[])nArray, (int)signature.getSignatureType())) {
                return TrustDepth.Companion.limited(0);
            }
            TrustSignature trustSignature = packet = SignatureSubpacketsUtil.getTrustSignature((PGPSignature)signature);
            return TrustDepth.Companion.auto(trustSignature != null ? trustSignature.getDepth() : 0);
        }

        /*
         * WARNING - void declaration
         */
        @JvmStatic
        private final RegexSet regexSetFrom(PGPSignature signature) {
            List regexList = SignatureSubpacketsUtil.getRegularExpressions((PGPSignature)signature);
            List stringList = new ArrayList();
            Intrinsics.checkNotNullExpressionValue((Object)regexList, (String)"regexList");
            Iterable $this$mapTo$iv = regexList;
            boolean $i$f$mapTo = false;
            for (Object item$iv : $this$mapTo$iv) {
                void it;
                RegularExpression regularExpression = (RegularExpression)item$iv;
                Collection collection = stringList;
                boolean bl = false;
                collection.add(it.getRegex());
            }
            return RegexSet.Companion.fromExpressions(stringList);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

