/*
 * Decompiled with CFR 0.152.
 */
package pgp.wkd.test_suite;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.file.Path;
import java.security.InvalidAlgorithmParameterException;
import java.security.NoSuchAlgorithmException;
import org.bouncycastle.openpgp.PGPException;
import org.bouncycastle.openpgp.PGPPublicKeyRing;
import org.bouncycastle.openpgp.PGPSecretKeyRing;
import org.pgpainless.PGPainless;
import pgp.wkd.discovery.DiscoveryMethod;
import pgp.wkd.test_suite.WkdDirectoryStructure;

public class AbstractTestSuiteGenerator {
    protected final String domain;

    public AbstractTestSuiteGenerator(String domain) {
        this.domain = domain;
    }

    protected WkdDirectoryStructure directoryStructureForMethod(File directory, DiscoveryMethod method) {
        WkdDirectoryStructure structure;
        if (method == DiscoveryMethod.direct) {
            structure = new WkdDirectoryStructure.DirectMethod(directory, this.domain);
        } else if (method == DiscoveryMethod.advanced) {
            structure = new WkdDirectoryStructure.AdvancedMethod(directory, this.domain);
        } else {
            throw new IllegalArgumentException("Invalid value for parameter 'method'.");
        }
        return structure;
    }

    protected PGPSecretKeyRing secretKey(String userId) throws PGPException, InvalidAlgorithmParameterException, NoSuchAlgorithmException {
        PGPSecretKeyRing secretKeys = PGPainless.generateKeyRing().modernKeyRing(userId, null);
        return secretKeys;
    }

    protected PGPPublicKeyRing certificate(String userId) throws PGPException, InvalidAlgorithmParameterException, NoSuchAlgorithmException {
        PGPSecretKeyRing secretKeys = this.secretKey(userId);
        PGPPublicKeyRing publicKeys = PGPainless.extractCertificate((PGPSecretKeyRing)secretKeys);
        return publicKeys;
    }

    protected void writeDataFor(String mailAddress, WkdDirectoryStructure directory, DataSink sink) throws IOException {
        Path path = directory.getRelativeCertificatePath(mailAddress);
        File file = directory.resolve(path);
        if (!file.exists() && !file.createNewFile()) {
            throw new IOException("Cannot create file " + file.getAbsolutePath());
        }
        try (FileOutputStream fileOut = new FileOutputStream(file);){
            sink.write(fileOut);
        }
    }

    protected static interface DataSink {
        public void write(OutputStream var1) throws IOException;
    }
}

