/*
 * Decompiled with CFR 0.152.
 */
package pgp.wkd.test_suite;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.file.Path;
import org.bouncycastle.openpgp.api.OpenPGPCertificate;
import org.bouncycastle.openpgp.api.OpenPGPKey;
import org.pgpainless.PGPainless;
import pgp.wkd.discovery.DiscoveryMethod;
import pgp.wkd.test_suite.WkdDirectoryStructure;

public class AbstractTestSuiteGenerator {
    protected final String domain;

    public AbstractTestSuiteGenerator(String domain) {
        this.domain = domain;
    }

    protected WkdDirectoryStructure directoryStructureForMethod(File directory, DiscoveryMethod method) {
        WkdDirectoryStructure structure;
        if (method == DiscoveryMethod.direct) {
            structure = new WkdDirectoryStructure.DirectMethod(directory, this.domain);
        } else if (method == DiscoveryMethod.advanced) {
            structure = new WkdDirectoryStructure.AdvancedMethod(directory, this.domain);
        } else {
            throw new IllegalArgumentException("Invalid value for parameter 'method'.");
        }
        return structure;
    }

    protected OpenPGPKey secretKey(String userId) {
        OpenPGPKey secretKey = PGPainless.getInstance().generateKey().modernKeyRing((CharSequence)userId);
        return secretKey;
    }

    protected OpenPGPCertificate certificate(String userId) {
        OpenPGPKey secretKeys = this.secretKey(userId);
        OpenPGPCertificate certificate = secretKeys.toCertificate();
        return certificate;
    }

    protected void writeDataFor(String mailAddress, WkdDirectoryStructure directory, DataSink sink) throws IOException {
        Path path = directory.getRelativeCertificatePath(mailAddress);
        File file = directory.resolve(path);
        if (!file.exists() && !file.createNewFile()) {
            throw new IOException("Cannot create file " + file.getAbsolutePath());
        }
        try (FileOutputStream fileOut = new FileOutputStream(file);){
            sink.write(fileOut);
        }
    }

    protected static interface DataSink {
        public void write(OutputStream var1) throws IOException;
    }
}

