/*
 * Decompiled with CFR 0.152.
 */
package pgp.wkd.test_suite;

import java.net.URI;
import java.nio.file.Path;
import pgp.wkd.test_suite.WkdDirectoryStructure;

public class TestCase {
    final Expectation expectation;
    final String testTitle;
    final String testDescription;
    final String lookupMailAddress;
    final String certificatePath;
    final URI lookupUri;

    public TestCase(Expectation expectation, String testTitle, String description, String lookupMailAddress, Path certificatePath, URI lookupUri) {
        this.expectation = expectation;
        this.testTitle = testTitle;
        this.testDescription = description;
        this.lookupMailAddress = lookupMailAddress;
        this.certificatePath = certificatePath.toString();
        this.lookupUri = lookupUri;
    }

    public static TestCase ok(String title, String description, String lookupMail, WkdDirectoryStructure structure) {
        Path filePath = structure.getRelativeCertificatePath(lookupMail);
        URI certUri = structure.getAddress(lookupMail);
        return new TestCase(Expectation.success, title, description, lookupMail, filePath, certUri);
    }

    public static TestCase fail(String title, String description, String lookupMail, WkdDirectoryStructure structure) {
        Path filePath = structure.getRelativeCertificatePath(lookupMail);
        URI certUri = structure.getAddress(lookupMail);
        return new TestCase(Expectation.failure, title, description, lookupMail, filePath, certUri);
    }

    public boolean isExpectSuccess() {
        return this.expectation == Expectation.success;
    }

    public boolean isExpectFailure() {
        return this.expectation == Expectation.failure;
    }

    public boolean isUnassertive() {
        return this.expectation == Expectation.unassertive;
    }

    public String getTestTitle() {
        return this.testTitle;
    }

    public String getTestDescription() {
        return this.testDescription;
    }

    public String getLookupMailAddress() {
        return this.lookupMailAddress;
    }

    public String getCertificatePath() {
        return this.certificatePath;
    }

    public URI getLookupUri() {
        return this.lookupUri;
    }

    static enum Expectation {
        success,
        failure,
        unassertive;

    }
}

