/*
 * Decompiled with CFR 0.152.
 */
package pgp.wkd.test_suite;

import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Random;
import org.bouncycastle.openpgp.PGPPublicKey;
import org.bouncycastle.openpgp.PGPPublicKeyRing;
import org.bouncycastle.openpgp.PGPSignature;
import org.bouncycastle.openpgp.api.OpenPGPCertificate;
import org.bouncycastle.openpgp.api.OpenPGPKey;
import org.pgpainless.PGPainless;
import org.pgpainless.key.protection.SecretKeyRingProtector;
import org.pgpainless.key.protection.UnprotectedKeysProtector;
import pgp.wkd.discovery.DiscoveryMethod;
import pgp.wkd.test_suite.AbstractTestSuiteGenerator;
import pgp.wkd.test_suite.TestCase;
import pgp.wkd.test_suite.TestSuite;
import pgp.wkd.test_suite.WkdDirectoryStructure;

public class TestSuiteGenerator
extends AbstractTestSuiteGenerator {
    public TestSuiteGenerator(String domain) {
        super(domain);
    }

    public TestSuite generateTestSuiteInDirectory(File directory, DiscoveryMethod method) throws Exception {
        WkdDirectoryStructure dirs = this.directoryStructureForMethod(directory, method);
        dirs.mkdirs();
        ArrayList<TestCase> tests = new ArrayList<TestCase>();
        tests.add(this.test_baseCase(dirs));
        tests.add(this.test_baseCaseMultipleCertificates(dirs));
        tests.add(this.test_wrongUserId(dirs));
        tests.add(this.test_noUserId(dirs));
        tests.add(this.test_unboundUserId(dirs));
        tests.addAll(this.test_baseCaseMultiUserIds(dirs));
        tests.add(this.test_secretKeyMaterial(dirs));
        tests.add(this.test_randomBytes(dirs));
        tests.add(this.test_missingCertificate(dirs));
        return new TestSuite("0.1", tests);
    }

    private TestCase test_baseCase(WkdDirectoryStructure directoryStructure) throws Exception {
        String lookupMail = "base-case@" + this.domain;
        String userId = "WKD-Test Base Case <base-case@" + this.domain + ">";
        String description = "Certificate has a single, valid user-id '" + userId + "'";
        final OpenPGPCertificate publicKeys = this.certificate(userId);
        this.writeDataFor(lookupMail, directoryStructure, new AbstractTestSuiteGenerator.DataSink(){

            @Override
            public void write(OutputStream outputStream) throws IOException {
                outputStream.write(publicKeys.getEncoded());
            }
        });
        return TestCase.ok("Base Case", description, lookupMail, directoryStructure);
    }

    private List<TestCase> test_baseCaseMultiUserIds(WkdDirectoryStructure directoryStructure) throws Exception {
        String primaryLookupMail = "primary-uid@" + this.domain;
        String secondaryLookupMail = "secondary-uid@" + this.domain;
        String primaryUserId = "WKD-Test Primary User-ID <" + primaryLookupMail + ">";
        String secondaryUserId = "WKD-Test Secondary User-ID <" + secondaryLookupMail + ">";
        String primaryDescription = "Certificate has multiple, valid user-ids. Is looked up via primary user-id '" + primaryUserId + "' using mail address '" + primaryLookupMail + "'.";
        String secondaryDescription = "Certificate has multiple, valid user-ids. Is looked up via secondary user-id '" + secondaryUserId + "' using mail address '" + secondaryLookupMail + "'.";
        OpenPGPKey secretKeys = this.secretKey(primaryUserId);
        UnprotectedKeysProtector protector = SecretKeyRingProtector.unprotectedKeys();
        secretKeys = PGPainless.getInstance().modify(secretKeys).addUserId((CharSequence)secondaryUserId, (SecretKeyRingProtector)protector).done();
        final OpenPGPCertificate publicKeys = secretKeys.toCertificate();
        AbstractTestSuiteGenerator.DataSink sink = new AbstractTestSuiteGenerator.DataSink(){

            @Override
            public void write(OutputStream outputStream) throws IOException {
                outputStream.write(publicKeys.getEncoded());
            }
        };
        this.writeDataFor(primaryLookupMail, directoryStructure, sink);
        this.writeDataFor(secondaryLookupMail, directoryStructure, sink);
        return Arrays.asList(TestCase.ok("Multi-User-ID - Primary User-ID Lookup", primaryDescription, primaryLookupMail, directoryStructure), TestCase.ok("Multi-User-ID - Secondary User-ID Lookup", secondaryDescription, secondaryLookupMail, directoryStructure));
    }

    private TestCase test_baseCaseMultipleCertificates(WkdDirectoryStructure directoryStructure) throws Exception {
        String title = "Multiple Certificates";
        String description = "The result contains multiple certificates.";
        String lookupMail = "multiple-certificates@" + this.domain;
        String userId1 = "First Certificate <" + lookupMail + ">";
        String userId2 = "Second Certificate <" + lookupMail + ">";
        final OpenPGPCertificate cert1 = this.certificate(userId1);
        final OpenPGPCertificate cert2 = this.certificate(userId2);
        this.writeDataFor(lookupMail, directoryStructure, new AbstractTestSuiteGenerator.DataSink(){

            @Override
            public void write(OutputStream outputStream) throws IOException {
                outputStream.write(cert1.getEncoded());
                outputStream.write(cert2.getEncoded());
            }
        });
        return TestCase.ok(title, description, lookupMail, directoryStructure);
    }

    private TestCase test_wrongUserId(WkdDirectoryStructure directoryStructure) throws Exception {
        String lookupMail = "wrong-userid@" + this.domain;
        String userId = "WKD-Test Different User-ID <different-userid@" + this.domain + ">";
        String description = "Certificate has a single, valid user-id '" + userId + "', but is deposited for mail address '" + lookupMail + "'.";
        final OpenPGPCertificate publicKeys = this.certificate(userId);
        this.writeDataFor(lookupMail, directoryStructure, new AbstractTestSuiteGenerator.DataSink(){

            @Override
            public void write(OutputStream outputStream) throws IOException {
                outputStream.write(publicKeys.getEncoded());
            }
        });
        return TestCase.fail("Wrong User-ID", description, lookupMail, directoryStructure);
    }

    private TestCase test_unboundUserId(WkdDirectoryStructure directoryStructure) throws Exception {
        String lookupMail = "unbound-userid@" + this.domain;
        String userId = "WKD-Test Unbound User-ID <" + lookupMail + ">";
        String description = "Certificate has a single User-ID '" + userId + "' without binding signature.";
        OpenPGPCertificate publicKeys = this.certificate(userId);
        Iterator keyIterator = publicKeys.getPGPPublicKeyRing().iterator();
        PGPPublicKey primaryKey = (PGPPublicKey)keyIterator.next();
        Iterator bindingSigs = primaryKey.getSignaturesForID(userId);
        while (bindingSigs.hasNext()) {
            primaryKey = PGPPublicKey.removeCertification((PGPPublicKey)primaryKey, (String)userId, (PGPSignature)((PGPSignature)bindingSigs.next()));
        }
        ArrayList<PGPPublicKey> keys = new ArrayList<PGPPublicKey>();
        keys.add(primaryKey);
        while (keyIterator.hasNext()) {
            keys.add((PGPPublicKey)keyIterator.next());
        }
        final PGPPublicKeyRing certificateWithoutUserIdBinding = new PGPPublicKeyRing(keys);
        this.writeDataFor(lookupMail, directoryStructure, new AbstractTestSuiteGenerator.DataSink(){

            @Override
            public void write(OutputStream outputStream) throws IOException {
                certificateWithoutUserIdBinding.encode(outputStream);
            }
        });
        return TestCase.fail("Unbound UserId", description, lookupMail, directoryStructure);
    }

    private TestCase test_noUserId(WkdDirectoryStructure directoryStructure) throws Exception {
        String lookupMail = "absent-userid@" + this.domain;
        String description = "Certificate has no user-id, but is deposited for mail address '" + lookupMail + "'.";
        OpenPGPCertificate certificate = this.certificate("DeleteMe");
        PGPPublicKeyRing publicKeys = certificate.getPGPPublicKeyRing();
        ArrayList<PGPPublicKey> keys = new ArrayList<PGPPublicKey>();
        Iterator publicKeyIterator = publicKeys.iterator();
        PGPPublicKey primaryKey = (PGPPublicKey)publicKeyIterator.next();
        primaryKey = PGPPublicKey.removeCertification((PGPPublicKey)primaryKey, (String)"DeleteMe");
        keys.add(primaryKey);
        while (publicKeyIterator.hasNext()) {
            keys.add((PGPPublicKey)publicKeyIterator.next());
        }
        final PGPPublicKeyRing finalPublicKeys = publicKeys = new PGPPublicKeyRing(keys);
        this.writeDataFor(lookupMail, directoryStructure, new AbstractTestSuiteGenerator.DataSink(){

            @Override
            public void write(OutputStream outputStream) throws IOException {
                finalPublicKeys.encode(outputStream);
            }
        });
        return TestCase.fail("No User-ID", description, lookupMail, directoryStructure);
    }

    private TestCase test_secretKeyMaterial(WkdDirectoryStructure directoryStructure) throws Exception {
        String lookupMail = "test-secret-key@" + this.domain;
        String description = "Certificate file contains secret key material.";
        final OpenPGPKey secretKeys = this.secretKey("WKD-Test Secret Key <" + lookupMail + ">");
        this.writeDataFor(lookupMail, directoryStructure, new AbstractTestSuiteGenerator.DataSink(){

            @Override
            public void write(OutputStream outputStream) throws IOException {
                outputStream.write(secretKeys.getEncoded());
            }
        });
        return TestCase.fail("Secret Key Material", description, lookupMail, directoryStructure);
    }

    private TestCase test_randomBytes(WkdDirectoryStructure directoryStructure) throws IOException {
        String lookupMail = "random-bytes@" + this.domain;
        String description = "Certificate file contains random bytes.";
        Random random = new Random();
        this.writeDataFor(lookupMail, directoryStructure, outputStream -> {
            byte[] buf = new byte[random.nextInt(65536)];
            random.nextBytes(buf);
            outputStream.write(buf);
        });
        return TestCase.fail("Random Bytes", description, lookupMail, directoryStructure);
    }

    private TestCase test_missingCertificate(WkdDirectoryStructure dirs) {
        String lookupMail = "missing-cert@" + this.domain;
        String title = "Missing certificate";
        String description = "There is no certificate for the lookup mail address '" + lookupMail + "'.";
        return TestCase.fail(title, description, lookupMail, dirs);
    }
}

