/*
 * Decompiled with CFR 0.152.
 */
package pgp.wkd.test_suite;

import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.nio.file.Path;
import pgp.wkd.WKDAddress;

public abstract class WkdDirectoryStructure {
    protected final String domain;
    protected final File rootDir;
    protected final File wellKnown;
    protected final File openpgpkey;

    public WkdDirectoryStructure(File rootDirectory, String domain) {
        this.domain = domain;
        this.rootDir = rootDirectory;
        this.wellKnown = new File(rootDirectory, ".well-known");
        this.openpgpkey = new File(this.wellKnown, "openpgpkey");
    }

    public abstract Path getRelativeCertificatePath(String var1);

    public abstract void mkdirs() throws IOException;

    protected void mkdir(File dir) throws IOException {
        if (!dir.exists() && !dir.mkdirs()) {
            throw new IOException("Cannot create directory '" + dir.getAbsolutePath() + "'.");
        }
        if (dir.isFile()) {
            throw new IOException("Cannot create directory '" + dir.getAbsolutePath() + "': Is a file.");
        }
    }

    protected void touch(File file) throws IOException {
        if (!file.exists() && !file.createNewFile()) {
            throw new IOException("Cannot create file '" + file.getAbsolutePath() + "'.");
        }
        if (!file.isFile()) {
            throw new IOException("Cannot create file '" + file.getAbsolutePath() + "': Is not a file.");
        }
    }

    public abstract URI getAddress(String var1);

    public abstract File resolve(Path var1);

    public static class AdvancedMethod
    extends WkdDirectoryStructure {
        private final File domainFile;
        private final File hu;
        private final File policy;

        public AdvancedMethod(File rootDir, String domain) {
            super(rootDir, domain);
            this.domainFile = new File(this.openpgpkey, domain);
            this.hu = new File(this.domainFile, "hu");
            this.policy = new File(this.domainFile, "policy");
        }

        @Override
        public Path getRelativeCertificatePath(String mailAddress) {
            WKDAddress address = WKDAddress.fromEmail((String)mailAddress);
            String path = address.getAdvancedMethodURI().getPath();
            String fileName = path.substring(path.lastIndexOf(47) + 1);
            return this.rootDir.toPath().relativize(new File(this.hu, fileName).toPath());
        }

        @Override
        public void mkdirs() throws IOException {
            this.mkdir(this.rootDir);
            this.mkdir(this.wellKnown);
            this.mkdir(this.openpgpkey);
            this.mkdir(this.domainFile);
            this.mkdir(this.hu);
            this.touch(this.policy);
        }

        @Override
        public URI getAddress(String mail) {
            return WKDAddress.fromEmail((String)mail).getAdvancedMethodURI();
        }

        @Override
        public File resolve(Path path) {
            return this.rootDir.toPath().resolve(path).toFile();
        }
    }

    public static class DirectMethod
    extends WkdDirectoryStructure {
        private final File hu;
        private final File policy;

        public DirectMethod(File rootDirectory, String domain) {
            super(rootDirectory, domain);
            this.hu = new File(this.openpgpkey, "hu");
            this.policy = new File(this.openpgpkey, "policy");
        }

        @Override
        public Path getRelativeCertificatePath(String mailAddress) {
            WKDAddress address = WKDAddress.fromEmail((String)mailAddress);
            String path = address.getDirectMethodURI().getPath();
            String fileName = path.substring(path.lastIndexOf(47) + 1);
            return this.rootDir.toPath().relativize(new File(this.hu, fileName).toPath());
        }

        @Override
        public void mkdirs() throws IOException {
            this.mkdir(this.rootDir);
            this.mkdir(this.wellKnown);
            this.mkdir(this.openpgpkey);
            this.mkdir(this.hu);
            this.touch(this.policy);
        }

        @Override
        public URI getAddress(String mail) {
            return WKDAddress.fromEmail((String)mail).getDirectMethodURI();
        }

        @Override
        public File resolve(Path path) {
            return this.rootDir.toPath().resolve(path).toFile();
        }
    }
}

