/*
 * Decompiled with CFR 0.152.
 */
package org.pgpainless.wot.query;

import java.util.Date;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.test.AssertionsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.function.Executable;
import org.pgpainless.wot.dsl.NetworkDSL;
import org.pgpainless.wot.network.Edge;
import org.pgpainless.wot.network.Identifier;
import org.pgpainless.wot.network.Network;
import org.pgpainless.wot.network.Node;
import org.pgpainless.wot.network.RegexSet;
import org.pgpainless.wot.network.TrustDepth;
import org.pgpainless.wot.query.Path;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0002\b\b\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0011\u001a\u00020\u0012H\u0007J\b\u0010\u0013\u001a\u00020\u0012H\u0007J\b\u0010\u0014\u001a\u00020\u0012H\u0007J\b\u0010\u0015\u001a\u00020\u0012H\u0007J\b\u0010\u0016\u001a\u00020\u0012H\u0007J\b\u0010\u0017\u001a\u00020\u0012H\u0007J\b\u0010\u0018\u001a\u00020\u0012H\u0007J\b\u0010\u0019\u001a\u00020\u0012H\u0007R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Lorg/pgpainless/wot/query/PathTest;", "Lorg/pgpainless/wot/dsl/NetworkDSL;", "()V", "alice", "Lorg/pgpainless/wot/network/Node;", "alice_bob", "Lorg/pgpainless/wot/network/Edge$Delegation;", "alice_bob_depth_1", "alice_root", "bob", "bob_selfsig", "Lorg/pgpainless/wot/network/Edge$Certification;", "root", "root_alice__fully_trusted", "root_alice__marginally_trusted", "root_root", "root_selfsig", "longer path that ends in a selfsig", "", "trust root binding its identity is fine", "verify that a Path cannot point to its own root via a delegation", "verify that an empty Path is properly initialized", "verify that append()ing a component fails if it exceeds the Path's depth", "verify that append()ing a component fails of the result would contain cycles", "verify that append()ing a component whose issuer mismatches the target of the Path fails", "verify that append()ing multiple components properly changes the trust amount of the Path", "wot-dijkstra_test"})
@SourceDebugExtension(value={"SMAP\nPathTest.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PathTest.kt\norg/pgpainless/wot/query/PathTest\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 Assertions.kt\norg/junit/jupiter/api/AssertionsKt\n*L\n1#1,130:1\n1#2:131\n100#3,7:132\n100#3,7:139\n100#3,7:146\n100#3,7:153\n*S KotlinDebug\n*F\n+ 1 PathTest.kt\norg/pgpainless/wot/query/PathTest\n*L\n89#1:132,7\n98#1:139,7\n108#1:146,7\n126#1:153,7\n*E\n"})
public final class PathTest
implements NetworkDSL {
    @NotNull
    private final Node root = this.Node("aabbccddeeAABBCCDDEEaabbccddeeAABBCCDDEE");
    @NotNull
    private final Node alice = this.Node("0000000000000000000000000000000000000000");
    @NotNull
    private final Node bob = this.Node("1111111111111111111111111111111111111111");
    @NotNull
    private final Edge.Delegation root_alice__fully_trusted = this.Delegation(this.root, this.alice, 255, TrustDepth.Companion.unlimited());
    @NotNull
    private final Edge.Delegation root_alice__marginally_trusted = this.Delegation(this.root, this.alice, 60, TrustDepth.Companion.limited(0));
    @NotNull
    private final Edge.Delegation alice_root = this.Delegation(this.alice, this.root, 255, TrustDepth.Companion.unlimited());
    @NotNull
    private final Edge.Delegation alice_bob = this.Delegation(this.alice, this.bob);
    @NotNull
    private final Edge.Delegation alice_bob_depth_1 = this.Delegation(this.alice, this.bob, 120, TrustDepth.Companion.auto(1));
    @NotNull
    private final Edge.Delegation root_root = this.Delegation(this.root, this.root, 120, TrustDepth.Companion.limited(1));
    @NotNull
    private final Edge.Certification root_selfsig = this.Certification(this.root, this.root, "root@example.org");
    @NotNull
    private final Edge.Certification bob_selfsig = this.Certification(this.bob, this.bob, "bob@example.org");

    @Test
    public final void longer path that ends in a selfsig() {
        Path path = new Path(this.root);
        path.append((Edge.Component)this.root_alice__fully_trusted);
        path.append((Edge.Component)this.alice_bob_depth_1);
        path.append((Edge.Component)this.bob_selfsig);
        AssertionsKt.assertEquals$default((Object)120, (Object)path.getAmount(), null, (int)4, null);
        AssertionsKt.assertEquals$default((Object)0, (Object)path.getResidualDepth().getValue(), null, (int)4, null);
    }

    @Test
    public final void verify that an empty Path is properly initialized() {
        Path empty = new Path(this.root);
        AssertionsKt.assertEquals$default((Object)this.root, (Object)empty.getTarget(), null, (int)4, null);
        AssertionsKt.assertEquals$default((Object)CollectionsKt.listOf((Object)this.root), (Object)empty.getCertificates(), null, (int)4, null);
        AssertionsKt.assertEquals$default((Object)1, (Object)empty.getLength(), null, (int)4, null);
        AssertionsKt.assertEquals$default((Object)120, (Object)empty.getAmount(), null, (int)4, null);
        String string = null;
        boolean bl = false;
        AssertionsKt.assertTrue((boolean)empty.getCertifications().isEmpty(), string);
    }

    @Test
    public final void verify that append()ing multiple components properly changes the trust amount of the Path() {
        Path path = new Path(this.root);
        AssertionsKt.assertEquals$default((Object)1, (Object)path.getLength(), null, (int)4, null);
        AssertionsKt.assertEquals$default((Object)120, (Object)path.getAmount(), null, (int)4, null);
        path.append((Edge.Component)this.root_alice__fully_trusted);
        AssertionsKt.assertEquals$default((Object)CollectionsKt.listOf((Object)this.root_alice__fully_trusted), (Object)path.getCertifications(), null, (int)4, null);
        Object[] objectArray = new Node[]{this.root, this.alice};
        AssertionsKt.assertEquals$default((Object)CollectionsKt.listOf((Object[])objectArray), (Object)path.getCertificates(), null, (int)4, null);
        AssertionsKt.assertEquals$default((Object)this.alice, (Object)path.getTarget(), null, (int)4, null);
        AssertionsKt.assertEquals$default((Object)2, (Object)path.getLength(), null, (int)4, null);
        AssertionsKt.assertEquals$default((Object)255, (Object)path.getAmount(), null, (int)4, null);
        path.append((Edge.Component)this.alice_bob);
        objectArray = new Edge.Delegation[]{this.root_alice__fully_trusted, this.alice_bob};
        AssertionsKt.assertEquals$default((Object)CollectionsKt.listOf((Object[])objectArray), (Object)path.getCertifications(), null, (int)4, null);
        objectArray = new Node[]{this.root, this.alice, this.bob};
        AssertionsKt.assertEquals$default((Object)CollectionsKt.listOf((Object[])objectArray), (Object)path.getCertificates(), null, (int)4, null);
        AssertionsKt.assertEquals$default((Object)this.bob, (Object)path.getTarget(), null, (int)4, null);
        AssertionsKt.assertEquals$default((Object)3, (Object)path.getLength(), null, (int)4, null);
        AssertionsKt.assertEquals$default((Object)120, (Object)path.getAmount(), null, (int)4, null);
    }

    @Test
    public final void verify that append()ing a component whose issuer mismatches the target of the Path fails() {
        Throwable throwable;
        Throwable throwable2;
        Path path = new Path(this.root);
        AssertionsKt.assertEquals$default((Object)CollectionsKt.listOf((Object)this.root), (Object)path.getCertificates(), null, (int)4, null);
        AssertionsKt.assertEquals$default((Object)1, (Object)path.getLength(), null, (int)4, null);
        boolean $i$f$assertThrows = false;
        try {
            boolean bl = false;
            path.append((Edge.Component)this.alice_bob);
            throwable2 = Unit.INSTANCE;
        }
        catch (Throwable caught$iv) {
            throwable2 = caught$iv;
        }
        if (!((throwable = throwable2) instanceof Throwable)) {
            throwable = null;
        }
        Throwable throwable$iv = throwable;
        Intrinsics.checkExpressionValueIsNotNull((Object)Assertions.assertThrows(IllegalArgumentException.class, (Executable)new Executable(throwable$iv){
            final /* synthetic */ Throwable $throwable;
            {
                this.$throwable = throwable;
            }

            public final void execute() {
                if (this.$throwable != null) {
                    throw this.$throwable;
                }
            }
        }), (String)"Assertions.assertThrows(\u2026throwable\n        }\n    }");
    }

    @Test
    public final void verify that append()ing a component fails if it exceeds the Path's depth() {
        Throwable throwable;
        Throwable throwable2;
        Path path = new Path(this.root);
        path.append((Edge.Component)this.root_alice__marginally_trusted);
        AssertionsKt.assertEquals$default((Object)60, (Object)path.getAmount(), null, (int)4, null);
        boolean $i$f$assertThrows = false;
        try {
            boolean bl = false;
            path.append((Edge.Component)this.alice_bob);
            throwable2 = Unit.INSTANCE;
        }
        catch (Throwable caught$iv) {
            throwable2 = caught$iv;
        }
        if (!((throwable = throwable2) instanceof Throwable)) {
            throwable = null;
        }
        Throwable throwable$iv = throwable;
        Intrinsics.checkExpressionValueIsNotNull((Object)Assertions.assertThrows(IllegalArgumentException.class, (Executable)new Executable(throwable$iv){
            final /* synthetic */ Throwable $throwable;
            {
                this.$throwable = throwable;
            }

            public final void execute() {
                if (this.$throwable != null) {
                    throw this.$throwable;
                }
            }
        }), (String)"Assertions.assertThrows(\u2026throwable\n        }\n    }");
    }

    @Test
    public final void verify that append()ing a component fails of the result would contain cycles() {
        Throwable throwable;
        Throwable throwable2;
        Path path = new Path(this.root);
        path.append((Edge.Component)this.root_alice__fully_trusted);
        boolean $i$f$assertThrows = false;
        try {
            boolean bl = false;
            path.append((Edge.Component)this.alice_root);
            throwable2 = Unit.INSTANCE;
        }
        catch (Throwable caught$iv) {
            throwable2 = caught$iv;
        }
        if (!((throwable = throwable2) instanceof Throwable)) {
            throwable = null;
        }
        Throwable throwable$iv = throwable;
        Intrinsics.checkExpressionValueIsNotNull((Object)Assertions.assertThrows(IllegalArgumentException.class, (Executable)new Executable(throwable$iv){
            final /* synthetic */ Throwable $throwable;
            {
                this.$throwable = throwable;
            }

            public final void execute() {
                if (this.$throwable != null) {
                    throw this.$throwable;
                }
            }
        }), (String)"Assertions.assertThrows(\u2026throwable\n        }\n    }");
    }

    @Test
    public final void trust root binding its identity is fine() {
        Path path = new Path(this.root);
        path.append((Edge.Component)this.root_selfsig);
        AssertionsKt.assertEquals$default((Object)2, (Object)path.getLength(), null, (int)4, null);
    }

    @Test
    public final void verify that a Path cannot point to its own root via a delegation() {
        Throwable throwable;
        Throwable throwable2;
        Path path = new Path(this.root);
        boolean $i$f$assertThrows = false;
        try {
            boolean bl = false;
            path.append((Edge.Component)this.root_root);
            throwable2 = Unit.INSTANCE;
        }
        catch (Throwable caught$iv) {
            throwable2 = caught$iv;
        }
        if (!((throwable = throwable2) instanceof Throwable)) {
            throwable = null;
        }
        Throwable throwable$iv = throwable;
        Intrinsics.checkExpressionValueIsNotNull((Object)Assertions.assertThrows(IllegalArgumentException.class, (Executable)new Executable(throwable$iv){
            final /* synthetic */ Throwable $throwable;
            {
                this.$throwable = throwable;
            }

            public final void execute() {
                if (this.$throwable != null) {
                    throw this.$throwable;
                }
            }
        }), (String)"Assertions.assertThrows(\u2026throwable\n        }\n    }");
    }

    @NotNull
    public Edge.Certification Certification(@NotNull Node issuer, @NotNull Node target, @NotNull String userId) {
        return NetworkDSL.DefaultImpls.Certification((NetworkDSL)this, (Node)issuer, (Node)target, (String)userId);
    }

    @NotNull
    public Edge.Certification Certification(@NotNull Node issuer, @NotNull Node target, @NotNull String targetUserId, @NotNull Date creationTime) {
        return NetworkDSL.DefaultImpls.Certification((NetworkDSL)this, (Node)issuer, (Node)target, (String)targetUserId, (Date)creationTime);
    }

    @NotNull
    public Edge.Delegation Delegation(@NotNull Node issuer, @NotNull Node target) {
        return NetworkDSL.DefaultImpls.Delegation((NetworkDSL)this, (Node)issuer, (Node)target);
    }

    @NotNull
    public Edge.Delegation Delegation(@NotNull Node issuer, @NotNull Node target, @NotNull Date creationTime) {
        return NetworkDSL.DefaultImpls.Delegation((NetworkDSL)this, (Node)issuer, (Node)target, (Date)creationTime);
    }

    @NotNull
    public Edge.Delegation Delegation(@NotNull Node issuer, @NotNull Node target, int amount, int depth) {
        return NetworkDSL.DefaultImpls.Delegation((NetworkDSL)this, (Node)issuer, (Node)target, (int)amount, (int)depth);
    }

    @NotNull
    public Edge.Delegation Delegation(@NotNull Node issuer, @NotNull Node target, int amount, @NotNull TrustDepth depth) {
        return NetworkDSL.DefaultImpls.Delegation((NetworkDSL)this, (Node)issuer, (Node)target, (int)amount, (TrustDepth)depth);
    }

    @NotNull
    public Node Node(@NotNull String fingerprint) {
        return NetworkDSL.DefaultImpls.Node((NetworkDSL)this, (String)fingerprint);
    }

    @NotNull
    public Node Node(@NotNull String fingerprint, @NotNull String userId) {
        return NetworkDSL.DefaultImpls.Node((NetworkDSL)this, (String)fingerprint, (String)userId);
    }

    @NotNull
    public Node Node(@NotNull Node original, @NotNull String userId) {
        return NetworkDSL.DefaultImpls.Node((NetworkDSL)this, (Node)original, (String)userId);
    }

    @NotNull
    public Network buildNetwork(@NotNull Function1<? super Network.Builder, Unit> builderAction) {
        return NetworkDSL.DefaultImpls.buildNetwork((NetworkDSL)this, builderAction);
    }

    @NotNull
    public RegexSet domainRegex(@NotNull String domain) {
        return NetworkDSL.DefaultImpls.domainRegex((NetworkDSL)this, (String)domain);
    }

    @NotNull
    public Network.Builder addEdge(@NotNull Network.Builder $this$addEdge, @NotNull String issuer, @NotNull String target) {
        return NetworkDSL.DefaultImpls.addEdge((NetworkDSL)this, (Network.Builder)$this$addEdge, (String)issuer, (String)target);
    }

    @NotNull
    public Network.Builder addEdge(@NotNull Network.Builder $this$addEdge, @NotNull String issuer, @NotNull String target, @NotNull String userId) {
        return NetworkDSL.DefaultImpls.addEdge((NetworkDSL)this, (Network.Builder)$this$addEdge, (String)issuer, (String)target, (String)userId);
    }

    @NotNull
    public Network.Builder addNode(@NotNull Network.Builder $this$addNode, @NotNull String fingerprint) {
        return NetworkDSL.DefaultImpls.addNode((NetworkDSL)this, (Network.Builder)$this$addNode, (String)fingerprint);
    }

    @NotNull
    public Network.Builder addNode(@NotNull Network.Builder $this$addNode, @NotNull String fingerprint, @NotNull String userId) {
        return NetworkDSL.DefaultImpls.addNode((NetworkDSL)this, (Network.Builder)$this$addNode, (String)fingerprint, (String)userId);
    }

    public void addNodes(@NotNull Network.Builder $this$addNodes, String ... fingerprints) {
        NetworkDSL.DefaultImpls.addNodes((NetworkDSL)this, (Network.Builder)$this$addNodes, (String[])fingerprints);
    }

    public boolean assertNodeFingerprints(@NotNull Path $this$assertNodeFingerprints, @NotNull List<Identifier> fingerprints) {
        return NetworkDSL.DefaultImpls.assertNodeFingerprints((NetworkDSL)this, (Path)$this$assertNodeFingerprints, fingerprints);
    }

    @NotNull
    public Network.Builder buildEdge(@NotNull Network.Builder $this$buildEdge, @NotNull String issuer, @NotNull String target) {
        return NetworkDSL.DefaultImpls.buildEdge((NetworkDSL)this, (Network.Builder)$this$buildEdge, (String)issuer, (String)target);
    }

    @NotNull
    public Network.Builder buildEdge(@NotNull Network.Builder $this$buildEdge, @NotNull String issuer, @NotNull String target, int amount, int depth) {
        return NetworkDSL.DefaultImpls.buildEdge((NetworkDSL)this, (Network.Builder)$this$buildEdge, (String)issuer, (String)target, (int)amount, (int)depth);
    }

    @NotNull
    public Network.Builder buildEdge(@NotNull Network.Builder $this$buildEdge, @NotNull String issuer, @NotNull String target, int amount, int depth, @NotNull RegexSet regexSet) {
        return NetworkDSL.DefaultImpls.buildEdge((NetworkDSL)this, (Network.Builder)$this$buildEdge, (String)issuer, (String)target, (int)amount, (int)depth, (RegexSet)regexSet);
    }

    @NotNull
    public Network.Builder buildEdge(@NotNull Network.Builder $this$buildEdge, @NotNull String issuer, @NotNull String target, @NotNull String userId) {
        return NetworkDSL.DefaultImpls.buildEdge((NetworkDSL)this, (Network.Builder)$this$buildEdge, (String)issuer, (String)target, (String)userId);
    }

    @Nullable
    public List<Edge.Component> getEdgeFor(@NotNull Network $this$getEdgeFor, @NotNull String issuer, @NotNull String target) {
        return NetworkDSL.DefaultImpls.getEdgeFor((NetworkDSL)this, (Network)$this$getEdgeFor, (String)issuer, (String)target);
    }

    @Nullable
    public List<Edge.Component> getEdgeFor(@NotNull Network $this$getEdgeFor, @NotNull String issuer, @NotNull String target, @Nullable String userId) {
        return NetworkDSL.DefaultImpls.getEdgeFor((NetworkDSL)this, (Network)$this$getEdgeFor, (String)issuer, (String)target, (String)userId);
    }

    @Nullable
    public List<Edge.Component> getEdgeFor(@NotNull Network $this$getEdgeFor, @NotNull Identifier issuer, @NotNull Identifier target) {
        return NetworkDSL.DefaultImpls.getEdgeFor((NetworkDSL)this, (Network)$this$getEdgeFor, (Identifier)issuer, (Identifier)target);
    }

    @NotNull
    public List<Edge.Component> getEdgeFor(@NotNull Network $this$getEdgeFor, @NotNull Identifier issuer, @NotNull Identifier target, @Nullable String userId) {
        return NetworkDSL.DefaultImpls.getEdgeFor((NetworkDSL)this, (Network)$this$getEdgeFor, (Identifier)issuer, (Identifier)target, (String)userId);
    }

    @Nullable
    public Edge getEdgesFor(@NotNull Network $this$getEdgesFor, @NotNull String issuer, @NotNull String target) {
        return NetworkDSL.DefaultImpls.getEdgesFor((NetworkDSL)this, (Network)$this$getEdgesFor, (String)issuer, (String)target);
    }

    @Nullable
    public Edge getEdgesFor(@NotNull Network $this$getEdgesFor, @NotNull Identifier issuer, @NotNull Identifier target) {
        return NetworkDSL.DefaultImpls.getEdgesFor((NetworkDSL)this, (Network)$this$getEdgesFor, (Identifier)issuer, (Identifier)target);
    }

    @NotNull
    public Date plusDays(@NotNull Date $this$plusDays, long days) {
        return NetworkDSL.DefaultImpls.plusDays((NetworkDSL)this, (Date)$this$plusDays, (long)days);
    }

    @NotNull
    public Date plusHours(@NotNull Date $this$plusHours, long hours) {
        return NetworkDSL.DefaultImpls.plusHours((NetworkDSL)this, (Date)$this$plusHours, (long)hours);
    }

    @NotNull
    public Date plusMillis(@NotNull Date $this$plusMillis, long millis) {
        return NetworkDSL.DefaultImpls.plusMillis((NetworkDSL)this, (Date)$this$plusMillis, (long)millis);
    }

    @NotNull
    public Date plusMinutes(@NotNull Date $this$plusMinutes, long minutes) {
        return NetworkDSL.DefaultImpls.plusMinutes((NetworkDSL)this, (Date)$this$plusMinutes, (long)minutes);
    }

    @NotNull
    public Date plusSeconds(@NotNull Date $this$plusSeconds, long seconds) {
        return NetworkDSL.DefaultImpls.plusSeconds((NetworkDSL)this, (Date)$this$plusSeconds, (long)seconds);
    }
}

