/*
 * Decompiled with CFR 0.152.
 */
package org.pgpainless.wot.query;

import java.util.Date;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.test.AssertionsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.function.Executable;
import org.pgpainless.wot.dsl.NetworkDSL;
import org.pgpainless.wot.network.Edge;
import org.pgpainless.wot.network.Identifier;
import org.pgpainless.wot.network.Network;
import org.pgpainless.wot.network.Node;
import org.pgpainless.wot.network.RegexSet;
import org.pgpainless.wot.network.TrustDepth;
import org.pgpainless.wot.query.Path;
import org.pgpainless.wot.query.Paths;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\t\u001a\u00020\nH\u0007J\b\u0010\u000b\u001a\u00020\nH\u0007J\b\u0010\f\u001a\u00020\nH\u0007J\b\u0010\r\u001a\u00020\nH\u0007R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lorg/pgpainless/wot/query/PathsTest;", "Lorg/pgpainless/wot/dsl/NetworkDSL;", "()V", "alice", "Lorg/pgpainless/wot/network/Node;", "alice_bob_1", "Lorg/pgpainless/wot/network/Edge$Delegation;", "alice_bob_2", "bob", "verify that a Path cannot be added if its amount is less than the method argument armound", "", "verify that an empty Paths object has an amount of zero", "verify that the amount of a Paths containing a single Path equals the Path's amount", "verify that the amounts of two Path objects sum up", "wot-dijkstra_test"})
@SourceDebugExtension(value={"SMAP\nPathsTest.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PathsTest.kt\norg/pgpainless/wot/query/PathsTest\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 Assertions.kt\norg/junit/jupiter/api/AssertionsKt\n*L\n1#1,55:1\n1#2:56\n100#3,7:57\n*S KotlinDebug\n*F\n+ 1 PathsTest.kt\norg/pgpainless/wot/query/PathsTest\n*L\n51#1:57,7\n*E\n"})
public final class PathsTest
implements NetworkDSL {
    @NotNull
    private final Node alice = this.Node("0000000000000000000000000000000000000000");
    @NotNull
    private final Node bob = this.Node("1111111111111111111111111111111111111111");
    @NotNull
    private final Edge.Delegation alice_bob_1 = this.Delegation(this.alice, this.bob, 140, TrustDepth.Companion.unlimited());
    @NotNull
    private final Edge.Delegation alice_bob_2 = this.Delegation(this.alice, this.bob, 160, TrustDepth.Companion.limited(1));

    @Test
    public final void verify that an empty Paths object has an amount of zero() {
        Paths empty = new Paths();
        AssertionsKt.assertEquals$default((Object)0, (Object)empty.getAmount(), null, (int)4, null);
    }

    @Test
    public final void verify that the amount of a Paths containing a single Path equals the Path's amount() {
        Paths paths;
        Path path;
        Path $this$verify_that_the_amount_of_a_Paths_containing_a_single_Path_equals_the_Path_s_amount_u24lambda_u240 = path = new Path(this.alice);
        boolean bl = false;
        $this$verify_that_the_amount_of_a_Paths_containing_a_single_Path_equals_the_Path_s_amount_u24lambda_u240.append((Edge.Component)this.alice_bob_1);
        Path path2 = path;
        Paths $this$verify_that_the_amount_of_a_Paths_containing_a_single_Path_equals_the_Path_s_amount_u24lambda_u241 = paths = new Paths();
        boolean bl2 = false;
        $this$verify_that_the_amount_of_a_Paths_containing_a_single_Path_equals_the_Path_s_amount_u24lambda_u241.add(path2, 140);
        Paths single = paths;
        AssertionsKt.assertEquals$default((Object)140, (Object)single.getAmount(), null, (int)4, null);
    }

    @Test
    public final void verify that the amounts of two Path objects sum up() {
        Paths paths;
        Path path;
        Path $this$verify_that_the_amounts_of_two_Path_objects_sum_up_u24lambda_u242 = path = new Path(this.alice);
        boolean bl = false;
        $this$verify_that_the_amounts_of_two_Path_objects_sum_up_u24lambda_u242.append((Edge.Component)this.alice_bob_1);
        Path path1 = path;
        Path $this$verify_that_the_amounts_of_two_Path_objects_sum_up_u24lambda_u243 = $this$verify_that_the_amounts_of_two_Path_objects_sum_up_u24lambda_u242 = new Path(this.alice);
        boolean bl2 = false;
        $this$verify_that_the_amounts_of_two_Path_objects_sum_up_u24lambda_u243.append((Edge.Component)this.alice_bob_2);
        Path path2 = $this$verify_that_the_amounts_of_two_Path_objects_sum_up_u24lambda_u242;
        Paths $this$verify_that_the_amounts_of_two_Path_objects_sum_up_u24lambda_u244 = paths = new Paths();
        boolean bl3 = false;
        $this$verify_that_the_amounts_of_two_Path_objects_sum_up_u24lambda_u244.add(path1, 140);
        $this$verify_that_the_amounts_of_two_Path_objects_sum_up_u24lambda_u244.add(path2, 160);
        Paths twoPaths = paths;
        AssertionsKt.assertEquals$default((Object)300, (Object)twoPaths.getAmount(), null, (int)4, null);
    }

    @Test
    public final void verify that a Path cannot be added if its amount is less than the method argument armound() {
        Throwable throwable;
        Throwable throwable2;
        Path path;
        Path $this$verify_that_a_Path_cannot_be_added_if_its_amount_is_less_than_the_method_argument_armound_u24lambda_u245 = path = new Path(this.alice);
        boolean bl = false;
        $this$verify_that_a_Path_cannot_be_added_if_its_amount_is_less_than_the_method_argument_armound_u24lambda_u245.append((Edge.Component)this.alice_bob_1);
        Path path2 = path;
        Paths paths = new Paths();
        boolean $i$f$assertThrows = false;
        try {
            boolean bl2 = false;
            paths.add(path2, 250);
            throwable2 = Unit.INSTANCE;
        }
        catch (Throwable caught$iv) {
            throwable2 = caught$iv;
        }
        if (!((throwable = throwable2) instanceof Throwable)) {
            throwable = null;
        }
        Throwable throwable$iv = throwable;
        Intrinsics.checkExpressionValueIsNotNull((Object)Assertions.assertThrows(IllegalArgumentException.class, (Executable)new Executable(throwable$iv){
            final /* synthetic */ Throwable $throwable;
            {
                this.$throwable = throwable;
            }

            public final void execute() {
                if (this.$throwable != null) {
                    throw this.$throwable;
                }
            }
        }), (String)"Assertions.assertThrows(\u2026throwable\n        }\n    }");
    }

    @NotNull
    public Edge.Certification Certification(@NotNull Node issuer, @NotNull Node target, @NotNull String userId) {
        return NetworkDSL.DefaultImpls.Certification((NetworkDSL)this, (Node)issuer, (Node)target, (String)userId);
    }

    @NotNull
    public Edge.Certification Certification(@NotNull Node issuer, @NotNull Node target, @NotNull String targetUserId, @NotNull Date creationTime) {
        return NetworkDSL.DefaultImpls.Certification((NetworkDSL)this, (Node)issuer, (Node)target, (String)targetUserId, (Date)creationTime);
    }

    @NotNull
    public Edge.Delegation Delegation(@NotNull Node issuer, @NotNull Node target) {
        return NetworkDSL.DefaultImpls.Delegation((NetworkDSL)this, (Node)issuer, (Node)target);
    }

    @NotNull
    public Edge.Delegation Delegation(@NotNull Node issuer, @NotNull Node target, @NotNull Date creationTime) {
        return NetworkDSL.DefaultImpls.Delegation((NetworkDSL)this, (Node)issuer, (Node)target, (Date)creationTime);
    }

    @NotNull
    public Edge.Delegation Delegation(@NotNull Node issuer, @NotNull Node target, int amount, int depth) {
        return NetworkDSL.DefaultImpls.Delegation((NetworkDSL)this, (Node)issuer, (Node)target, (int)amount, (int)depth);
    }

    @NotNull
    public Edge.Delegation Delegation(@NotNull Node issuer, @NotNull Node target, int amount, @NotNull TrustDepth depth) {
        return NetworkDSL.DefaultImpls.Delegation((NetworkDSL)this, (Node)issuer, (Node)target, (int)amount, (TrustDepth)depth);
    }

    @NotNull
    public Node Node(@NotNull String fingerprint) {
        return NetworkDSL.DefaultImpls.Node((NetworkDSL)this, (String)fingerprint);
    }

    @NotNull
    public Node Node(@NotNull String fingerprint, @NotNull String userId) {
        return NetworkDSL.DefaultImpls.Node((NetworkDSL)this, (String)fingerprint, (String)userId);
    }

    @NotNull
    public Node Node(@NotNull Node original, @NotNull String userId) {
        return NetworkDSL.DefaultImpls.Node((NetworkDSL)this, (Node)original, (String)userId);
    }

    @NotNull
    public Network buildNetwork(@NotNull Function1<? super Network.Builder, Unit> builderAction) {
        return NetworkDSL.DefaultImpls.buildNetwork((NetworkDSL)this, builderAction);
    }

    @NotNull
    public RegexSet domainRegex(@NotNull String domain) {
        return NetworkDSL.DefaultImpls.domainRegex((NetworkDSL)this, (String)domain);
    }

    @NotNull
    public Network.Builder addEdge(@NotNull Network.Builder $this$addEdge, @NotNull String issuer, @NotNull String target) {
        return NetworkDSL.DefaultImpls.addEdge((NetworkDSL)this, (Network.Builder)$this$addEdge, (String)issuer, (String)target);
    }

    @NotNull
    public Network.Builder addEdge(@NotNull Network.Builder $this$addEdge, @NotNull String issuer, @NotNull String target, @NotNull String userId) {
        return NetworkDSL.DefaultImpls.addEdge((NetworkDSL)this, (Network.Builder)$this$addEdge, (String)issuer, (String)target, (String)userId);
    }

    @NotNull
    public Network.Builder addNode(@NotNull Network.Builder $this$addNode, @NotNull String fingerprint) {
        return NetworkDSL.DefaultImpls.addNode((NetworkDSL)this, (Network.Builder)$this$addNode, (String)fingerprint);
    }

    @NotNull
    public Network.Builder addNode(@NotNull Network.Builder $this$addNode, @NotNull String fingerprint, @NotNull String userId) {
        return NetworkDSL.DefaultImpls.addNode((NetworkDSL)this, (Network.Builder)$this$addNode, (String)fingerprint, (String)userId);
    }

    public void addNodes(@NotNull Network.Builder $this$addNodes, String ... fingerprints) {
        NetworkDSL.DefaultImpls.addNodes((NetworkDSL)this, (Network.Builder)$this$addNodes, (String[])fingerprints);
    }

    public boolean assertNodeFingerprints(@NotNull Path $this$assertNodeFingerprints, @NotNull List<Identifier> fingerprints) {
        return NetworkDSL.DefaultImpls.assertNodeFingerprints((NetworkDSL)this, (Path)$this$assertNodeFingerprints, fingerprints);
    }

    @NotNull
    public Network.Builder buildEdge(@NotNull Network.Builder $this$buildEdge, @NotNull String issuer, @NotNull String target) {
        return NetworkDSL.DefaultImpls.buildEdge((NetworkDSL)this, (Network.Builder)$this$buildEdge, (String)issuer, (String)target);
    }

    @NotNull
    public Network.Builder buildEdge(@NotNull Network.Builder $this$buildEdge, @NotNull String issuer, @NotNull String target, int amount, int depth) {
        return NetworkDSL.DefaultImpls.buildEdge((NetworkDSL)this, (Network.Builder)$this$buildEdge, (String)issuer, (String)target, (int)amount, (int)depth);
    }

    @NotNull
    public Network.Builder buildEdge(@NotNull Network.Builder $this$buildEdge, @NotNull String issuer, @NotNull String target, int amount, int depth, @NotNull RegexSet regexSet) {
        return NetworkDSL.DefaultImpls.buildEdge((NetworkDSL)this, (Network.Builder)$this$buildEdge, (String)issuer, (String)target, (int)amount, (int)depth, (RegexSet)regexSet);
    }

    @NotNull
    public Network.Builder buildEdge(@NotNull Network.Builder $this$buildEdge, @NotNull String issuer, @NotNull String target, @NotNull String userId) {
        return NetworkDSL.DefaultImpls.buildEdge((NetworkDSL)this, (Network.Builder)$this$buildEdge, (String)issuer, (String)target, (String)userId);
    }

    @Nullable
    public List<Edge.Component> getEdgeFor(@NotNull Network $this$getEdgeFor, @NotNull String issuer, @NotNull String target) {
        return NetworkDSL.DefaultImpls.getEdgeFor((NetworkDSL)this, (Network)$this$getEdgeFor, (String)issuer, (String)target);
    }

    @Nullable
    public List<Edge.Component> getEdgeFor(@NotNull Network $this$getEdgeFor, @NotNull String issuer, @NotNull String target, @Nullable String userId) {
        return NetworkDSL.DefaultImpls.getEdgeFor((NetworkDSL)this, (Network)$this$getEdgeFor, (String)issuer, (String)target, (String)userId);
    }

    @Nullable
    public List<Edge.Component> getEdgeFor(@NotNull Network $this$getEdgeFor, @NotNull Identifier issuer, @NotNull Identifier target) {
        return NetworkDSL.DefaultImpls.getEdgeFor((NetworkDSL)this, (Network)$this$getEdgeFor, (Identifier)issuer, (Identifier)target);
    }

    @NotNull
    public List<Edge.Component> getEdgeFor(@NotNull Network $this$getEdgeFor, @NotNull Identifier issuer, @NotNull Identifier target, @Nullable String userId) {
        return NetworkDSL.DefaultImpls.getEdgeFor((NetworkDSL)this, (Network)$this$getEdgeFor, (Identifier)issuer, (Identifier)target, (String)userId);
    }

    @Nullable
    public Edge getEdgesFor(@NotNull Network $this$getEdgesFor, @NotNull String issuer, @NotNull String target) {
        return NetworkDSL.DefaultImpls.getEdgesFor((NetworkDSL)this, (Network)$this$getEdgesFor, (String)issuer, (String)target);
    }

    @Nullable
    public Edge getEdgesFor(@NotNull Network $this$getEdgesFor, @NotNull Identifier issuer, @NotNull Identifier target) {
        return NetworkDSL.DefaultImpls.getEdgesFor((NetworkDSL)this, (Network)$this$getEdgesFor, (Identifier)issuer, (Identifier)target);
    }

    @NotNull
    public Date plusDays(@NotNull Date $this$plusDays, long days) {
        return NetworkDSL.DefaultImpls.plusDays((NetworkDSL)this, (Date)$this$plusDays, (long)days);
    }

    @NotNull
    public Date plusHours(@NotNull Date $this$plusHours, long hours) {
        return NetworkDSL.DefaultImpls.plusHours((NetworkDSL)this, (Date)$this$plusHours, (long)hours);
    }

    @NotNull
    public Date plusMillis(@NotNull Date $this$plusMillis, long millis) {
        return NetworkDSL.DefaultImpls.plusMillis((NetworkDSL)this, (Date)$this$plusMillis, (long)millis);
    }

    @NotNull
    public Date plusMinutes(@NotNull Date $this$plusMinutes, long minutes) {
        return NetworkDSL.DefaultImpls.plusMinutes((NetworkDSL)this, (Date)$this$plusMinutes, (long)minutes);
    }

    @NotNull
    public Date plusSeconds(@NotNull Date $this$plusSeconds, long seconds) {
        return NetworkDSL.DefaultImpls.plusSeconds((NetworkDSL)this, (Date)$this$plusSeconds, (long)seconds);
    }
}

