/*
 * Decompiled with CFR 0.152.
 */
package org.pgpainless.wot.query;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.pgpainless.wot.network.Edge;
import org.pgpainless.wot.network.Identifier;
import org.pgpainless.wot.network.Network;
import org.pgpainless.wot.network.Node;
import org.pgpainless.wot.network.TrustDepth;
import org.pgpainless.wot.network.TrustRoot;
import org.pgpainless.wot.network.WotNetwork;
import org.pgpainless.wot.query.Cost;
import org.pgpainless.wot.query.Dijkstra;
import org.pgpainless.wot.query.ForwardPointer;
import org.pgpainless.wot.query.PairPriorityQueue;
import org.pgpainless.wot.query.Path;
import org.pgpainless.wot.query.Paths;
import org.pgpainless.wot.query.ShortestPathAlgorithm;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000v\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B/\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u0012\b\b\u0002\u0010\u0007\u001a\u00020\b\u0012\b\b\u0002\u0010\t\u001a\u00020\n\u00a2\u0006\u0002\u0010\u000bJD\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00112\"\u0010\u0015\u001a\u001e\u0012\u0004\u0012\u00020\u0017\u0012\u0004\u0012\u00020\u00180\u0016j\u000e\u0012\u0004\u0012\u00020\u0017\u0012\u0004\u0012\u00020\u0018`\u0019H\u0002JJ\u0010\u001a\u001a6\u0012\u0004\u0012\u00020\u0017\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u000f\u0012\u0004\u0012\u00020\u001c0\u001b0\u0016j\u001a\u0012\u0004\u0012\u00020\u0017\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u000f\u0012\u0004\u0012\u00020\u001c0\u001b`\u00192\u0006\u0010\u001d\u001a\u00020\u00172\u0006\u0010\u0012\u001a\u00020\u0013JT\u0010\u001a\u001a6\u0012\u0004\u0012\u00020\u0017\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u000f\u0012\u0004\u0012\u00020\u001c0\u001b0\u0016j\u001a\u0012\u0004\u0012\u00020\u0017\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u000f\u0012\u0004\u0012\u00020\u001c0\u001b`\u00192\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010\u001d\u001a\u00020\u00172\u0006\u0010\u0012\u001a\u00020\u0013H\u0002J\u009c\u0001\u0010 \u001a6\u0012\u0004\u0012\u00020\u0017\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u000f\u0012\u0004\u0012\u00020\u001c0\u001b0\u0016j\u001a\u0012\u0004\u0012\u00020\u0017\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u000f\u0012\u0004\u0012\u00020\u001c0\u001b`\u00192\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010\u0012\u001a\u00020\u00132\"\u0010\u0015\u001a\u001e\u0012\u0004\u0012\u00020\u0017\u0012\u0004\u0012\u00020\u00180\u0016j\u000e\u0012\u0004\u0012\u00020\u0017\u0012\u0004\u0012\u00020\u0018`\u00192\u0006\u0010\u0010\u001a\u00020\u00112\"\u0010!\u001a\u001e\u0012\u0004\u0012\u00020\u0017\u0012\u0004\u0012\u00020\"0\u0016j\u000e\u0012\u0004\u0012\u00020\u0017\u0012\u0004\u0012\u00020\"`\u0019H\u0002J \u0010#\u001a\u00020$2\u0006\u0010\u001d\u001a\u00020\u00172\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010%\u001a\u00020\u001cH\u0016R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006&"}, d2={"Lorg/pgpainless/wot/query/Dijkstra;", "Lorg/pgpainless/wot/query/ShortestPathAlgorithm;", "rawNetwork", "Lorg/pgpainless/wot/network/Network;", "roots", "", "Lorg/pgpainless/wot/network/TrustRoot;", "certificationNetwork", "", "referenceTime", "Ljava/util/Date;", "(Lorg/pgpainless/wot/network/Network;Ljava/util/Set;ZLjava/util/Date;)V", "logger", "Lorg/slf4j/Logger;", "assemblePath", "Lorg/pgpainless/wot/query/Path;", "target", "Lorg/pgpainless/wot/network/Node;", "targetUserid", "", "issuer", "bestNextNode", "Ljava/util/HashMap;", "Lorg/pgpainless/wot/network/Identifier;", "Lorg/pgpainless/wot/query/ForwardPointer;", "Lkotlin/collections/HashMap;", "backwardPropagate", "Lkotlin/Pair;", "", "targetFpr", "network", "Lorg/pgpainless/wot/network/WotNetwork;", "reconstructPaths", "dist", "Lorg/pgpainless/wot/query/Cost;", "search", "Lorg/pgpainless/wot/query/Paths;", "targetTrustAmount", "wot-dijkstra"})
@SourceDebugExtension(value={"SMAP\nDijkstra.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Dijkstra.kt\norg/pgpainless/wot/query/Dijkstra\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,292:1\n766#2:293\n857#2,2:294\n1855#2,2:296\n1549#2:299\n1620#2,3:300\n1603#2,9:303\n1855#2:312\n1856#2:314\n1612#2:315\n766#2:316\n857#2:317\n1747#2,3:318\n858#2:321\n766#2:322\n857#2,2:323\n1855#2,2:325\n1#3:298\n1#3:313\n*S KotlinDebug\n*F\n+ 1 Dijkstra.kt\norg/pgpainless/wot/query/Dijkstra\n*L\n42#1:293\n42#1:294,2\n43#1:296,2\n64#1:299\n64#1:300,3\n65#1:303,9\n65#1:312\n65#1:314\n65#1:315\n245#1:316\n245#1:317\n245#1:318,3\n245#1:321\n247#1:322\n247#1:323,2\n248#1:325,2\n65#1:313\n*E\n"})
public final class Dijkstra
implements ShortestPathAlgorithm {
    @NotNull
    private final Network rawNetwork;
    @NotNull
    private final Set<TrustRoot> roots;
    private final boolean certificationNetwork;
    @NotNull
    private final Date referenceTime;
    @NotNull
    private final Logger logger;

    public Dijkstra(@NotNull Network rawNetwork, @NotNull Set<TrustRoot> roots, boolean certificationNetwork, @NotNull Date referenceTime) {
        Intrinsics.checkNotNullParameter((Object)rawNetwork, (String)"rawNetwork");
        Intrinsics.checkNotNullParameter(roots, (String)"roots");
        Intrinsics.checkNotNullParameter((Object)referenceTime, (String)"referenceTime");
        this.rawNetwork = rawNetwork;
        this.roots = roots;
        this.certificationNetwork = certificationNetwork;
        this.referenceTime = referenceTime;
        Logger logger = LoggerFactory.getLogger(Dijkstra.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getLogger(Dijkstra::class.java)");
        this.logger = logger;
    }

    public /* synthetic */ Dijkstra(Network network, Set set, boolean bl, Date date, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 4) != 0) {
            bl = false;
        }
        if ((n & 8) != 0) {
            date = new Date();
        }
        this(network, set, bl, date);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public Paths search(@NotNull Identifier targetFpr, @NotNull String targetUserid, int targetTrustAmount) {
        Intrinsics.checkNotNullParameter((Object)targetFpr, (String)"targetFpr");
        Intrinsics.checkNotNullParameter((Object)targetUserid, (String)"targetUserid");
        Object[] objectArray = new Object[]{targetFpr, targetUserid, this.roots};
        this.logger.debug("Authenticating <{}, '{}'>\nRoots: {}", objectArray);
        WotNetwork network = new WotNetwork(this.rawNetwork, this.certificationNetwork, this.referenceTime);
        if (!this.certificationNetwork) {
            void $this$forEach$iv;
            Iterator $this$filterTo$iv$iv;
            Iterable $this$filter$iv = this.roots;
            boolean $i$f$filter = false;
            Iterable iterable = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            Iterator iterator = $this$filterTo$iv$iv.iterator();
            while (iterator.hasNext()) {
                Object element$iv$iv = iterator.next();
                TrustRoot it = (TrustRoot)element$iv$iv;
                boolean bl2 = false;
                if (!(it.getTrustAmount() != 120)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            $this$filter$iv = (List)destination$iv$iv;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                TrustRoot it = (TrustRoot)element$iv;
                boolean bl = false;
                network.capCertificate(it.getFingerprint(), it.getTrustAmount());
            }
        }
        Paths paths = new Paths();
        while (paths.getAmount() < targetTrustAmount) {
            boolean bl;
            void $this$mapNotNullTo$iv$iv;
            Function1[] $this$mapNotNull$iv;
            void $this$mapTo$iv$iv;
            Object element$iv;
            HashMap<Identifier, Pair<Path, Integer>> authPaths = this.backwardPropagate(network, targetFpr, targetUserid);
            Set<TrustRoot> it = this.roots;
            boolean $i$a$-let-Dijkstra$search$bestPath$22 = false;
            Iterable $this$map$iv = it;
            boolean $i$f$map = false;
            Iterable bl2 = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void r;
                TrustRoot trustRoot = (TrustRoot)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl3 = false;
                collection.add(r.getFingerprint());
            }
            element$iv = (List)destination$iv$iv;
            boolean $i$f$mapNotNull = false;
            void $i$a$-let-Dijkstra$search$bestPath$22 = $this$mapNotNull$iv;
            Collection destination$iv$iv2 = new ArrayList();
            boolean $i$f$mapNotNullTo = false;
            void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
            boolean $i$f$forEach = false;
            Iterator iterator = $this$forEach$iv$iv$iv.iterator();
            while (iterator.hasNext()) {
                Pair<Path, Integer> it$iv$iv;
                Object element$iv$iv$iv;
                Object element$iv$iv = element$iv$iv$iv = iterator.next();
                boolean bl4 = false;
                Identifier it2 = (Identifier)element$iv$iv;
                boolean bl5 = false;
                if (authPaths.get(it2) == null) continue;
                boolean bl6 = false;
                destination$iv$iv2.add(it$iv$iv);
            }
            $this$mapNotNull$iv = new Function1[]{search.bestPath.3.INSTANCE, search.bestPath.4.INSTANCE, search.bestPath.5.INSTANCE};
            Pair bestPath2 = (Pair)CollectionsKt.maxWithOrNull((Iterable)((List)destination$iv$iv2), (Comparator)ComparisonsKt.compareBy((Function1[])$this$mapNotNull$iv));
            if (bestPath2 == null) break;
            Path path = (Path)bestPath2.component1();
            int amount = ((Number)bestPath2.component2()).intValue();
            boolean bl7 = bl = path.getLength() > 1;
            if (_Assertions.ENABLED && !bl) {
                String string = "Assertion failed";
                throw new AssertionError((Object)string);
            }
            network.suppressPath(path, amount);
            paths.add(path, amount);
        }
        return paths;
    }

    @NotNull
    public final HashMap<Identifier, Pair<Path, Integer>> backwardPropagate(@NotNull Identifier targetFpr, @NotNull String targetUserid) {
        Intrinsics.checkNotNullParameter((Object)targetFpr, (String)"targetFpr");
        Intrinsics.checkNotNullParameter((Object)targetUserid, (String)"targetUserid");
        WotNetwork network = new WotNetwork(this.rawNetwork, false, this.referenceTime);
        return this.backwardPropagate(network, targetFpr, targetUserid);
    }

    private final HashMap<Identifier, Pair<Path, Integer>> backwardPropagate(WotNetwork network, Identifier targetFpr, String targetUserid) {
        Identifier identifier;
        Cost cost;
        int selfSigAmount;
        Edge.Component selfSig;
        Object[] objectArray = new Object[]{targetFpr, targetUserid, this.roots};
        this.logger.debug("Query.backwardPropagate <{}, '{}'>\nRoots: {}", objectArray);
        Node node = network.isValidTarget(targetFpr, targetUserid);
        if (node == null) {
            return new HashMap<Identifier, Pair<Path, Integer>>();
        }
        Node target = node;
        HashMap<Identifier, ForwardPointer> prev = new HashMap<Identifier, ForwardPointer>();
        HashMap<Identifier, Cost> dist = new HashMap<Identifier, Cost>();
        PairPriorityQueue<Identifier, Comparable> queue = new PairPriorityQueue<Identifier, Comparable>();
        Edge.Component component = selfSig = network.getSelfSig(targetFpr, targetUserid);
        int n = selfSigAmount = component != null ? network.getEffectiveTrustAmount(component) : 0;
        if (selfSig != null && selfSigAmount > 0) {
            cost = new Cost(1, selfSigAmount);
            ((Map)prev).put(targetFpr, new ForwardPointer(selfSig));
            ((Map)dist).put(targetFpr, cost);
            queue.insertOrUpdate(targetFpr, cost);
        } else {
            cost = new Cost(0, 120);
            ((Map)prev).put(targetFpr, new ForwardPointer(null));
            ((Map)dist).put(targetFpr, cost);
            queue.insertOrUpdate(targetFpr, cost);
        }
        while ((identifier = queue.pop()) != null && (identifier = (Identifier)identifier.getFirst()) != null) {
            Node signee;
            Cost signeeCost;
            ForwardPointer signeeFp;
            Object v4;
            Identifier signeeFpr;
            block15: {
                signeeFpr = identifier;
                this.logger.debug("Processing signee {}", (Object)signeeFpr);
                Iterable iterable = this.roots;
                for (Object t : iterable) {
                    TrustRoot it = (TrustRoot)t;
                    boolean bl = false;
                    if (!Intrinsics.areEqual((Object)it.getFingerprint(), (Object)signeeFpr)) continue;
                    v4 = t;
                    break block15;
                }
                v4 = null;
            }
            TrustRoot root = v4;
            if (root != null && root.getTrustAmount() >= 120) {
                this.logger.debug("  Skipping signee that is a fully trusted root");
                continue;
            }
            Intrinsics.checkNotNull((Object)network.nodeByFpr(signeeFpr));
            Intrinsics.checkNotNull((Object)prev.get(signeeFpr));
            Intrinsics.checkNotNull((Object)dist.get(signeeFpr));
            Edge.Component component2 = signeeFp.getNext();
            this.logger.debug("  Current forward pointer: {}", component2 != null ? component2.getTarget() : null);
            this.logger.debug("  Current cost to target: {}", (Object)signeeCost);
            int curMinLen = Math.max(0, signeeCost.getLength() - 1);
            List<Edge.Component> ecs = network.certificationsForSignee(signeeFpr, targetUserid, curMinLen);
            this.logger.debug("  Checking {} certifications for {}:", (Object)ecs.size(), (Object)signee.toString());
            for (Edge.Component ec : ecs) {
                Cost cost2;
                this.logger.debug("    Certification by {}", (Object)ec.getIssuer().getFingerprint());
                int amount = network.getEffectiveTrustAmount(ec);
                if (amount == 0) {
                    this.logger.debug("      Skipping (effective trust amount is 0)");
                    continue;
                }
                if (Intrinsics.areEqual((Object)signeeFpr, (Object)targetFpr) && ec instanceof Edge.Certification && !Intrinsics.areEqual((Object)((Edge.Certification)ec).getUserId(), (Object)targetUserid) && signeeCost.getLength() == 0) {
                    this.logger.debug("      Certification is for the wrong user id ({})", (Object)((Edge.Certification)ec).getUserId());
                    continue;
                }
                if (ec instanceof Edge.Certification && Intrinsics.areEqual((Object)((Edge.Certification)ec).getUserId(), (Object)targetUserid)) {
                    cost2 = new Cost(1, amount);
                } else {
                    if (!this.certificationNetwork) {
                        TrustDepth trustDepth = ec.getTrustDepth();
                        if ((trustDepth != null ? (Comparable)trustDepth : (Comparable)Integer.valueOf(0)).compareTo(signeeCost.getLength()) < 0) {
                            this.logger.debug("      Certification does not allow enough depth ({}, needed: {}), skipping", (Object)ec.getTrustDepth(), (Object)signeeCost.getLength());
                            continue;
                        }
                    }
                    cost2 = signeeCost.extendBy(amount);
                }
                Cost altCost = cost2;
                this.logger.debug("      Cost to target via {}: {}", (Object)ec.getTarget().getFingerprint(), (Object)altCost);
                Identifier issuerFpr = ec.getIssuer().getFingerprint();
                Cost currentCost = dist.get(issuerFpr);
                if (currentCost == null || altCost.compareTo(currentCost) < 0) {
                    this.logger.debug("      Setting forward pointer for {}: {}", (Object)ec.getIssuer(), (Object)ec.getTarget());
                    if (currentCost != null) {
                        this.logger.debug("        (Replaces previous path with cost {})", (Object)currentCost);
                    }
                    ((Map)prev).put(issuerFpr, new ForwardPointer(ec));
                    ((Map)dist).put(issuerFpr, altCost);
                }
                if (currentCost != null) continue;
                this.logger.debug("      Queuing node {}", (Object)ec.getIssuer());
                queue.insertOrUpdate(issuerFpr, altCost);
            }
        }
        return this.reconstructPaths(network, targetUserid, prev, target, dist);
    }

    /*
     * Unable to fully structure code
     */
    private final HashMap<Identifier, Pair<Path, Integer>> reconstructPaths(WotNetwork network, String targetUserid, HashMap<Identifier, ForwardPointer> bestNextNode, Node target, HashMap<Identifier, Cost> dist) {
        paths = new HashMap<Identifier, Pair<Path, Integer>>();
        v0 = bestNextNode.entrySet();
        Intrinsics.checkNotNullExpressionValue(v0, (String)"bestNextNode.entries");
        var7_7 = v0;
        $i$f$filter = false;
        var9_9 = $this$filter$iv;
        destination$iv$iv = new ArrayList<E>();
        $i$f$filterTo = false;
        for (T element$iv$iv : $this$filterTo$iv$iv) {
            block8: {
                it = (Map.Entry)element$iv$iv;
                $i$a$-filter-Dijkstra$reconstructPaths$1 = false;
                if (this.roots.isEmpty()) ** GOTO lbl-1000
                $this$any$iv = this.roots;
                $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    v1 = false;
                } else {
                    for (T element$iv : $this$any$iv) {
                        root = (TrustRoot)element$iv;
                        $i$a$-any-Dijkstra$reconstructPaths$1$1 = false;
                        if (!Intrinsics.areEqual((Object)root.getFingerprint(), it.getKey())) continue;
                        v1 = true;
                        break block8;
                    }
                    v1 = false;
                }
            }
            if (v1) lbl-1000:
            // 2 sources

            {
                v2 = true;
            } else {
                v2 = false;
            }
            if (!v2) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $this$filter$iv = (List)destination$iv$iv;
        $i$f$filter = false;
        $this$filterTo$iv$iv = $this$filter$iv;
        destination$iv$iv = new ArrayList<E>();
        $i$f$filterTo = false;
        for (T element$iv$iv : $this$filterTo$iv$iv) {
            it = (Map.Entry)element$iv$iv;
            $i$a$-filter-Dijkstra$reconstructPaths$2 = false;
            if (!(((ForwardPointer)it.getValue()).getNext() != null)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $this$filter$iv = (List)destination$iv$iv;
        $i$f$forEach = false;
        for (T element$iv : $this$forEach$iv) {
            var11_12 = (Map.Entry)element$iv;
            $i$a$-forEach-Dijkstra$reconstructPaths$3 = false;
            Intrinsics.checkNotNullExpressionValue((Object)var11_12, (String)"(issuerFpr, fp)");
            issuerFpr = (Identifier)var11_12.getKey();
            fp = (ForwardPointer)var11_12.getValue();
            v3 = fp.getNext();
            Intrinsics.checkNotNull((Object)v3);
            issuer = v3.getIssuer();
            Intrinsics.checkNotNullExpressionValue((Object)issuerFpr, (String)"issuerFpr");
            this.logger.trace("Recovering path starting at {}", (Object)network.nodeByFpr(issuerFpr));
            path = this.assemblePath(target, targetUserid, issuer, bestNextNode);
            v4 = dist.get(issuer.getFingerprint());
            Intrinsics.checkNotNull((Object)v4);
            amount = v4.getAmount();
            var18_21 = new Object[]{target.getFingerprint(), targetUserid, path};
            this.logger.debug("Authenticated <{}, {}>:\n{}", var18_21);
            ((Map)paths).put(issuerFpr, new Pair((Object)path, (Object)amount));
        }
        return paths;
    }

    private final Path assemblePath(Node target, String targetUserid, Node issuer, HashMap<Identifier, ForwardPointer> bestNextNode) {
        boolean bl;
        ForwardPointer forwardPointer = bestNextNode.get(issuer.getFingerprint());
        Intrinsics.checkNotNull((Object)forwardPointer);
        ForwardPointer fp = forwardPointer;
        Path p = new Path(issuer);
        while (fp.getNext() != null) {
            Edge.Component ec;
            p.append(ec, this.certificationNetwork);
            if (ec instanceof Edge.Certification && Intrinsics.areEqual((Object)((Edge.Certification)ec).getUserId(), (Object)targetUserid)) break;
            Intrinsics.checkNotNull((Object)bestNextNode.get(ec.getTarget().getFingerprint()));
        }
        boolean bl2 = bl = !((Collection)p.getCertifications()).isEmpty();
        if (_Assertions.ENABLED && !bl) {
            String string = "Assertion failed";
            throw new AssertionError((Object)string);
        }
        Object[] objectArray = new Object[]{issuer.getFingerprint(), targetUserid, target.getFingerprint(), CollectionsKt.joinToString$default((Iterable)CollectionsKt.withIndex((Iterable)p.getCertifications()), (CharSequence)"\n  ", null, null, (int)0, null, (Function1)assemblePath.1.INSTANCE, (int)30, null)};
        this.logger.trace("\nAssembled path from {} to <{} <-> {}>:\n  {}", objectArray);
        return p;
    }
}

