/*
 * Decompiled with CFR 0.152.
 */
package org.pgpainless.wot.network;

import kotlin.Metadata;
import kotlin.Unit;
import kotlin._Assertions;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.test.AssertionsKt;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.function.Executable;
import org.pgpainless.wot.network.TrustDepth;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0011\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0003\u001a\u00020\u0004H\u0007J\b\u0010\u0005\u001a\u00020\u0004H\u0007J\b\u0010\u0006\u001a\u00020\u0004H\u0007J\b\u0010\u0007\u001a\u00020\u0004H\u0007J\b\u0010\b\u001a\u00020\u0004H\u0007J\b\u0010\t\u001a\u00020\u0004H\u0007J\b\u0010\n\u001a\u00020\u0004H\u0007J\b\u0010\u000b\u001a\u00020\u0004H\u0007J\b\u0010\f\u001a\u00020\u0004H\u0007J\b\u0010\r\u001a\u00020\u0004H\u0007J\b\u0010\u000e\u001a\u00020\u0004H\u0007J\b\u0010\u000f\u001a\u00020\u0004H\u0007J\b\u0010\u0010\u001a\u00020\u0004H\u0007J\b\u0010\u0011\u001a\u00020\u0004H\u0007J\b\u0010\u0012\u001a\u00020\u0004H\u0007J\b\u0010\u0013\u001a\u00020\u0004H\u0007J\b\u0010\u0014\u001a\u00020\u0004H\u0007\u00a8\u0006\u0015"}, d2={"Lorg/pgpainless/wot/network/DepthTest;", "", "()V", "verify Depth#limited(2) initializes properly", "", "verify Depth#limited(X) is not unconstrained", "verify Depth#unconstrained() has null depth", "verify Depth#unconstrained() is in fact unconstrained", "verify proper function of compareTo()", "verify that Depth#auto(255) yields an unconstrained Depth", "verify that Depth#auto(X) for values from 0 to 254 yield limited Depth objects", "verify that decrease()ing a Depth object by a value greater than its current value fails", "verify that decrease()ing a limited Depth yields a properly decreased result", "verify that decrease()ing an unconstrained Depth is an idempotent operation", "verify that depth values out of the range from 0 to 255 yield failures", "verify that min() of a Depth with itself yields itself", "verify that min() of a limited and an unconstrained value yields the limited value", "verify that min() of two limited values returns the smaller one", "verify that the min() of unconstrained and unconstrained is unconstrained", "verify that toString() of Depth#unconstrained() returns the String 'unconstrained'", "verify that toString() of a limited Depth returns the String of its value", "wot-generic_test"})
@SourceDebugExtension(value={"SMAP\nDepthTest.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DepthTest.kt\norg/pgpainless/wot/network/DepthTest\n+ 2 Assertions.kt\norg/junit/jupiter/api/AssertionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,149:1\n100#2,7:150\n100#2,7:157\n100#2,7:164\n100#2,7:172\n100#2,7:179\n100#2,7:186\n100#2,7:193\n1#3:171\n*S KotlinDebug\n*F\n+ 1 DepthTest.kt\norg/pgpainless/wot/network/DepthTest\n*L\n62#1:150,7\n63#1:157,7\n64#1:164,7\n133#1:172,7\n134#1:179,7\n135#1:186,7\n136#1:193,7\n*E\n"})
public final class DepthTest {
    @Test
    public final void verify Depth#unconstrained() is in fact unconstrained() {
        TrustDepth depth = TrustDepth.Companion.unlimited();
        boolean bl = depth.isUnlimited();
        if (_Assertions.ENABLED && !bl) {
            String string = "Assertion failed";
            throw new AssertionError((Object)string);
        }
    }

    @Test
    public final void verify Depth#unconstrained() has null depth() {
        TrustDepth depth = TrustDepth.Companion.unlimited();
        boolean bl = depth.isUnlimited();
        if (_Assertions.ENABLED && !bl) {
            String string = "Assertion failed";
            throw new AssertionError((Object)string);
        }
        AssertionsKt.assertEquals$default((Object)depth.getValue(), (Object)255, null, (int)4, null);
    }

    @Test
    public final void verify Depth#limited(2) initializes properly() {
        boolean bl;
        TrustDepth limited = TrustDepth.Companion.limited(2);
        boolean bl2 = bl = !limited.isUnlimited();
        if (_Assertions.ENABLED && !bl) {
            String string = "Assertion failed";
            throw new AssertionError((Object)string);
        }
        AssertionsKt.assertEquals$default((Object)2, (Object)limited.getValue(), null, (int)4, null);
    }

    @Test
    public final void verify Depth#limited(X) is not unconstrained() {
        TrustDepth limited = TrustDepth.Companion.limited(1);
        AssertionsKt.assertFalse$default((boolean)limited.isUnlimited(), null, (int)2, null);
    }

    @Test
    public final void verify that decrease()ing an unconstrained Depth is an idempotent operation() {
        TrustDepth unconstrained = TrustDepth.Companion.unlimited();
        TrustDepth decreased = unconstrained.reduce(20);
        AssertionsKt.assertTrue$default((boolean)decreased.isUnlimited(), null, (int)2, null);
    }

    @Test
    public final void verify that decrease()ing a limited Depth yields a properly decreased result() {
        TrustDepth limited = TrustDepth.Companion.limited(3);
        TrustDepth decreased = limited.reduce(2);
        AssertionsKt.assertFalse$default((boolean)decreased.isUnlimited(), null, (int)2, null);
        AssertionsKt.assertEquals$default((Object)1, (Object)decreased.getValue(), null, (int)4, null);
    }

    @Test
    public final void verify that decrease()ing a Depth object by a value greater than its current value fails() {
        Throwable throwable;
        Throwable throwable2;
        Throwable throwable3;
        Throwable throwable4;
        boolean $i$f$assertThrows = false;
        try {
            boolean bl = false;
            TrustDepth.Companion.limited(0).reduce(1);
            throwable4 = Unit.INSTANCE;
        }
        catch (Throwable caught$iv) {
            throwable4 = caught$iv;
        }
        if (!((throwable3 = throwable4) instanceof Throwable)) {
            throwable3 = null;
        }
        Throwable throwable$iv = throwable3;
        Intrinsics.checkExpressionValueIsNotNull((Object)Assertions.assertThrows(IllegalArgumentException.class, (Executable)new Executable(throwable$iv){
            final /* synthetic */ Throwable $throwable;
            {
                this.$throwable = throwable;
            }

            public final void execute() {
                if (this.$throwable != null) {
                    throw this.$throwable;
                }
            }
        }), (String)"Assertions.assertThrows(\u2026throwable\n        }\n    }");
        $i$f$assertThrows = false;
        try {
            boolean bl = false;
            TrustDepth.Companion.limited(1).reduce(2);
            throwable4 = Unit.INSTANCE;
        }
        catch (Throwable caught$iv) {
            throwable4 = caught$iv;
        }
        if (!((throwable2 = throwable4) instanceof Throwable)) {
            throwable2 = null;
        }
        throwable$iv = throwable2;
        Intrinsics.checkExpressionValueIsNotNull((Object)Assertions.assertThrows(IllegalArgumentException.class, (Executable)new Executable(throwable$iv){
            final /* synthetic */ Throwable $throwable;
            {
                this.$throwable = throwable;
            }

            public final void execute() {
                if (this.$throwable != null) {
                    throw this.$throwable;
                }
            }
        }), (String)"Assertions.assertThrows(\u2026throwable\n        }\n    }");
        $i$f$assertThrows = false;
        try {
            boolean bl = false;
            TrustDepth.Companion.limited(17).reduce(42);
            throwable4 = Unit.INSTANCE;
        }
        catch (Throwable caught$iv) {
            throwable4 = caught$iv;
        }
        if (!((throwable = throwable4) instanceof Throwable)) {
            throwable = null;
        }
        throwable$iv = throwable;
        Intrinsics.checkExpressionValueIsNotNull((Object)Assertions.assertThrows(IllegalArgumentException.class, (Executable)new Executable(throwable$iv){
            final /* synthetic */ Throwable $throwable;
            {
                this.$throwable = throwable;
            }

            public final void execute() {
                if (this.$throwable != null) {
                    throw this.$throwable;
                }
            }
        }), (String)"Assertions.assertThrows(\u2026throwable\n        }\n    }");
    }

    @Test
    public final void verify proper function of compareTo()() {
        TrustDepth unlimited = TrustDepth.Companion.unlimited();
        TrustDepth depth2 = TrustDepth.Companion.limited(2);
        TrustDepth depth5 = TrustDepth.Companion.limited(5);
        AssertionsKt.assertTrue$default((unlimited.compareTo(0) > 0 ? 1 : 0) != 0, null, (int)2, null);
        AssertionsKt.assertTrue$default((unlimited.compareTo(255) > 0 ? 1 : 0) != 0, null, (int)2, null);
        AssertionsKt.assertTrue$default((unlimited.compareTo(256) > 0 ? 1 : 0) != 0, null, (int)2, null);
        AssertionsKt.assertTrue$default((depth2.compareTo(0) > 0 ? 1 : 0) != 0, null, (int)2, null);
        AssertionsKt.assertTrue$default((depth2.compareTo(1) > 0 ? 1 : 0) != 0, null, (int)2, null);
        AssertionsKt.assertFalse$default((depth2.compareTo(2) > 0 ? 1 : 0) != 0, null, (int)2, null);
        AssertionsKt.assertFalse$default((depth2.compareTo(256) > 0 ? 1 : 0) != 0, null, (int)2, null);
        AssertionsKt.assertTrue$default((depth5.compareTo(1) > 0 ? 1 : 0) != 0, null, (int)2, null);
        AssertionsKt.assertTrue$default((depth5.compareTo(4) > 0 ? 1 : 0) != 0, null, (int)2, null);
        AssertionsKt.assertFalse$default((depth5.compareTo(5) > 0 ? 1 : 0) != 0, null, (int)2, null);
        AssertionsKt.assertFalse$default((depth5.compareTo(256) > 0 ? 1 : 0) != 0, null, (int)2, null);
    }

    @Test
    public final void verify that min() of a Depth with itself yields itself() {
        TrustDepth limit = TrustDepth.Companion.limited(17);
        AssertionsKt.assertEquals$default((Object)limit, (Object)limit.min(limit), null, (int)4, null);
    }

    @Test
    public final void verify that min() of two limited values returns the smaller one() {
        TrustDepth limit1 = TrustDepth.Companion.limited(1);
        TrustDepth limit4 = TrustDepth.Companion.limited(4);
        AssertionsKt.assertEquals$default((Object)limit1, (Object)limit1.min(limit4), null, (int)4, null);
        AssertionsKt.assertEquals$default((Object)limit1, (Object)limit4.min(limit1), null, (int)4, null);
    }

    @Test
    public final void verify that min() of a limited and an unconstrained value yields the limited value() {
        TrustDepth limit0 = TrustDepth.Companion.limited(0);
        TrustDepth limit1 = TrustDepth.Companion.limited(1);
        AssertionsKt.assertEquals$default((Object)limit0, (Object)TrustDepth.Companion.unlimited().min(limit0), null, (int)4, null);
        AssertionsKt.assertEquals$default((Object)limit1, (Object)limit1.min(TrustDepth.Companion.unlimited()), null, (int)4, null);
    }

    @Test
    public final void verify that the min() of unconstrained and unconstrained is unconstrained() {
        TrustDepth unconstrained = TrustDepth.Companion.unlimited();
        AssertionsKt.assertEquals$default((Object)unconstrained, (Object)unconstrained.min(unconstrained), null, (int)4, null);
    }

    @Test
    public final void verify that Depth#auto(255) yields an unconstrained Depth() {
        String string = null;
        boolean bl = false;
        AssertionsKt.assertTrue((boolean)TrustDepth.Companion.auto(255).isUnlimited(), string);
        AssertionsKt.assertEquals$default((Object)TrustDepth.Companion.auto(255).getValue(), (Object)255, null, (int)4, null);
    }

    @Test
    public final void verify that Depth#auto(X) for values from 0 to 254 yield limited Depth objects() {
        String string = null;
        boolean bl = false;
        AssertionsKt.assertFalse((boolean)TrustDepth.Companion.auto(0).isUnlimited(), string);
        string = null;
        boolean bl2 = false;
        AssertionsKt.assertFalse((boolean)TrustDepth.Companion.auto(120).isUnlimited(), string);
        string = null;
        boolean bl3 = false;
        AssertionsKt.assertFalse((boolean)TrustDepth.Companion.auto(254).isUnlimited(), string);
        AssertionsKt.assertNotNull$default((Object)TrustDepth.Companion.auto(42).getValue(), null, (int)2, null);
    }

    @Test
    public final void verify that depth values out of the range from 0 to 255 yield failures() {
        Throwable throwable;
        Throwable throwable2;
        Throwable throwable3;
        Throwable throwable4;
        Throwable throwable5;
        boolean $i$f$assertThrows = false;
        try {
            boolean bl = false;
            TrustDepth.Companion.limited(-1);
            throwable5 = Unit.INSTANCE;
        }
        catch (Throwable caught$iv) {
            throwable5 = caught$iv;
        }
        if (!((throwable4 = throwable5) instanceof Throwable)) {
            throwable4 = null;
        }
        Throwable throwable$iv = throwable4;
        Intrinsics.checkExpressionValueIsNotNull((Object)Assertions.assertThrows(IllegalArgumentException.class, (Executable)new Executable(throwable$iv){
            final /* synthetic */ Throwable $throwable;
            {
                this.$throwable = throwable;
            }

            public final void execute() {
                if (this.$throwable != null) {
                    throw this.$throwable;
                }
            }
        }), (String)"Assertions.assertThrows(\u2026throwable\n        }\n    }");
        $i$f$assertThrows = false;
        try {
            boolean bl = false;
            TrustDepth.Companion.limited(256);
            throwable5 = Unit.INSTANCE;
        }
        catch (Throwable caught$iv) {
            throwable5 = caught$iv;
        }
        if (!((throwable3 = throwable5) instanceof Throwable)) {
            throwable3 = null;
        }
        throwable$iv = throwable3;
        Intrinsics.checkExpressionValueIsNotNull((Object)Assertions.assertThrows(IllegalArgumentException.class, (Executable)new Executable(throwable$iv){
            final /* synthetic */ Throwable $throwable;
            {
                this.$throwable = throwable;
            }

            public final void execute() {
                if (this.$throwable != null) {
                    throw this.$throwable;
                }
            }
        }), (String)"Assertions.assertThrows(\u2026throwable\n        }\n    }");
        $i$f$assertThrows = false;
        try {
            boolean bl = false;
            TrustDepth.Companion.auto(-1);
            throwable5 = Unit.INSTANCE;
        }
        catch (Throwable caught$iv) {
            throwable5 = caught$iv;
        }
        if (!((throwable2 = throwable5) instanceof Throwable)) {
            throwable2 = null;
        }
        throwable$iv = throwable2;
        Intrinsics.checkExpressionValueIsNotNull((Object)Assertions.assertThrows(IllegalArgumentException.class, (Executable)new Executable(throwable$iv){
            final /* synthetic */ Throwable $throwable;
            {
                this.$throwable = throwable;
            }

            public final void execute() {
                if (this.$throwable != null) {
                    throw this.$throwable;
                }
            }
        }), (String)"Assertions.assertThrows(\u2026throwable\n        }\n    }");
        $i$f$assertThrows = false;
        try {
            boolean bl = false;
            TrustDepth.Companion.auto(256);
            throwable5 = Unit.INSTANCE;
        }
        catch (Throwable caught$iv) {
            throwable5 = caught$iv;
        }
        if (!((throwable = throwable5) instanceof Throwable)) {
            throwable = null;
        }
        throwable$iv = throwable;
        Intrinsics.checkExpressionValueIsNotNull((Object)Assertions.assertThrows(IllegalArgumentException.class, (Executable)new Executable(throwable$iv){
            final /* synthetic */ Throwable $throwable;
            {
                this.$throwable = throwable;
            }

            public final void execute() {
                if (this.$throwable != null) {
                    throw this.$throwable;
                }
            }
        }), (String)"Assertions.assertThrows(\u2026throwable\n        }\n    }");
    }

    @Test
    public final void verify that toString() of Depth#unconstrained() returns the String 'unconstrained'() {
        AssertionsKt.assertEquals$default((Object)"unconstrained", (Object)TrustDepth.Companion.unlimited().toString(), null, (int)4, null);
    }

    @Test
    public final void verify that toString() of a limited Depth returns the String of its value() {
        AssertionsKt.assertEquals$default((Object)"1", (Object)TrustDepth.Companion.limited(1).toString(), null, (int)4, null);
        AssertionsKt.assertEquals$default((Object)"42", (Object)TrustDepth.Companion.limited(42).toString(), null, (int)4, null);
    }
}

