/*
 * Decompiled with CFR 0.152.
 */
package org.pgpainless.wot.network;

import java.util.Date;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Unit;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function1;
import kotlin.test.AssertionsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.junit.jupiter.api.Test;
import org.pgpainless.wot.dsl.NetworkDSL;
import org.pgpainless.wot.network.Edge;
import org.pgpainless.wot.network.Identifier;
import org.pgpainless.wot.network.Network;
import org.pgpainless.wot.network.Node;
import org.pgpainless.wot.network.RegexSet;
import org.pgpainless.wot.network.RevocationState;
import org.pgpainless.wot.network.TrustDepth;
import org.pgpainless.wot.query.Path;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0007\u001a\u00020\bH\u0007J\b\u0010\t\u001a\u00020\bH\u0007R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lorg/pgpainless/wot/network/EdgeComponentTest;", "Lorg/pgpainless/wot/dsl/NetworkDSL;", "()V", "alice", "Lorg/pgpainless/wot/network/Node;", "bob", "charlie", "verify result of toString() on certification signature", "", "verify result of toString() on delegation signature", "wot-generic_test"})
public final class EdgeComponentTest
implements NetworkDSL {
    @NotNull
    private final Node alice = new Node(new Identifier("A"), null, RevocationState.Companion.notRevoked(), MapsKt.mapOf((Pair)new Pair((Object)"Alice <alice@pgpainless.org>", (Object)RevocationState.Companion.notRevoked())));
    @NotNull
    private final Node bob = new Node(new Identifier("B"), null, RevocationState.Companion.notRevoked(), MapsKt.mapOf((Pair)new Pair((Object)"Bob <bob@example.org>", (Object)RevocationState.Companion.notRevoked())));
    @NotNull
    private final Node charlie = new Node(new Identifier("C"), null, RevocationState.Companion.notRevoked(), MapsKt.emptyMap());

    @Test
    public final void verify result of toString() on certification signature() {
        Edge.Certification edgeComponent = this.Certification(this.alice, this.bob, "Bob <bob@example.org>", new Date());
        AssertionsKt.assertEquals$default((Object)"A certifies binding: Bob <bob@example.org> <-> B [120]", (Object)edgeComponent.toString(), null, (int)4, null);
    }

    @Test
    public final void verify result of toString() on delegation signature() {
        Edge.Delegation delegation = this.Delegation(this.alice, this.bob, new Date());
        AssertionsKt.assertEquals$default((Object)"A certifies binding: null <-> B [120]", (Object)delegation.toString(), null, (int)4, null);
    }

    @NotNull
    public Edge.Certification Certification(@NotNull Node issuer, @NotNull Node target, @NotNull String userId) {
        return NetworkDSL.DefaultImpls.Certification((NetworkDSL)this, (Node)issuer, (Node)target, (String)userId);
    }

    @NotNull
    public Edge.Certification Certification(@NotNull Node issuer, @NotNull Node target, @NotNull String targetUserId, @NotNull Date creationTime) {
        return NetworkDSL.DefaultImpls.Certification((NetworkDSL)this, (Node)issuer, (Node)target, (String)targetUserId, (Date)creationTime);
    }

    @NotNull
    public Edge.Delegation Delegation(@NotNull Node issuer, @NotNull Node target) {
        return NetworkDSL.DefaultImpls.Delegation((NetworkDSL)this, (Node)issuer, (Node)target);
    }

    @NotNull
    public Edge.Delegation Delegation(@NotNull Node issuer, @NotNull Node target, @NotNull Date creationTime) {
        return NetworkDSL.DefaultImpls.Delegation((NetworkDSL)this, (Node)issuer, (Node)target, (Date)creationTime);
    }

    @NotNull
    public Edge.Delegation Delegation(@NotNull Node issuer, @NotNull Node target, int amount, int depth) {
        return NetworkDSL.DefaultImpls.Delegation((NetworkDSL)this, (Node)issuer, (Node)target, (int)amount, (int)depth);
    }

    @NotNull
    public Edge.Delegation Delegation(@NotNull Node issuer, @NotNull Node target, int amount, @NotNull TrustDepth depth) {
        return NetworkDSL.DefaultImpls.Delegation((NetworkDSL)this, (Node)issuer, (Node)target, (int)amount, (TrustDepth)depth);
    }

    @NotNull
    public Node Node(@NotNull String fingerprint) {
        return NetworkDSL.DefaultImpls.Node((NetworkDSL)this, (String)fingerprint);
    }

    @NotNull
    public Node Node(@NotNull String fingerprint, @NotNull String userId) {
        return NetworkDSL.DefaultImpls.Node((NetworkDSL)this, (String)fingerprint, (String)userId);
    }

    @NotNull
    public Node Node(@NotNull Node original, @NotNull String userId) {
        return NetworkDSL.DefaultImpls.Node((NetworkDSL)this, (Node)original, (String)userId);
    }

    @NotNull
    public Network buildNetwork(@NotNull Function1<? super Network.Builder, Unit> builderAction) {
        return NetworkDSL.DefaultImpls.buildNetwork((NetworkDSL)this, builderAction);
    }

    @NotNull
    public RegexSet domainRegex(@NotNull String domain) {
        return NetworkDSL.DefaultImpls.domainRegex((NetworkDSL)this, (String)domain);
    }

    @NotNull
    public Network.Builder addEdge(@NotNull Network.Builder $this$addEdge, @NotNull String issuer, @NotNull String target) {
        return NetworkDSL.DefaultImpls.addEdge((NetworkDSL)this, (Network.Builder)$this$addEdge, (String)issuer, (String)target);
    }

    @NotNull
    public Network.Builder addEdge(@NotNull Network.Builder $this$addEdge, @NotNull String issuer, @NotNull String target, @NotNull String userId) {
        return NetworkDSL.DefaultImpls.addEdge((NetworkDSL)this, (Network.Builder)$this$addEdge, (String)issuer, (String)target, (String)userId);
    }

    @NotNull
    public Network.Builder addNode(@NotNull Network.Builder $this$addNode, @NotNull String fingerprint) {
        return NetworkDSL.DefaultImpls.addNode((NetworkDSL)this, (Network.Builder)$this$addNode, (String)fingerprint);
    }

    @NotNull
    public Network.Builder addNode(@NotNull Network.Builder $this$addNode, @NotNull String fingerprint, @NotNull String userId) {
        return NetworkDSL.DefaultImpls.addNode((NetworkDSL)this, (Network.Builder)$this$addNode, (String)fingerprint, (String)userId);
    }

    public void addNodes(@NotNull Network.Builder $this$addNodes, String ... fingerprints) {
        NetworkDSL.DefaultImpls.addNodes((NetworkDSL)this, (Network.Builder)$this$addNodes, (String[])fingerprints);
    }

    public boolean assertNodeFingerprints(@NotNull Path $this$assertNodeFingerprints, @NotNull List<Identifier> fingerprints) {
        return NetworkDSL.DefaultImpls.assertNodeFingerprints((NetworkDSL)this, (Path)$this$assertNodeFingerprints, fingerprints);
    }

    @NotNull
    public Network.Builder buildEdge(@NotNull Network.Builder $this$buildEdge, @NotNull String issuer, @NotNull String target) {
        return NetworkDSL.DefaultImpls.buildEdge((NetworkDSL)this, (Network.Builder)$this$buildEdge, (String)issuer, (String)target);
    }

    @NotNull
    public Network.Builder buildEdge(@NotNull Network.Builder $this$buildEdge, @NotNull String issuer, @NotNull String target, int amount, int depth) {
        return NetworkDSL.DefaultImpls.buildEdge((NetworkDSL)this, (Network.Builder)$this$buildEdge, (String)issuer, (String)target, (int)amount, (int)depth);
    }

    @NotNull
    public Network.Builder buildEdge(@NotNull Network.Builder $this$buildEdge, @NotNull String issuer, @NotNull String target, int amount, int depth, @NotNull RegexSet regexSet) {
        return NetworkDSL.DefaultImpls.buildEdge((NetworkDSL)this, (Network.Builder)$this$buildEdge, (String)issuer, (String)target, (int)amount, (int)depth, (RegexSet)regexSet);
    }

    @NotNull
    public Network.Builder buildEdge(@NotNull Network.Builder $this$buildEdge, @NotNull String issuer, @NotNull String target, @NotNull String userId) {
        return NetworkDSL.DefaultImpls.buildEdge((NetworkDSL)this, (Network.Builder)$this$buildEdge, (String)issuer, (String)target, (String)userId);
    }

    @Nullable
    public List<Edge.Component> getEdgeFor(@NotNull Network $this$getEdgeFor, @NotNull String issuer, @NotNull String target) {
        return NetworkDSL.DefaultImpls.getEdgeFor((NetworkDSL)this, (Network)$this$getEdgeFor, (String)issuer, (String)target);
    }

    @Nullable
    public List<Edge.Component> getEdgeFor(@NotNull Network $this$getEdgeFor, @NotNull String issuer, @NotNull String target, @Nullable String userId) {
        return NetworkDSL.DefaultImpls.getEdgeFor((NetworkDSL)this, (Network)$this$getEdgeFor, (String)issuer, (String)target, (String)userId);
    }

    @Nullable
    public List<Edge.Component> getEdgeFor(@NotNull Network $this$getEdgeFor, @NotNull Identifier issuer, @NotNull Identifier target) {
        return NetworkDSL.DefaultImpls.getEdgeFor((NetworkDSL)this, (Network)$this$getEdgeFor, (Identifier)issuer, (Identifier)target);
    }

    @NotNull
    public List<Edge.Component> getEdgeFor(@NotNull Network $this$getEdgeFor, @NotNull Identifier issuer, @NotNull Identifier target, @Nullable String userId) {
        return NetworkDSL.DefaultImpls.getEdgeFor((NetworkDSL)this, (Network)$this$getEdgeFor, (Identifier)issuer, (Identifier)target, (String)userId);
    }

    @Nullable
    public Edge getEdgesFor(@NotNull Network $this$getEdgesFor, @NotNull String issuer, @NotNull String target) {
        return NetworkDSL.DefaultImpls.getEdgesFor((NetworkDSL)this, (Network)$this$getEdgesFor, (String)issuer, (String)target);
    }

    @Nullable
    public Edge getEdgesFor(@NotNull Network $this$getEdgesFor, @NotNull Identifier issuer, @NotNull Identifier target) {
        return NetworkDSL.DefaultImpls.getEdgesFor((NetworkDSL)this, (Network)$this$getEdgesFor, (Identifier)issuer, (Identifier)target);
    }

    @NotNull
    public Date plusDays(@NotNull Date $this$plusDays, long days) {
        return NetworkDSL.DefaultImpls.plusDays((NetworkDSL)this, (Date)$this$plusDays, (long)days);
    }

    @NotNull
    public Date plusHours(@NotNull Date $this$plusHours, long hours) {
        return NetworkDSL.DefaultImpls.plusHours((NetworkDSL)this, (Date)$this$plusHours, (long)hours);
    }

    @NotNull
    public Date plusMillis(@NotNull Date $this$plusMillis, long millis) {
        return NetworkDSL.DefaultImpls.plusMillis((NetworkDSL)this, (Date)$this$plusMillis, (long)millis);
    }

    @NotNull
    public Date plusMinutes(@NotNull Date $this$plusMinutes, long minutes) {
        return NetworkDSL.DefaultImpls.plusMinutes((NetworkDSL)this, (Date)$this$plusMinutes, (long)minutes);
    }

    @NotNull
    public Date plusSeconds(@NotNull Date $this$plusSeconds, long seconds) {
        return NetworkDSL.DefaultImpls.plusSeconds((NetworkDSL)this, (Date)$this$plusSeconds, (long)seconds);
    }
}

