/*
 * Decompiled with CFR 0.152.
 */
package org.pgpainless.wot.network;

import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.test.AssertionsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.function.Executable;
import org.pgpainless.wot.dsl.NetworkDSL;
import org.pgpainless.wot.network.Edge;
import org.pgpainless.wot.network.Identifier;
import org.pgpainless.wot.network.Network;
import org.pgpainless.wot.network.Node;
import org.pgpainless.wot.network.RegexSet;
import org.pgpainless.wot.network.RevocationState;
import org.pgpainless.wot.network.TrustDepth;
import org.pgpainless.wot.query.Path;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u000b\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\r\u001a\u00020\u000eH\u0007J\b\u0010\u000f\u001a\u00020\u000eH\u0007J\b\u0010\u0010\u001a\u00020\u000eH\u0007J\b\u0010\u0011\u001a\u00020\u000eH\u0007J\b\u0010\u0012\u001a\u00020\u000eH\u0007J\b\u0010\u0013\u001a\u00020\u000eH\u0007J\b\u0010\u0014\u001a\u00020\u000eH\u0007J\b\u0010\u0015\u001a\u00020\u000eH\u0007J\b\u0010\u0016\u001a\u00020\u000eH\u0007J\b\u0010\u0017\u001a\u00020\u000eH\u0007J\b\u0010\u0018\u001a\u00020\u000eH\u0007R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Lorg/pgpainless/wot/network/EdgeTest;", "Lorg/pgpainless/wot/dsl/NetworkDSL;", "()V", "alice", "Lorg/pgpainless/wot/network/Node;", "aliceSignsBob", "Lorg/pgpainless/wot/network/Edge$Delegation;", "aliceSignsBobUserId", "Lorg/pgpainless/wot/network/Edge$Certification;", "aliceSignsCharlie", "bob", "charlie", "charlieSignsBob", "verify that add()ing another component fails if the issuer mismatches", "", "verify that add()ing another component fails if the target mismatches", "verify that add()ing edge components works if issuer and target match that of the edge", "verify that for multiple components over the same datum, only the most recent components are preserved", "verify that merge()ing an edge with itself is idempotent", "verify that merge()ing another edge with mismatched issuer fails", "verify that merge()ing another edge with mismatched target fails", "verify that merge()ing another edge works if issuer and target match that of the edge", "verify that properties of an empty edge are also empty", "verify that toString() of a edge with two components matches our expectations", "verify that toString() of an empty edge is the empty string", "wot-generic_test"})
@SourceDebugExtension(value={"SMAP\nEdgeTest.kt\nKotlin\n*S Kotlin\n*F\n+ 1 EdgeTest.kt\norg/pgpainless/wot/network/EdgeTest\n+ 2 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n+ 3 Assertions.kt\norg/junit/jupiter/api/AssertionsKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,131:1\n187#2,3:132\n100#3,7:135\n100#3,7:142\n100#3,7:150\n100#3,7:157\n1#4:149\n*S KotlinDebug\n*F\n+ 1 EdgeTest.kt\norg/pgpainless/wot/network/EdgeTest\n*L\n39#1:132,3\n50#1:135,7\n56#1:142,7\n75#1:150,7\n83#1:157,7\n*E\n"})
public final class EdgeTest
implements NetworkDSL {
    @NotNull
    private final Node alice = new Node(new Identifier("A"), null, RevocationState.Companion.notRevoked(), MapsKt.emptyMap());
    @NotNull
    private final Node bob = new Node(new Identifier("B"), null, RevocationState.Companion.notRevoked(), MapsKt.emptyMap());
    @NotNull
    private final Node charlie = new Node(new Identifier("C"), null, RevocationState.Companion.notRevoked(), MapsKt.emptyMap());
    @NotNull
    private final Edge.Delegation aliceSignsBob = this.Delegation(this.alice, this.bob, new Date());
    @NotNull
    private final Edge.Certification aliceSignsBobUserId = this.Certification(this.alice, this.bob, "Bob <bob@example.org>", new Date());
    @NotNull
    private final Edge.Delegation aliceSignsCharlie = this.Delegation(this.alice, this.charlie, new Date());
    @NotNull
    private final Edge.Delegation charlieSignsBob = this.Delegation(this.charlie, this.bob, new Date());

    @Test
    public final void verify that properties of an empty edge are also empty() {
        Edge empty = new Edge(this.alice, this.bob);
        boolean bl = empty.components().isEmpty();
        if (_Assertions.ENABLED && !bl) {
            String string = "Assertion failed";
            throw new AssertionError((Object)string);
        }
        AssertionsKt.assertEquals$default((Object)this.alice, (Object)empty.getIssuer(), null, (int)4, null);
        AssertionsKt.assertEquals$default((Object)this.bob, (Object)empty.getTarget(), null, (int)4, null);
    }

    @Test
    public final void verify that add()ing edge components works if issuer and target match that of the edge() {
        boolean bl;
        String string;
        Edge set;
        block3: {
            set = new Edge(this.alice, this.bob);
            set.addComponent((Edge.Component)this.aliceSignsBob);
            string = null;
            boolean bl2 = false;
            Map $this$any$iv = set.components();
            boolean $i$f$any = false;
            if ($this$any$iv.isEmpty()) {
                bl = false;
            } else {
                Iterator iterator = $this$any$iv.entrySet().iterator();
                while (iterator.hasNext()) {
                    Map.Entry element$iv;
                    Map.Entry it = element$iv = iterator.next();
                    boolean bl3 = false;
                    if (!((List)it.getValue()).contains(this.aliceSignsBob)) continue;
                    bl = true;
                    break block3;
                }
                bl = false;
            }
        }
        AssertionsKt.assertTrue((boolean)bl, string);
        set.addComponent((Edge.Component)this.aliceSignsBobUserId);
        string = null;
        boolean bl4 = false;
        Object v = set.components().get("Bob <bob@example.org>");
        Intrinsics.checkNotNull(v);
        AssertionsKt.assertTrue((boolean)((List)v).contains(this.aliceSignsBobUserId), string);
    }

    @Test
    public final void verify that add()ing another component fails if the issuer mismatches() {
        Throwable throwable;
        Throwable throwable2;
        Edge set = new Edge(this.alice, this.bob);
        boolean $i$f$assertThrows = false;
        try {
            boolean bl = false;
            set.addComponent((Edge.Component)this.charlieSignsBob);
            throwable2 = Unit.INSTANCE;
        }
        catch (Throwable caught$iv) {
            throwable2 = caught$iv;
        }
        if (!((throwable = throwable2) instanceof Throwable)) {
            throwable = null;
        }
        Throwable throwable$iv = throwable;
        Intrinsics.checkExpressionValueIsNotNull((Object)Assertions.assertThrows(IllegalArgumentException.class, (Executable)new Executable(throwable$iv){
            final /* synthetic */ Throwable $throwable;
            {
                this.$throwable = throwable;
            }

            public final void execute() {
                if (this.$throwable != null) {
                    throw this.$throwable;
                }
            }
        }), (String)"Assertions.assertThrows(\u2026throwable\n        }\n    }");
    }

    @Test
    public final void verify that add()ing another component fails if the target mismatches() {
        Throwable throwable;
        Throwable throwable2;
        Edge set = new Edge(this.alice, this.bob);
        boolean $i$f$assertThrows = false;
        try {
            boolean bl = false;
            set.addComponent((Edge.Component)this.aliceSignsCharlie);
            throwable2 = Unit.INSTANCE;
        }
        catch (Throwable caught$iv) {
            throwable2 = caught$iv;
        }
        if (!((throwable = throwable2) instanceof Throwable)) {
            throwable = null;
        }
        Throwable throwable$iv = throwable;
        Intrinsics.checkExpressionValueIsNotNull((Object)Assertions.assertThrows(IllegalArgumentException.class, (Executable)new Executable(throwable$iv){
            final /* synthetic */ Throwable $throwable;
            {
                this.$throwable = throwable;
            }

            public final void execute() {
                if (this.$throwable != null) {
                    throw this.$throwable;
                }
            }
        }), (String)"Assertions.assertThrows(\u2026throwable\n        }\n    }");
    }

    @Test
    public final void verify that merge()ing another edge works if issuer and target match that of the edge() {
        Edge set = new Edge((Edge.Component)this.aliceSignsBob);
        Edge others = new Edge((Edge.Component)this.aliceSignsBobUserId);
        set.join(others);
        AssertionsKt.assertEquals$default((Object)2, (Object)set.components().size(), null, (int)4, null);
        String string = null;
        boolean bl = false;
        Object v = set.components().get(null);
        Intrinsics.checkNotNull(v);
        AssertionsKt.assertTrue((boolean)((List)v).contains(this.aliceSignsBob), string);
        string = null;
        boolean bl2 = false;
        Object v2 = set.components().get("Bob <bob@example.org>");
        Intrinsics.checkNotNull(v2);
        AssertionsKt.assertTrue((boolean)((List)v2).contains(this.aliceSignsBobUserId), string);
    }

    @Test
    public final void verify that merge()ing another edge with mismatched issuer fails() {
        Throwable throwable;
        Throwable throwable2;
        Edge set = new Edge((Edge.Component)this.aliceSignsBob);
        Edge issuerMismatch = new Edge((Edge.Component)this.charlieSignsBob);
        boolean $i$f$assertThrows = false;
        try {
            boolean bl = false;
            set.join(issuerMismatch);
            throwable2 = Unit.INSTANCE;
        }
        catch (Throwable caught$iv) {
            throwable2 = caught$iv;
        }
        if (!((throwable = throwable2) instanceof Throwable)) {
            throwable = null;
        }
        Throwable throwable$iv = throwable;
        Intrinsics.checkExpressionValueIsNotNull((Object)Assertions.assertThrows(IllegalArgumentException.class, (Executable)new Executable(throwable$iv){
            final /* synthetic */ Throwable $throwable;
            {
                this.$throwable = throwable;
            }

            public final void execute() {
                if (this.$throwable != null) {
                    throw this.$throwable;
                }
            }
        }), (String)"Assertions.assertThrows(\u2026throwable\n        }\n    }");
    }

    @Test
    public final void verify that merge()ing another edge with mismatched target fails() {
        Throwable throwable;
        Throwable throwable2;
        Edge set = new Edge((Edge.Component)this.aliceSignsBob);
        Edge targetMismatch = new Edge((Edge.Component)this.aliceSignsCharlie);
        boolean $i$f$assertThrows = false;
        try {
            boolean bl = false;
            set.join(targetMismatch);
            throwable2 = Unit.INSTANCE;
        }
        catch (Throwable caught$iv) {
            throwable2 = caught$iv;
        }
        if (!((throwable = throwable2) instanceof Throwable)) {
            throwable = null;
        }
        Throwable throwable$iv = throwable;
        Intrinsics.checkExpressionValueIsNotNull((Object)Assertions.assertThrows(IllegalArgumentException.class, (Executable)new Executable(throwable$iv){
            final /* synthetic */ Throwable $throwable;
            {
                this.$throwable = throwable;
            }

            public final void execute() {
                if (this.$throwable != null) {
                    throw this.$throwable;
                }
            }
        }), (String)"Assertions.assertThrows(\u2026throwable\n        }\n    }");
    }

    @Test
    public final void verify that merge()ing an edge with itself is idempotent() {
        Edge set = new Edge((Edge.Component)this.aliceSignsBob);
        AssertionsKt.assertEquals$default((Object)1, (Object)set.components().size(), null, (int)4, null);
        set.join(set);
        AssertionsKt.assertEquals$default((Object)1, (Object)set.components().size(), null, (int)4, null);
    }

    @Test
    public final void verify that toString() of an empty edge is the empty string() {
        Edge empty = new Edge(this.alice, this.bob);
        AssertionsKt.assertEquals$default((Object)"", (Object)empty.toString(), null, (int)4, null);
    }

    @Test
    public final void verify that toString() of a edge with two components matches our expectations() {
        Edge twoCerts = new Edge((Edge.Component)this.aliceSignsBob);
        twoCerts.addComponent((Edge.Component)this.aliceSignsBobUserId);
        AssertionsKt.assertEquals$default((Object)"A certifies binding: Bob <bob@example.org> <-> B [120]\nA certifies binding: null <-> B [120]\n", (Object)twoCerts.toString(), null, (int)4, null);
    }

    @Test
    public final void verify that for multiple components over the same datum, only the most recent components are preserved() {
        Date now = new Date();
        Date fiveSecondsBefore = new Date(now.getTime() - (long)5000);
        Edge.Certification old = this.Certification(this.alice, this.bob, "Bob <bob@example.org>", fiveSecondsBefore);
        Edge.Certification certification = this.Certification(this.alice, this.bob, "Bob <bob@example.org>", now);
        Edge.Certification new2 = new Edge.Certification(this.alice, this.bob, "Bob <bob@example.org>", now, null, true, Integer.valueOf(44), TrustDepth.Companion.auto(10), null, 256, null);
        Edge set = new Edge(this.alice, this.bob);
        set.addComponent((Edge.Component)old);
        AssertionsKt.assertEquals$default((Object)CollectionsKt.listOf((Object)old), set.components().get("Bob <bob@example.org>"), null, (int)4, null);
        set.addComponent((Edge.Component)certification);
        AssertionsKt.assertEquals$default((Object)CollectionsKt.listOf((Object)certification), set.components().get("Bob <bob@example.org>"), null, (int)4, null);
        set.addComponent((Edge.Component)new2);
        Object[] objectArray = new Edge.Certification[]{certification, new2};
        AssertionsKt.assertEquals$default((Object)CollectionsKt.listOf((Object[])objectArray), set.components().get("Bob <bob@example.org>"), null, (int)4, null);
        set.addComponent((Edge.Component)old);
        objectArray = new Edge.Certification[]{certification, new2};
        AssertionsKt.assertEquals$default((Object)CollectionsKt.listOf((Object[])objectArray), set.components().get("Bob <bob@example.org>"), null, (int)4, null);
    }

    @NotNull
    public Edge.Certification Certification(@NotNull Node issuer, @NotNull Node target, @NotNull String userId) {
        return NetworkDSL.DefaultImpls.Certification((NetworkDSL)this, (Node)issuer, (Node)target, (String)userId);
    }

    @NotNull
    public Edge.Certification Certification(@NotNull Node issuer, @NotNull Node target, @NotNull String targetUserId, @NotNull Date creationTime) {
        return NetworkDSL.DefaultImpls.Certification((NetworkDSL)this, (Node)issuer, (Node)target, (String)targetUserId, (Date)creationTime);
    }

    @NotNull
    public Edge.Delegation Delegation(@NotNull Node issuer, @NotNull Node target) {
        return NetworkDSL.DefaultImpls.Delegation((NetworkDSL)this, (Node)issuer, (Node)target);
    }

    @NotNull
    public Edge.Delegation Delegation(@NotNull Node issuer, @NotNull Node target, @NotNull Date creationTime) {
        return NetworkDSL.DefaultImpls.Delegation((NetworkDSL)this, (Node)issuer, (Node)target, (Date)creationTime);
    }

    @NotNull
    public Edge.Delegation Delegation(@NotNull Node issuer, @NotNull Node target, int amount, int depth) {
        return NetworkDSL.DefaultImpls.Delegation((NetworkDSL)this, (Node)issuer, (Node)target, (int)amount, (int)depth);
    }

    @NotNull
    public Edge.Delegation Delegation(@NotNull Node issuer, @NotNull Node target, int amount, @NotNull TrustDepth depth) {
        return NetworkDSL.DefaultImpls.Delegation((NetworkDSL)this, (Node)issuer, (Node)target, (int)amount, (TrustDepth)depth);
    }

    @NotNull
    public Node Node(@NotNull String fingerprint) {
        return NetworkDSL.DefaultImpls.Node((NetworkDSL)this, (String)fingerprint);
    }

    @NotNull
    public Node Node(@NotNull String fingerprint, @NotNull String userId) {
        return NetworkDSL.DefaultImpls.Node((NetworkDSL)this, (String)fingerprint, (String)userId);
    }

    @NotNull
    public Node Node(@NotNull Node original, @NotNull String userId) {
        return NetworkDSL.DefaultImpls.Node((NetworkDSL)this, (Node)original, (String)userId);
    }

    @NotNull
    public Network buildNetwork(@NotNull Function1<? super Network.Builder, Unit> builderAction) {
        return NetworkDSL.DefaultImpls.buildNetwork((NetworkDSL)this, builderAction);
    }

    @NotNull
    public RegexSet domainRegex(@NotNull String domain) {
        return NetworkDSL.DefaultImpls.domainRegex((NetworkDSL)this, (String)domain);
    }

    @NotNull
    public Network.Builder addEdge(@NotNull Network.Builder $this$addEdge, @NotNull String issuer, @NotNull String target) {
        return NetworkDSL.DefaultImpls.addEdge((NetworkDSL)this, (Network.Builder)$this$addEdge, (String)issuer, (String)target);
    }

    @NotNull
    public Network.Builder addEdge(@NotNull Network.Builder $this$addEdge, @NotNull String issuer, @NotNull String target, @NotNull String userId) {
        return NetworkDSL.DefaultImpls.addEdge((NetworkDSL)this, (Network.Builder)$this$addEdge, (String)issuer, (String)target, (String)userId);
    }

    @NotNull
    public Network.Builder addNode(@NotNull Network.Builder $this$addNode, @NotNull String fingerprint) {
        return NetworkDSL.DefaultImpls.addNode((NetworkDSL)this, (Network.Builder)$this$addNode, (String)fingerprint);
    }

    @NotNull
    public Network.Builder addNode(@NotNull Network.Builder $this$addNode, @NotNull String fingerprint, @NotNull String userId) {
        return NetworkDSL.DefaultImpls.addNode((NetworkDSL)this, (Network.Builder)$this$addNode, (String)fingerprint, (String)userId);
    }

    public void addNodes(@NotNull Network.Builder $this$addNodes, String ... fingerprints) {
        NetworkDSL.DefaultImpls.addNodes((NetworkDSL)this, (Network.Builder)$this$addNodes, (String[])fingerprints);
    }

    public boolean assertNodeFingerprints(@NotNull Path $this$assertNodeFingerprints, @NotNull List<Identifier> fingerprints) {
        return NetworkDSL.DefaultImpls.assertNodeFingerprints((NetworkDSL)this, (Path)$this$assertNodeFingerprints, fingerprints);
    }

    @NotNull
    public Network.Builder buildEdge(@NotNull Network.Builder $this$buildEdge, @NotNull String issuer, @NotNull String target) {
        return NetworkDSL.DefaultImpls.buildEdge((NetworkDSL)this, (Network.Builder)$this$buildEdge, (String)issuer, (String)target);
    }

    @NotNull
    public Network.Builder buildEdge(@NotNull Network.Builder $this$buildEdge, @NotNull String issuer, @NotNull String target, int amount, int depth) {
        return NetworkDSL.DefaultImpls.buildEdge((NetworkDSL)this, (Network.Builder)$this$buildEdge, (String)issuer, (String)target, (int)amount, (int)depth);
    }

    @NotNull
    public Network.Builder buildEdge(@NotNull Network.Builder $this$buildEdge, @NotNull String issuer, @NotNull String target, int amount, int depth, @NotNull RegexSet regexSet) {
        return NetworkDSL.DefaultImpls.buildEdge((NetworkDSL)this, (Network.Builder)$this$buildEdge, (String)issuer, (String)target, (int)amount, (int)depth, (RegexSet)regexSet);
    }

    @NotNull
    public Network.Builder buildEdge(@NotNull Network.Builder $this$buildEdge, @NotNull String issuer, @NotNull String target, @NotNull String userId) {
        return NetworkDSL.DefaultImpls.buildEdge((NetworkDSL)this, (Network.Builder)$this$buildEdge, (String)issuer, (String)target, (String)userId);
    }

    @Nullable
    public List<Edge.Component> getEdgeFor(@NotNull Network $this$getEdgeFor, @NotNull String issuer, @NotNull String target) {
        return NetworkDSL.DefaultImpls.getEdgeFor((NetworkDSL)this, (Network)$this$getEdgeFor, (String)issuer, (String)target);
    }

    @Nullable
    public List<Edge.Component> getEdgeFor(@NotNull Network $this$getEdgeFor, @NotNull String issuer, @NotNull String target, @Nullable String userId) {
        return NetworkDSL.DefaultImpls.getEdgeFor((NetworkDSL)this, (Network)$this$getEdgeFor, (String)issuer, (String)target, (String)userId);
    }

    @Nullable
    public List<Edge.Component> getEdgeFor(@NotNull Network $this$getEdgeFor, @NotNull Identifier issuer, @NotNull Identifier target) {
        return NetworkDSL.DefaultImpls.getEdgeFor((NetworkDSL)this, (Network)$this$getEdgeFor, (Identifier)issuer, (Identifier)target);
    }

    @NotNull
    public List<Edge.Component> getEdgeFor(@NotNull Network $this$getEdgeFor, @NotNull Identifier issuer, @NotNull Identifier target, @Nullable String userId) {
        return NetworkDSL.DefaultImpls.getEdgeFor((NetworkDSL)this, (Network)$this$getEdgeFor, (Identifier)issuer, (Identifier)target, (String)userId);
    }

    @Nullable
    public Edge getEdgesFor(@NotNull Network $this$getEdgesFor, @NotNull String issuer, @NotNull String target) {
        return NetworkDSL.DefaultImpls.getEdgesFor((NetworkDSL)this, (Network)$this$getEdgesFor, (String)issuer, (String)target);
    }

    @Nullable
    public Edge getEdgesFor(@NotNull Network $this$getEdgesFor, @NotNull Identifier issuer, @NotNull Identifier target) {
        return NetworkDSL.DefaultImpls.getEdgesFor((NetworkDSL)this, (Network)$this$getEdgesFor, (Identifier)issuer, (Identifier)target);
    }

    @NotNull
    public Date plusDays(@NotNull Date $this$plusDays, long days) {
        return NetworkDSL.DefaultImpls.plusDays((NetworkDSL)this, (Date)$this$plusDays, (long)days);
    }

    @NotNull
    public Date plusHours(@NotNull Date $this$plusHours, long hours) {
        return NetworkDSL.DefaultImpls.plusHours((NetworkDSL)this, (Date)$this$plusHours, (long)hours);
    }

    @NotNull
    public Date plusMillis(@NotNull Date $this$plusMillis, long millis) {
        return NetworkDSL.DefaultImpls.plusMillis((NetworkDSL)this, (Date)$this$plusMillis, (long)millis);
    }

    @NotNull
    public Date plusMinutes(@NotNull Date $this$plusMinutes, long minutes) {
        return NetworkDSL.DefaultImpls.plusMinutes((NetworkDSL)this, (Date)$this$plusMinutes, (long)minutes);
    }

    @NotNull
    public Date plusSeconds(@NotNull Date $this$plusSeconds, long seconds) {
        return NetworkDSL.DefaultImpls.plusSeconds((NetworkDSL)this, (Date)$this$plusSeconds, (long)seconds);
    }
}

