/*
 * Decompiled with CFR 0.152.
 */
package org.pgpainless.wot.network;

import java.util.Date;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.test.AssertionsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.junit.jupiter.api.Test;
import org.pgpainless.wot.dsl.NetworkDSL;
import org.pgpainless.wot.network.Edge;
import org.pgpainless.wot.network.Identifier;
import org.pgpainless.wot.network.Network;
import org.pgpainless.wot.network.Node;
import org.pgpainless.wot.network.RegexSet;
import org.pgpainless.wot.network.TrustDepth;
import org.pgpainless.wot.query.Path;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0006\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0003\u001a\u00020\u0004H\u0007J\b\u0010\u0005\u001a\u00020\u0004H\u0007J\b\u0010\u0006\u001a\u00020\u0004H\u0007J\b\u0010\u0007\u001a\u00020\u0004H\u0007J\b\u0010\b\u001a\u00020\u0004H\u0007J\b\u0010\t\u001a\u00020\u0004H\u0007\u00a8\u0006\n"}, d2={"Lorg/pgpainless/wot/network/NetworkTest;", "Lorg/pgpainless/wot/dsl/NetworkDSL;", "()V", "play with depths, amounts and regexes", "", "testEmptyNetworkIsEmpty", "testSimpleNetwork", "verify that adding a single node works", "verify that adding multiple, non-connected nodes works", "verify that network with 2 edges between 2 nodes keeps edges", "wot-generic_test"})
@SourceDebugExtension(value={"SMAP\nNetworkTest.kt\nKotlin\n*S Kotlin\n*F\n+ 1 NetworkTest.kt\norg/pgpainless/wot/network/NetworkTest\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,75:1\n1#2:76\n*E\n"})
public final class NetworkTest
implements NetworkDSL {
    @Test
    public final void testEmptyNetworkIsEmpty() {
        Network network2 = new Network();
        boolean bl = network2.getNodes().isEmpty();
        if (_Assertions.ENABLED && !bl) {
            String string = "Assertion failed";
            throw new AssertionError((Object)string);
        }
        bl = network2.getEdges().isEmpty();
        if (_Assertions.ENABLED && !bl) {
            String string = "Assertion failed";
            throw new AssertionError((Object)string);
        }
        AssertionsKt.assertEquals$default((Object)0, (Object)network2.getNumberOfEdges(), null, (int)4, null);
        AssertionsKt.assertEquals$default((Object)0, (Object)network2.getNumberOfSignatures(), null, (int)4, null);
    }

    @Test
    public final void verify that adding a single node works() {
        Network network2 = this.buildNetwork((Function1<? super Network.Builder, Unit>)((Function1)new Function1<Network.Builder, Unit>(this){
            final /* synthetic */ NetworkTest this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            public final void invoke(@NotNull Network.Builder $this$buildNetwork) {
                Intrinsics.checkNotNullParameter((Object)$this$buildNetwork, (String)"$this$buildNetwork");
                this.this$0.addNode($this$buildNetwork, "A");
            }
        }));
        AssertionsKt.assertEquals$default((Object)1, (Object)network2.getNodes().size(), null, (int)4, null);
        String string = null;
        boolean bl = false;
        AssertionsKt.assertTrue((boolean)network2.getNodes().containsKey(new Identifier("A")), string);
    }

    @Test
    public final void verify that adding multiple, non-connected nodes works() {
        Network network2 = this.buildNetwork((Function1<? super Network.Builder, Unit>)((Function1)new Function1<Network.Builder, Unit>(this){
            final /* synthetic */ NetworkTest this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            public final void invoke(@NotNull Network.Builder $this$buildNetwork) {
                Intrinsics.checkNotNullParameter((Object)$this$buildNetwork, (String)"$this$buildNetwork");
                String[] stringArray = new String[]{"A", "B", "C", "D"};
                this.this$0.addNodes($this$buildNetwork, stringArray);
            }
        }));
        AssertionsKt.assertEquals$default((Object)4, (Object)network2.getNodes().size(), null, (int)4, null);
    }

    @Test
    public final void testSimpleNetwork() {
        Network network2 = this.buildNetwork((Function1<? super Network.Builder, Unit>)((Function1)new Function1<Network.Builder, Unit>(this){
            final /* synthetic */ NetworkTest this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            public final void invoke(@NotNull Network.Builder $this$buildNetwork) {
                Intrinsics.checkNotNullParameter((Object)$this$buildNetwork, (String)"$this$buildNetwork");
                this.this$0.buildEdge($this$buildNetwork, "A", "B");
                this.this$0.buildEdge($this$buildNetwork, "A", "C", "Charlie <charlie@example.org>");
            }
        }));
        AssertionsKt.assertEquals$default((Object)"Network with 3 nodes, 2 edges:\nA certifies binding: null <-> B [120]\nA certifies binding: Charlie <charlie@example.org> <-> C [120]\n", (Object)network2.toString(), null, (int)4, null);
    }

    @Test
    public final void verify that network with 2 edges between 2 nodes keeps edges() {
        Network network2 = this.buildNetwork((Function1<? super Network.Builder, Unit>)((Function1)new Function1<Network.Builder, Unit>(this){
            final /* synthetic */ NetworkTest this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            public final void invoke(@NotNull Network.Builder $this$buildNetwork) {
                Intrinsics.checkNotNullParameter((Object)$this$buildNetwork, (String)"$this$buildNetwork");
                this.this$0.buildEdge($this$buildNetwork, "A", "B");
                this.this$0.buildEdge($this$buildNetwork, "A", "B", "Bob");
            }
        }));
        AssertionsKt.assertEquals$default((Object)2, (Object)network2.getNumberOfSignatures(), null, (int)4, null);
    }

    @Test
    public final void play with depths, amounts and regexes() {
        Network network2 = this.buildNetwork((Function1<? super Network.Builder, Unit>)((Function1)new Function1<Network.Builder, Unit>(this){
            final /* synthetic */ NetworkTest this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            public final void invoke(@NotNull Network.Builder $this$buildNetwork) {
                Intrinsics.checkNotNullParameter((Object)$this$buildNetwork, (String)"$this$buildNetwork");
                this.this$0.buildEdge($this$buildNetwork, "A", "B", 120, 10);
                this.this$0.buildEdge($this$buildNetwork, "B", "C", 60, 5, RegexSet.Companion.fromExpression("*"));
                this.this$0.buildEdge($this$buildNetwork, "A", "C", 10, 0);
            }
        }));
        AssertionsKt.assertEquals$default((Object)3, (Object)network2.getNodes().size(), null, (int)4, null);
        AssertionsKt.assertEquals$default((Object)3, (Object)network2.getNumberOfEdges(), null, (int)4, null);
        AssertionsKt.assertEquals$default((Object)3, (Object)network2.getNumberOfSignatures(), null, (int)4, null);
        Integer n = 120;
        List<Edge.Component> list = this.getEdgeFor(network2, "A", "B");
        Intrinsics.checkNotNull(list);
        AssertionsKt.assertEquals$default((Object)n, (Object)((Edge.Component)CollectionsKt.first(list)).getTrustAmount(), null, (int)4, null);
        Integer n2 = 10;
        List<Edge.Component> list2 = this.getEdgeFor(network2, "A", "B");
        Intrinsics.checkNotNull(list2);
        AssertionsKt.assertEquals$default((Object)n2, (Object)((Edge.Component)CollectionsKt.first(list2)).getTrustDepth().getValue(), null, (int)4, null);
    }

    @NotNull
    public Edge.Certification Certification(@NotNull Node issuer, @NotNull Node target, @NotNull String userId) {
        return NetworkDSL.DefaultImpls.Certification((NetworkDSL)this, (Node)issuer, (Node)target, (String)userId);
    }

    @NotNull
    public Edge.Certification Certification(@NotNull Node issuer, @NotNull Node target, @NotNull String targetUserId, @NotNull Date creationTime) {
        return NetworkDSL.DefaultImpls.Certification((NetworkDSL)this, (Node)issuer, (Node)target, (String)targetUserId, (Date)creationTime);
    }

    @NotNull
    public Edge.Delegation Delegation(@NotNull Node issuer, @NotNull Node target) {
        return NetworkDSL.DefaultImpls.Delegation((NetworkDSL)this, (Node)issuer, (Node)target);
    }

    @NotNull
    public Edge.Delegation Delegation(@NotNull Node issuer, @NotNull Node target, @NotNull Date creationTime) {
        return NetworkDSL.DefaultImpls.Delegation((NetworkDSL)this, (Node)issuer, (Node)target, (Date)creationTime);
    }

    @NotNull
    public Edge.Delegation Delegation(@NotNull Node issuer, @NotNull Node target, int amount, int depth) {
        return NetworkDSL.DefaultImpls.Delegation((NetworkDSL)this, (Node)issuer, (Node)target, (int)amount, (int)depth);
    }

    @NotNull
    public Edge.Delegation Delegation(@NotNull Node issuer, @NotNull Node target, int amount, @NotNull TrustDepth depth) {
        return NetworkDSL.DefaultImpls.Delegation((NetworkDSL)this, (Node)issuer, (Node)target, (int)amount, (TrustDepth)depth);
    }

    @NotNull
    public Node Node(@NotNull String fingerprint) {
        return NetworkDSL.DefaultImpls.Node((NetworkDSL)this, (String)fingerprint);
    }

    @NotNull
    public Node Node(@NotNull String fingerprint, @NotNull String userId) {
        return NetworkDSL.DefaultImpls.Node((NetworkDSL)this, (String)fingerprint, (String)userId);
    }

    @NotNull
    public Node Node(@NotNull Node original, @NotNull String userId) {
        return NetworkDSL.DefaultImpls.Node((NetworkDSL)this, (Node)original, (String)userId);
    }

    @NotNull
    public Network buildNetwork(@NotNull Function1<? super Network.Builder, Unit> builderAction) {
        return NetworkDSL.DefaultImpls.buildNetwork((NetworkDSL)this, builderAction);
    }

    @NotNull
    public RegexSet domainRegex(@NotNull String domain) {
        return NetworkDSL.DefaultImpls.domainRegex((NetworkDSL)this, (String)domain);
    }

    @NotNull
    public Network.Builder addEdge(@NotNull Network.Builder $this$addEdge, @NotNull String issuer, @NotNull String target) {
        return NetworkDSL.DefaultImpls.addEdge((NetworkDSL)this, (Network.Builder)$this$addEdge, (String)issuer, (String)target);
    }

    @NotNull
    public Network.Builder addEdge(@NotNull Network.Builder $this$addEdge, @NotNull String issuer, @NotNull String target, @NotNull String userId) {
        return NetworkDSL.DefaultImpls.addEdge((NetworkDSL)this, (Network.Builder)$this$addEdge, (String)issuer, (String)target, (String)userId);
    }

    @NotNull
    public Network.Builder addNode(@NotNull Network.Builder $this$addNode, @NotNull String fingerprint) {
        return NetworkDSL.DefaultImpls.addNode((NetworkDSL)this, (Network.Builder)$this$addNode, (String)fingerprint);
    }

    @NotNull
    public Network.Builder addNode(@NotNull Network.Builder $this$addNode, @NotNull String fingerprint, @NotNull String userId) {
        return NetworkDSL.DefaultImpls.addNode((NetworkDSL)this, (Network.Builder)$this$addNode, (String)fingerprint, (String)userId);
    }

    public void addNodes(@NotNull Network.Builder $this$addNodes, String ... fingerprints) {
        NetworkDSL.DefaultImpls.addNodes((NetworkDSL)this, (Network.Builder)$this$addNodes, (String[])fingerprints);
    }

    public boolean assertNodeFingerprints(@NotNull Path $this$assertNodeFingerprints, @NotNull List<Identifier> fingerprints) {
        return NetworkDSL.DefaultImpls.assertNodeFingerprints((NetworkDSL)this, (Path)$this$assertNodeFingerprints, fingerprints);
    }

    @NotNull
    public Network.Builder buildEdge(@NotNull Network.Builder $this$buildEdge, @NotNull String issuer, @NotNull String target) {
        return NetworkDSL.DefaultImpls.buildEdge((NetworkDSL)this, (Network.Builder)$this$buildEdge, (String)issuer, (String)target);
    }

    @NotNull
    public Network.Builder buildEdge(@NotNull Network.Builder $this$buildEdge, @NotNull String issuer, @NotNull String target, int amount, int depth) {
        return NetworkDSL.DefaultImpls.buildEdge((NetworkDSL)this, (Network.Builder)$this$buildEdge, (String)issuer, (String)target, (int)amount, (int)depth);
    }

    @NotNull
    public Network.Builder buildEdge(@NotNull Network.Builder $this$buildEdge, @NotNull String issuer, @NotNull String target, int amount, int depth, @NotNull RegexSet regexSet) {
        return NetworkDSL.DefaultImpls.buildEdge((NetworkDSL)this, (Network.Builder)$this$buildEdge, (String)issuer, (String)target, (int)amount, (int)depth, (RegexSet)regexSet);
    }

    @NotNull
    public Network.Builder buildEdge(@NotNull Network.Builder $this$buildEdge, @NotNull String issuer, @NotNull String target, @NotNull String userId) {
        return NetworkDSL.DefaultImpls.buildEdge((NetworkDSL)this, (Network.Builder)$this$buildEdge, (String)issuer, (String)target, (String)userId);
    }

    @Nullable
    public List<Edge.Component> getEdgeFor(@NotNull Network $this$getEdgeFor, @NotNull String issuer, @NotNull String target) {
        return NetworkDSL.DefaultImpls.getEdgeFor((NetworkDSL)this, (Network)$this$getEdgeFor, (String)issuer, (String)target);
    }

    @Nullable
    public List<Edge.Component> getEdgeFor(@NotNull Network $this$getEdgeFor, @NotNull String issuer, @NotNull String target, @Nullable String userId) {
        return NetworkDSL.DefaultImpls.getEdgeFor((NetworkDSL)this, (Network)$this$getEdgeFor, (String)issuer, (String)target, (String)userId);
    }

    @Nullable
    public List<Edge.Component> getEdgeFor(@NotNull Network $this$getEdgeFor, @NotNull Identifier issuer, @NotNull Identifier target) {
        return NetworkDSL.DefaultImpls.getEdgeFor((NetworkDSL)this, (Network)$this$getEdgeFor, (Identifier)issuer, (Identifier)target);
    }

    @NotNull
    public List<Edge.Component> getEdgeFor(@NotNull Network $this$getEdgeFor, @NotNull Identifier issuer, @NotNull Identifier target, @Nullable String userId) {
        return NetworkDSL.DefaultImpls.getEdgeFor((NetworkDSL)this, (Network)$this$getEdgeFor, (Identifier)issuer, (Identifier)target, (String)userId);
    }

    @Nullable
    public Edge getEdgesFor(@NotNull Network $this$getEdgesFor, @NotNull String issuer, @NotNull String target) {
        return NetworkDSL.DefaultImpls.getEdgesFor((NetworkDSL)this, (Network)$this$getEdgesFor, (String)issuer, (String)target);
    }

    @Nullable
    public Edge getEdgesFor(@NotNull Network $this$getEdgesFor, @NotNull Identifier issuer, @NotNull Identifier target) {
        return NetworkDSL.DefaultImpls.getEdgesFor((NetworkDSL)this, (Network)$this$getEdgesFor, (Identifier)issuer, (Identifier)target);
    }

    @NotNull
    public Date plusDays(@NotNull Date $this$plusDays, long days) {
        return NetworkDSL.DefaultImpls.plusDays((NetworkDSL)this, (Date)$this$plusDays, (long)days);
    }

    @NotNull
    public Date plusHours(@NotNull Date $this$plusHours, long hours) {
        return NetworkDSL.DefaultImpls.plusHours((NetworkDSL)this, (Date)$this$plusHours, (long)hours);
    }

    @NotNull
    public Date plusMillis(@NotNull Date $this$plusMillis, long millis) {
        return NetworkDSL.DefaultImpls.plusMillis((NetworkDSL)this, (Date)$this$plusMillis, (long)millis);
    }

    @NotNull
    public Date plusMinutes(@NotNull Date $this$plusMinutes, long minutes) {
        return NetworkDSL.DefaultImpls.plusMinutes((NetworkDSL)this, (Date)$this$plusMinutes, (long)minutes);
    }

    @NotNull
    public Date plusSeconds(@NotNull Date $this$plusSeconds, long seconds) {
        return NetworkDSL.DefaultImpls.plusSeconds((NetworkDSL)this, (Date)$this$plusSeconds, (long)seconds);
    }
}

