/*
 * Decompiled with CFR 0.152.
 */
package org.pgpainless.wot.network;

import java.util.Date;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.test.AssertionsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.junit.jupiter.api.Test;
import org.pgpainless.wot.dsl.NetworkDSL;
import org.pgpainless.wot.network.Edge;
import org.pgpainless.wot.network.Identifier;
import org.pgpainless.wot.network.Network;
import org.pgpainless.wot.network.Node;
import org.pgpainless.wot.network.RegexSet;
import org.pgpainless.wot.network.TrustDepth;
import org.pgpainless.wot.query.Path;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\t\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0006\u001a\u00020\u0007H\u0007J\b\u0010\b\u001a\u00020\u0007H\u0007J\b\u0010\t\u001a\u00020\u0007H\u0007J\b\u0010\n\u001a\u00020\u0007H\u0007J\b\u0010\u000b\u001a\u00020\u0007H\u0007J\b\u0010\f\u001a\u00020\u0007H\u0007J\b\u0010\r\u001a\u00020\u0007H\u0007J\b\u0010\u000e\u001a\u00020\u0007H\u0007J\b\u0010\u000f\u001a\u00020\u0007H\u0007R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082D\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lorg/pgpainless/wot/network/RegexSetTest;", "Lorg/pgpainless/wot/dsl/NetworkDSL;", "()V", "exampleComRegex", "", "pgpainlessOrgRegex", "simpleMatch", "", "simpleNonMatch", "verify that a RegexSet built from two different domain regexes only matches UIDs from either of the domains", "verify that a domain regex built with DLS properly works", "verify that a single domain regex only matches UIDs from that domain", "verify that multiple regex _toString returns comma separated values", "verify that single regex _toString() returns the regex", "verify that the wildcard RegexSet matches anything", "verify that wildcard()_toString() equals empty string", "wot-generic_test"})
@SourceDebugExtension(value={"SMAP\nRegexSetTest.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RegexSetTest.kt\norg/pgpainless/wot/network/RegexSetTest\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,91:1\n1#2:92\n*E\n"})
public final class RegexSetTest
implements NetworkDSL {
    @NotNull
    private final String exampleComRegex;
    @NotNull
    private final String pgpainlessOrgRegex;

    public RegexSetTest() {
        this.exampleComRegex = "<[^>]+[@.]example\\.com>$";
        this.pgpainlessOrgRegex = "<[^>]+[@.]pgpainless\\.org>$";
    }

    @Test
    public final void simpleMatch() {
        List stringList = CollectionsKt.listOf((Object)"<[^>]+[@.]foobank\\.com>$");
        RegexSet rs = RegexSet.Companion.fromExpressions(stringList);
        boolean bl = rs.matches("Foo Bank Employee <employee@foobank.com>");
        if (_Assertions.ENABLED && !bl) {
            String string = "Assertion failed";
            throw new AssertionError((Object)string);
        }
        bl = rs.matches("<employee@foobank.com>");
        if (_Assertions.ENABLED && !bl) {
            String string = "Assertion failed";
            throw new AssertionError((Object)string);
        }
    }

    @Test
    public final void simpleNonMatch() {
        boolean bl;
        List stringList = CollectionsKt.listOf((Object)"<[^>]+[@.]foobank\\.com>$");
        RegexSet rs = RegexSet.Companion.fromExpressions(stringList);
        boolean bl2 = bl = !rs.matches("Bar Bank Employee <employee@barbank.com>");
        if (_Assertions.ENABLED && !bl) {
            String string = "Assertion failed";
            throw new AssertionError((Object)string);
        }
        boolean bl3 = bl = !rs.matches("<employee@barbank.com>");
        if (_Assertions.ENABLED && !bl) {
            String string = "Assertion failed";
            throw new AssertionError((Object)string);
        }
    }

    @Test
    public final void verify that the wildcard RegexSet matches anything() {
        RegexSet wildcard = RegexSet.Companion.wildcard();
        String string = null;
        boolean bl = false;
        AssertionsKt.assertTrue((boolean)wildcard.matches("Alice <alice@pgpainless.org>"), string);
        string = null;
        boolean bl2 = false;
        AssertionsKt.assertTrue((boolean)wildcard.matches("Bob <bob@example.com>"), string);
        string = null;
        boolean bl3 = false;
        AssertionsKt.assertTrue((boolean)wildcard.matches(""), string);
        string = null;
        boolean bl4 = false;
        AssertionsKt.assertTrue((boolean)wildcard.matches("X \u00c6 A-12"), string);
    }

    @Test
    public final void verify that a single domain regex only matches UIDs from that domain() {
        RegexSet exampleCom = RegexSet.Companion.fromExpression(this.exampleComRegex);
        String string = null;
        boolean bl = false;
        AssertionsKt.assertTrue((boolean)exampleCom.matches("Bob <bob@example.com>"), string);
        string = null;
        boolean bl2 = false;
        AssertionsKt.assertTrue((boolean)exampleCom.matches("<admin@example.com>"), string);
        string = null;
        boolean bl3 = false;
        AssertionsKt.assertFalse((boolean)exampleCom.matches("Spoofed <bob@examp1e.com>"), string);
        string = null;
        boolean bl4 = false;
        AssertionsKt.assertFalse((boolean)exampleCom.matches("Alice <alice@pgpainless.org>"), string);
    }

    @Test
    public final void verify that a RegexSet built from two different domain regexes only matches UIDs from either of the domains() {
        Object[] objectArray = new String[]{this.exampleComRegex, this.pgpainlessOrgRegex};
        RegexSet multi = RegexSet.Companion.fromExpressions(CollectionsKt.listOf((Object[])objectArray));
        objectArray = null;
        boolean bl = false;
        AssertionsKt.assertTrue((boolean)multi.matches("Bob <bob@example.com>"), (String)objectArray);
        objectArray = null;
        boolean bl2 = false;
        AssertionsKt.assertTrue((boolean)multi.matches("Alice <alice@pgpainless.org>"), (String)objectArray);
        objectArray = null;
        boolean bl3 = false;
        AssertionsKt.assertTrue((boolean)multi.matches("<info@pgpainless.org>"), (String)objectArray);
        objectArray = null;
        boolean bl4 = false;
        AssertionsKt.assertFalse((boolean)multi.matches("Alice"), (String)objectArray);
        objectArray = null;
        boolean bl5 = false;
        AssertionsKt.assertFalse((boolean)multi.matches("<info@examp1e.com>"), (String)objectArray);
    }

    @Test
    public final void verify that a domain regex built with DLS properly works() {
        RegexSet regex = this.domainRegex("pgpainless.org");
        String string = null;
        boolean bl = false;
        AssertionsKt.assertTrue((boolean)regex.matches("Alice <alice@pgpainless.org>"), string);
        string = null;
        boolean bl2 = false;
        AssertionsKt.assertFalse((boolean)regex.matches("<alice@pgpainless\\.org>"), string);
    }

    @Test
    public final void verify that wildcard()_toString() equals empty string() {
        RegexSet regex = RegexSet.Companion.wildcard();
        AssertionsKt.assertEquals$default((Object)"", (Object)regex.toString(), null, (int)4, null);
    }

    @Test
    public final void verify that single regex _toString() returns the regex() {
        RegexSet regex = this.domainRegex("pgpainless.org");
        AssertionsKt.assertEquals$default((Object)"<[^>]+[@.]pgpainless\\.org>$", (Object)regex.toString(), null, (int)4, null);
    }

    @Test
    public final void verify that multiple regex _toString returns comma separated values() {
        Object[] objectArray = new String[]{"<[^>]+[@.]pgpainless\\.org>$", "<[^>]+[@.]example\\.com>$"};
        List list = CollectionsKt.listOf((Object[])objectArray);
        RegexSet regex = RegexSet.Companion.fromExpressions(list);
        AssertionsKt.assertEquals$default((Object)"<[^>]+[@.]pgpainless\\.org>$, <[^>]+[@.]example\\.com>$", (Object)regex.toString(), null, (int)4, null);
    }

    @NotNull
    public Edge.Certification Certification(@NotNull Node issuer, @NotNull Node target, @NotNull String userId) {
        return NetworkDSL.DefaultImpls.Certification((NetworkDSL)this, (Node)issuer, (Node)target, (String)userId);
    }

    @NotNull
    public Edge.Certification Certification(@NotNull Node issuer, @NotNull Node target, @NotNull String targetUserId, @NotNull Date creationTime) {
        return NetworkDSL.DefaultImpls.Certification((NetworkDSL)this, (Node)issuer, (Node)target, (String)targetUserId, (Date)creationTime);
    }

    @NotNull
    public Edge.Delegation Delegation(@NotNull Node issuer, @NotNull Node target) {
        return NetworkDSL.DefaultImpls.Delegation((NetworkDSL)this, (Node)issuer, (Node)target);
    }

    @NotNull
    public Edge.Delegation Delegation(@NotNull Node issuer, @NotNull Node target, @NotNull Date creationTime) {
        return NetworkDSL.DefaultImpls.Delegation((NetworkDSL)this, (Node)issuer, (Node)target, (Date)creationTime);
    }

    @NotNull
    public Edge.Delegation Delegation(@NotNull Node issuer, @NotNull Node target, int amount, int depth) {
        return NetworkDSL.DefaultImpls.Delegation((NetworkDSL)this, (Node)issuer, (Node)target, (int)amount, (int)depth);
    }

    @NotNull
    public Edge.Delegation Delegation(@NotNull Node issuer, @NotNull Node target, int amount, @NotNull TrustDepth depth) {
        return NetworkDSL.DefaultImpls.Delegation((NetworkDSL)this, (Node)issuer, (Node)target, (int)amount, (TrustDepth)depth);
    }

    @NotNull
    public Node Node(@NotNull String fingerprint) {
        return NetworkDSL.DefaultImpls.Node((NetworkDSL)this, (String)fingerprint);
    }

    @NotNull
    public Node Node(@NotNull String fingerprint, @NotNull String userId) {
        return NetworkDSL.DefaultImpls.Node((NetworkDSL)this, (String)fingerprint, (String)userId);
    }

    @NotNull
    public Node Node(@NotNull Node original, @NotNull String userId) {
        return NetworkDSL.DefaultImpls.Node((NetworkDSL)this, (Node)original, (String)userId);
    }

    @NotNull
    public Network buildNetwork(@NotNull Function1<? super Network.Builder, Unit> builderAction) {
        return NetworkDSL.DefaultImpls.buildNetwork((NetworkDSL)this, builderAction);
    }

    @NotNull
    public RegexSet domainRegex(@NotNull String domain) {
        return NetworkDSL.DefaultImpls.domainRegex((NetworkDSL)this, (String)domain);
    }

    @NotNull
    public Network.Builder addEdge(@NotNull Network.Builder $this$addEdge, @NotNull String issuer, @NotNull String target) {
        return NetworkDSL.DefaultImpls.addEdge((NetworkDSL)this, (Network.Builder)$this$addEdge, (String)issuer, (String)target);
    }

    @NotNull
    public Network.Builder addEdge(@NotNull Network.Builder $this$addEdge, @NotNull String issuer, @NotNull String target, @NotNull String userId) {
        return NetworkDSL.DefaultImpls.addEdge((NetworkDSL)this, (Network.Builder)$this$addEdge, (String)issuer, (String)target, (String)userId);
    }

    @NotNull
    public Network.Builder addNode(@NotNull Network.Builder $this$addNode, @NotNull String fingerprint) {
        return NetworkDSL.DefaultImpls.addNode((NetworkDSL)this, (Network.Builder)$this$addNode, (String)fingerprint);
    }

    @NotNull
    public Network.Builder addNode(@NotNull Network.Builder $this$addNode, @NotNull String fingerprint, @NotNull String userId) {
        return NetworkDSL.DefaultImpls.addNode((NetworkDSL)this, (Network.Builder)$this$addNode, (String)fingerprint, (String)userId);
    }

    public void addNodes(@NotNull Network.Builder $this$addNodes, String ... fingerprints) {
        NetworkDSL.DefaultImpls.addNodes((NetworkDSL)this, (Network.Builder)$this$addNodes, (String[])fingerprints);
    }

    public boolean assertNodeFingerprints(@NotNull Path $this$assertNodeFingerprints, @NotNull List<Identifier> fingerprints) {
        return NetworkDSL.DefaultImpls.assertNodeFingerprints((NetworkDSL)this, (Path)$this$assertNodeFingerprints, fingerprints);
    }

    @NotNull
    public Network.Builder buildEdge(@NotNull Network.Builder $this$buildEdge, @NotNull String issuer, @NotNull String target) {
        return NetworkDSL.DefaultImpls.buildEdge((NetworkDSL)this, (Network.Builder)$this$buildEdge, (String)issuer, (String)target);
    }

    @NotNull
    public Network.Builder buildEdge(@NotNull Network.Builder $this$buildEdge, @NotNull String issuer, @NotNull String target, int amount, int depth) {
        return NetworkDSL.DefaultImpls.buildEdge((NetworkDSL)this, (Network.Builder)$this$buildEdge, (String)issuer, (String)target, (int)amount, (int)depth);
    }

    @NotNull
    public Network.Builder buildEdge(@NotNull Network.Builder $this$buildEdge, @NotNull String issuer, @NotNull String target, int amount, int depth, @NotNull RegexSet regexSet) {
        return NetworkDSL.DefaultImpls.buildEdge((NetworkDSL)this, (Network.Builder)$this$buildEdge, (String)issuer, (String)target, (int)amount, (int)depth, (RegexSet)regexSet);
    }

    @NotNull
    public Network.Builder buildEdge(@NotNull Network.Builder $this$buildEdge, @NotNull String issuer, @NotNull String target, @NotNull String userId) {
        return NetworkDSL.DefaultImpls.buildEdge((NetworkDSL)this, (Network.Builder)$this$buildEdge, (String)issuer, (String)target, (String)userId);
    }

    @Nullable
    public List<Edge.Component> getEdgeFor(@NotNull Network $this$getEdgeFor, @NotNull String issuer, @NotNull String target) {
        return NetworkDSL.DefaultImpls.getEdgeFor((NetworkDSL)this, (Network)$this$getEdgeFor, (String)issuer, (String)target);
    }

    @Nullable
    public List<Edge.Component> getEdgeFor(@NotNull Network $this$getEdgeFor, @NotNull String issuer, @NotNull String target, @Nullable String userId) {
        return NetworkDSL.DefaultImpls.getEdgeFor((NetworkDSL)this, (Network)$this$getEdgeFor, (String)issuer, (String)target, (String)userId);
    }

    @Nullable
    public List<Edge.Component> getEdgeFor(@NotNull Network $this$getEdgeFor, @NotNull Identifier issuer, @NotNull Identifier target) {
        return NetworkDSL.DefaultImpls.getEdgeFor((NetworkDSL)this, (Network)$this$getEdgeFor, (Identifier)issuer, (Identifier)target);
    }

    @NotNull
    public List<Edge.Component> getEdgeFor(@NotNull Network $this$getEdgeFor, @NotNull Identifier issuer, @NotNull Identifier target, @Nullable String userId) {
        return NetworkDSL.DefaultImpls.getEdgeFor((NetworkDSL)this, (Network)$this$getEdgeFor, (Identifier)issuer, (Identifier)target, (String)userId);
    }

    @Nullable
    public Edge getEdgesFor(@NotNull Network $this$getEdgesFor, @NotNull String issuer, @NotNull String target) {
        return NetworkDSL.DefaultImpls.getEdgesFor((NetworkDSL)this, (Network)$this$getEdgesFor, (String)issuer, (String)target);
    }

    @Nullable
    public Edge getEdgesFor(@NotNull Network $this$getEdgesFor, @NotNull Identifier issuer, @NotNull Identifier target) {
        return NetworkDSL.DefaultImpls.getEdgesFor((NetworkDSL)this, (Network)$this$getEdgesFor, (Identifier)issuer, (Identifier)target);
    }

    @NotNull
    public Date plusDays(@NotNull Date $this$plusDays, long days) {
        return NetworkDSL.DefaultImpls.plusDays((NetworkDSL)this, (Date)$this$plusDays, (long)days);
    }

    @NotNull
    public Date plusHours(@NotNull Date $this$plusHours, long hours) {
        return NetworkDSL.DefaultImpls.plusHours((NetworkDSL)this, (Date)$this$plusHours, (long)hours);
    }

    @NotNull
    public Date plusMillis(@NotNull Date $this$plusMillis, long millis) {
        return NetworkDSL.DefaultImpls.plusMillis((NetworkDSL)this, (Date)$this$plusMillis, (long)millis);
    }

    @NotNull
    public Date plusMinutes(@NotNull Date $this$plusMinutes, long minutes) {
        return NetworkDSL.DefaultImpls.plusMinutes((NetworkDSL)this, (Date)$this$plusMinutes, (long)minutes);
    }

    @NotNull
    public Date plusSeconds(@NotNull Date $this$plusSeconds, long seconds) {
        return NetworkDSL.DefaultImpls.plusSeconds((NetworkDSL)this, (Date)$this$plusSeconds, (long)seconds);
    }
}

