/*
 * Decompiled with CFR 0.152.
 */
package org.pgpainless.wot.network;

import java.util.Date;
import kotlin.Metadata;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.test.AssertionsKt;
import org.junit.jupiter.api.Test;
import org.pgpainless.wot.network.RevocationState;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\t\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0003\u001a\u00020\u0004H\u0007J\b\u0010\u0005\u001a\u00020\u0004H\u0007J\b\u0010\u0006\u001a\u00020\u0004H\u0007J\b\u0010\u0007\u001a\u00020\u0004H\u0007J\b\u0010\b\u001a\u00020\u0004H\u0007J\b\u0010\t\u001a\u00020\u0004H\u0007J\b\u0010\n\u001a\u00020\u0004H\u0007J\b\u0010\u000b\u001a\u00020\u0004H\u0007J\b\u0010\f\u001a\u00020\u0004H\u0007\u00a8\u0006\r"}, d2={"Lorg/pgpainless/wot/network/RevocationStateTest;", "", "()V", "verify that RevocationState#notRevoked() is - well - not revoked", "", "verify that RevocationState#notRevoked() is neither a hard, nor a soft revocation", "verify that RevocationState#notRevoked() is not an effective revocation", "verify that a hard revocation is effective at any point in time", "verify that a hard revocation is neither soft nor non-revoked", "verify that a soft revocation is effective after its creation", "verify that a soft revocation is effective at its creation", "verify that a soft revocation is not effective before its creation", "verify that a soft revocation is not hard and not not-revoked", "wot-generic_test"})
@SourceDebugExtension(value={"SMAP\nRevocationStateTest.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RevocationStateTest.kt\norg/pgpainless/wot/network/RevocationStateTest\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,102:1\n1#2:103\n*E\n"})
public final class RevocationStateTest {
    @Test
    public final void verify that RevocationState#notRevoked() is - well - not revoked() {
        RevocationState notRevoked = RevocationState.Companion.notRevoked();
        String string = "Non-revocation is not revoked";
        boolean bl = false;
        AssertionsKt.assertTrue((boolean)notRevoked.isNotRevoked(), (String)string);
    }

    @Test
    public final void verify that RevocationState#notRevoked() is not an effective revocation() {
        String string = "Non-revocation MUST NOT be effective at any time";
        boolean bl = false;
        AssertionsKt.assertFalse((boolean)RevocationState.Companion.notRevoked().isEffective(new Date()), (String)string);
    }

    @Test
    public final void verify that RevocationState#notRevoked() is neither a hard, nor a soft revocation() {
        RevocationState notRevoked = RevocationState.Companion.notRevoked();
        String string = "Non-revocation MUST NOT be soft";
        boolean bl = false;
        AssertionsKt.assertFalse((boolean)notRevoked.isSoftRevocation(), (String)string);
        string = "Non-revocation MUST NOT be hard";
        boolean bl2 = false;
        AssertionsKt.assertFalse((boolean)notRevoked.isHardRevocation(), (String)string);
    }

    @Test
    public final void verify that a soft revocation is not hard and not not-revoked() {
        RevocationState softRevoked = RevocationState.Companion.softRevoked(new Date());
        String string = "Soft revocation MUST be soft";
        boolean bl = false;
        AssertionsKt.assertTrue((boolean)softRevoked.isSoftRevocation(), (String)string);
        string = "Soft revocation MUST NOT be hard";
        boolean bl2 = false;
        AssertionsKt.assertFalse((boolean)softRevoked.isHardRevocation(), (String)string);
        string = "Soft revocation MUST NOT be not-revoked";
        boolean bl3 = false;
        AssertionsKt.assertFalse((boolean)softRevoked.isNotRevoked(), (String)string);
    }

    @Test
    public final void verify that a soft revocation is effective at its creation() {
        Date creationTime = new Date();
        RevocationState softRevoked = RevocationState.Companion.softRevoked(creationTime);
        String string = "Soft revocation MUST be effective at its creation time";
        boolean bl = false;
        AssertionsKt.assertTrue((boolean)softRevoked.isEffective(creationTime), (String)string);
    }

    @Test
    public final void verify that a soft revocation is effective after its creation() {
        Date creationTime = new Date();
        RevocationState softRevoked = RevocationState.Companion.softRevoked(creationTime);
        Date after = new Date(creationTime.getTime() + (long)5000);
        String string = "Soft revocation MUST be effective after its creation time";
        boolean bl = false;
        AssertionsKt.assertTrue((boolean)softRevoked.isEffective(after), (String)string);
    }

    @Test
    public final void verify that a soft revocation is not effective before its creation() {
        Date creationTime = new Date();
        RevocationState softRevoked = RevocationState.Companion.softRevoked(creationTime);
        Date before = new Date(creationTime.getTime() - (long)5000);
        String string = "Soft revocation MUST NOT be effective before its creation time";
        boolean bl = false;
        AssertionsKt.assertFalse((boolean)softRevoked.isEffective(before), (String)string);
    }

    @Test
    public final void verify that a hard revocation is neither soft nor non-revoked() {
        RevocationState hardRevoked = RevocationState.Companion.hardRevoked();
        String string = "Hard revocation MUST be hard";
        boolean bl = false;
        AssertionsKt.assertTrue((boolean)hardRevoked.isHardRevocation(), (String)string);
        string = "Hard revocation MUST NOT be soft";
        boolean bl2 = false;
        AssertionsKt.assertFalse((boolean)hardRevoked.isSoftRevocation(), (String)string);
        string = "Hard revocation MUST NOT be not-revoked";
        boolean bl3 = false;
        AssertionsKt.assertFalse((boolean)hardRevoked.isNotRevoked(), (String)string);
    }

    @Test
    public final void verify that a hard revocation is effective at any point in time() {
        String string = "Hard revocation MUST be effective at the earliest possible date";
        boolean bl = false;
        AssertionsKt.assertTrue((boolean)RevocationState.Companion.hardRevoked().isEffective(new Date(0L)), (String)string);
        string = "Hard revocation MUST be effective 5 seconds ago";
        boolean bl2 = false;
        AssertionsKt.assertTrue((boolean)RevocationState.Companion.hardRevoked().isEffective(new Date(new Date().getTime() - (long)5000)), (String)string);
        string = "Hard revocation MUST be effective right now";
        boolean bl3 = false;
        AssertionsKt.assertTrue((boolean)RevocationState.Companion.hardRevoked().isEffective(new Date()), (String)string);
        string = "Hard revocation MUST be effective in 5 seconds time";
        boolean bl4 = false;
        AssertionsKt.assertTrue((boolean)RevocationState.Companion.hardRevoked().isEffective(new Date(new Date().getTime() + (long)5000)), (String)string);
        string = "Hard revocation MUST be effective at the farthest possible date";
        boolean bl5 = false;
        AssertionsKt.assertTrue((boolean)RevocationState.Companion.hardRevoked().isEffective(new Date(Long.MAX_VALUE)), (String)string);
    }
}

