/*
 * Decompiled with CFR 0.152.
 */
package org.pgpainless.wot.api;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.NotImplementedError;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.pgpainless.wot.api.AuthenticateAPI;
import org.pgpainless.wot.api.AuthenticationLevel;
import org.pgpainless.wot.api.Binding;
import org.pgpainless.wot.api.IdentifyAPI;
import org.pgpainless.wot.api.ListAPI;
import org.pgpainless.wot.api.LookupAPI;
import org.pgpainless.wot.api.PathAPI;
import org.pgpainless.wot.network.Identifier;
import org.pgpainless.wot.network.Network;
import org.pgpainless.wot.network.Node;
import org.pgpainless.wot.network.RevocationState;
import org.pgpainless.wot.network.TrustRoot;
import org.pgpainless.wot.query.Paths;
import org.pgpainless.wot.query.ShortestPathAlgorithm;
import org.pgpainless.wot.query.ShortestPathAlgorithmFactory;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0086\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u000f\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u00012\u00020\u00022\u00020\u00032\u00020\u00042\u00020\u0005BM\b\u0016\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t\u0012\b\b\u0002\u0010\u000b\u001a\u00020\f\u0012\b\b\u0002\u0010\r\u001a\u00020\f\u0012\b\b\u0002\u0010\u000e\u001a\u00020\u000f\u0012\b\b\u0002\u0010\u0010\u001a\u00020\u0011\u0012\u0006\u0010\u0012\u001a\u00020\u0013\u00a2\u0006\u0002\u0010\u0014BK\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t\u0012\b\b\u0002\u0010\u000b\u001a\u00020\f\u0012\b\b\u0002\u0010\r\u001a\u00020\f\u0012\b\b\u0002\u0010\u000e\u001a\u00020\u0015\u0012\b\b\u0002\u0010\u0010\u001a\u00020\u0011\u0012\u0006\u0010\u0012\u001a\u00020\u0013\u00a2\u0006\u0002\u0010\u0016J \u0010$\u001a\u00020%2\u0006\u0010&\u001a\u00020'2\u0006\u0010(\u001a\u00020)2\u0006\u0010*\u001a\u00020\fH\u0016J\u0010\u0010+\u001a\u00020,2\u0006\u0010&\u001a\u00020'H\u0016J\b\u0010-\u001a\u00020.H\u0016J\u0018\u0010/\u001a\u0002002\u0006\u0010(\u001a\u00020)2\u0006\u0010*\u001a\u00020\fH\u0016J&\u00101\u001a\u0002022\u0006\u00103\u001a\u00020'2\f\u00104\u001a\b\u0012\u0004\u0012\u00020'052\u0006\u0010(\u001a\u00020)H\u0016J\"\u00106\u001a\b\u0012\u0004\u0012\u00020)05*\u0002072\u0006\u0010(\u001a\u00020)2\u0006\u0010*\u001a\u00020\fH\u0002R\u0011\u0010\r\u001a\u00020\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018R\u0011\u0010\u000b\u001a\u00020\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u0018R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u001bR\u0011\u0010\u0010\u001a\u00020\u0011\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001c\u0010\u001dR\u0011\u0010\u0012\u001a\u00020\u0013\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001e\u0010\u001fR\u0011\u0010\u000e\u001a\u00020\u0015\u00a2\u0006\b\n\u0000\u001a\u0004\b \u0010!R\u0017\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\"\u0010#\u00a8\u00068"}, d2={"Lorg/pgpainless/wot/api/WebOfTrustAPI;", "Lorg/pgpainless/wot/api/AuthenticateAPI;", "Lorg/pgpainless/wot/api/IdentifyAPI;", "Lorg/pgpainless/wot/api/ListAPI;", "Lorg/pgpainless/wot/api/LookupAPI;", "Lorg/pgpainless/wot/api/PathAPI;", "network", "Lorg/pgpainless/wot/network/Network;", "trustRoots", "", "Lorg/pgpainless/wot/network/TrustRoot;", "gossip", "", "certificationNetwork", "trustAmount", "Lorg/pgpainless/wot/api/AuthenticationLevel;", "referenceTime", "Ljava/util/Date;", "shortestPathAlgorithmFactory", "Lorg/pgpainless/wot/query/ShortestPathAlgorithmFactory;", "(Lorg/pgpainless/wot/network/Network;Ljava/util/Set;ZZLorg/pgpainless/wot/api/AuthenticationLevel;Ljava/util/Date;Lorg/pgpainless/wot/query/ShortestPathAlgorithmFactory;)V", "", "(Lorg/pgpainless/wot/network/Network;Ljava/util/Set;ZZILjava/util/Date;Lorg/pgpainless/wot/query/ShortestPathAlgorithmFactory;)V", "getCertificationNetwork", "()Z", "getGossip", "getNetwork", "()Lorg/pgpainless/wot/network/Network;", "getReferenceTime", "()Ljava/util/Date;", "getShortestPathAlgorithmFactory", "()Lorg/pgpainless/wot/query/ShortestPathAlgorithmFactory;", "getTrustAmount", "()I", "getTrustRoots", "()Ljava/util/Set;", "authenticate", "Lorg/pgpainless/wot/api/AuthenticateAPI$Result;", "fingerprint", "Lorg/pgpainless/wot/network/Identifier;", "userId", "", "email", "identify", "Lorg/pgpainless/wot/api/IdentifyAPI$Result;", "list", "Lorg/pgpainless/wot/api/ListAPI$Result;", "lookup", "Lorg/pgpainless/wot/api/LookupAPI$Result;", "path", "Lorg/pgpainless/wot/api/PathAPI$Result;", "rootFingerprint", "pathFingerprints", "", "mapToMatchingUserIds", "Lorg/pgpainless/wot/network/Node;", "wot-generic"})
@SourceDebugExtension(value={"SMAP\nWebOfTrustAPI.kt\nKotlin\n*S Kotlin\n*F\n+ 1 WebOfTrustAPI.kt\norg/pgpainless/wot/api/WebOfTrustAPI\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,119:1\n1855#2,2:120\n1603#2,9:124\n1855#2:133\n1856#2:135\n1612#2:136\n1855#2,2:137\n215#3,2:122\n215#3,2:139\n1#4:134\n*S KotlinDebug\n*F\n+ 1 WebOfTrustAPI.kt\norg/pgpainless/wot/api/WebOfTrustAPI\n*L\n54#1:120,2\n73#1:124,9\n73#1:133\n73#1:135\n73#1:136\n83#1:137,2\n66#1:122,2\n105#1:139,2\n73#1:134\n*E\n"})
public final class WebOfTrustAPI
implements AuthenticateAPI,
IdentifyAPI,
ListAPI,
LookupAPI,
PathAPI {
    @NotNull
    private final Network network;
    @NotNull
    private final Set<TrustRoot> trustRoots;
    private final boolean gossip;
    private final boolean certificationNetwork;
    private final int trustAmount;
    @NotNull
    private final Date referenceTime;
    @NotNull
    private final ShortestPathAlgorithmFactory shortestPathAlgorithmFactory;

    public WebOfTrustAPI(@NotNull Network network, @NotNull Set<TrustRoot> trustRoots, boolean gossip, boolean certificationNetwork, int trustAmount, @NotNull Date referenceTime, @NotNull ShortestPathAlgorithmFactory shortestPathAlgorithmFactory) {
        Intrinsics.checkNotNullParameter((Object)network, (String)"network");
        Intrinsics.checkNotNullParameter(trustRoots, (String)"trustRoots");
        Intrinsics.checkNotNullParameter((Object)referenceTime, (String)"referenceTime");
        Intrinsics.checkNotNullParameter((Object)shortestPathAlgorithmFactory, (String)"shortestPathAlgorithmFactory");
        this.network = network;
        this.trustRoots = trustRoots;
        this.gossip = gossip;
        this.certificationNetwork = certificationNetwork;
        this.trustAmount = trustAmount;
        this.referenceTime = referenceTime;
        this.shortestPathAlgorithmFactory = shortestPathAlgorithmFactory;
    }

    public /* synthetic */ WebOfTrustAPI(Network network, Set set, boolean bl, boolean bl2, int n, Date date, ShortestPathAlgorithmFactory shortestPathAlgorithmFactory, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 4) != 0) {
            bl = false;
        }
        if ((n2 & 8) != 0) {
            bl2 = false;
        }
        if ((n2 & 0x10) != 0) {
            n = AuthenticationLevel.Fully.getAmount();
        }
        if ((n2 & 0x20) != 0) {
            date = new Date();
        }
        this(network, (Set<TrustRoot>)set, bl, bl2, n, date, shortestPathAlgorithmFactory);
    }

    @NotNull
    public final Network getNetwork() {
        return this.network;
    }

    @NotNull
    public final Set<TrustRoot> getTrustRoots() {
        return this.trustRoots;
    }

    public final boolean getGossip() {
        return this.gossip;
    }

    public final boolean getCertificationNetwork() {
        return this.certificationNetwork;
    }

    public final int getTrustAmount() {
        return this.trustAmount;
    }

    @NotNull
    public final Date getReferenceTime() {
        return this.referenceTime;
    }

    @NotNull
    public final ShortestPathAlgorithmFactory getShortestPathAlgorithmFactory() {
        return this.shortestPathAlgorithmFactory;
    }

    public WebOfTrustAPI(@NotNull Network network, @NotNull Set<TrustRoot> trustRoots, boolean gossip, boolean certificationNetwork, @NotNull AuthenticationLevel trustAmount, @NotNull Date referenceTime, @NotNull ShortestPathAlgorithmFactory shortestPathAlgorithmFactory) {
        Intrinsics.checkNotNullParameter((Object)network, (String)"network");
        Intrinsics.checkNotNullParameter(trustRoots, (String)"trustRoots");
        Intrinsics.checkNotNullParameter((Object)((Object)trustAmount), (String)"trustAmount");
        Intrinsics.checkNotNullParameter((Object)referenceTime, (String)"referenceTime");
        Intrinsics.checkNotNullParameter((Object)shortestPathAlgorithmFactory, (String)"shortestPathAlgorithmFactory");
        this(network, trustRoots, gossip, certificationNetwork, trustAmount.getAmount(), referenceTime, shortestPathAlgorithmFactory);
    }

    public /* synthetic */ WebOfTrustAPI(Network network, Set set, boolean bl, boolean bl2, AuthenticationLevel authenticationLevel, Date date, ShortestPathAlgorithmFactory shortestPathAlgorithmFactory, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 4) != 0) {
            bl = false;
        }
        if ((n & 8) != 0) {
            bl2 = false;
        }
        if ((n & 0x10) != 0) {
            authenticationLevel = AuthenticationLevel.Fully;
        }
        if ((n & 0x20) != 0) {
            date = new Date();
        }
        this(network, (Set<TrustRoot>)set, bl, bl2, authenticationLevel, date, shortestPathAlgorithmFactory);
    }

    @Override
    @NotNull
    public AuthenticateAPI.Result authenticate(@NotNull Identifier fingerprint, @NotNull String userId, boolean email) {
        Intrinsics.checkNotNullParameter((Object)fingerprint, (String)"fingerprint");
        Intrinsics.checkNotNullParameter((Object)userId, (String)"userId");
        ShortestPathAlgorithm query = this.shortestPathAlgorithmFactory.createInstance(this.network, this.trustRoots, this.certificationNetwork, this.referenceTime);
        Paths paths = query.search(fingerprint, userId, this.trustAmount);
        return new AuthenticateAPI.Result(new Binding(fingerprint, userId, paths), this.trustAmount);
    }

    @Override
    @NotNull
    public IdentifyAPI.Result identify(@NotNull Identifier fingerprint) {
        Intrinsics.checkNotNullParameter((Object)fingerprint, (String)"fingerprint");
        Node node = this.network.getNodes().get(fingerprint);
        if (node == null) {
            return new IdentifyAPI.Result(CollectionsKt.emptyList(), this.trustAmount);
        }
        Node cert = node;
        List bindings = new ArrayList();
        Iterable $this$forEach$iv = CollectionsKt.toList((Iterable)cert.getUserIds().keySet());
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            String it = (String)element$iv;
            boolean bl = false;
            ShortestPathAlgorithm query = this.shortestPathAlgorithmFactory.createInstance(this.network, this.trustRoots, this.certificationNetwork, this.referenceTime);
            Paths paths = query.search(fingerprint, it, this.trustAmount);
            if (paths.getAmount() == 0) continue;
            bindings.add(new Binding(fingerprint, it, paths));
        }
        return new IdentifyAPI.Result(bindings, this.trustAmount);
    }

    @Override
    @NotNull
    public ListAPI.Result list() {
        List bindings = new ArrayList();
        Map<Identifier, Node> $this$forEach$iv = this.network.getNodes();
        boolean $i$f$forEach = false;
        Iterator<Map.Entry<Identifier, Node>> iterator = $this$forEach$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<Identifier, Node> element$iv;
            Map.Entry<Identifier, Node> it = element$iv = iterator.next();
            boolean bl = false;
            bindings.addAll((Collection)this.identify(it.getKey()).getBindings());
        }
        return new ListAPI.Result(bindings, this.trustAmount);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public LookupAPI.Result lookup(@NotNull String userId, boolean email) {
        void $this$mapNotNullTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)userId, (String)"userId");
        Iterable $this$mapNotNull$iv = this.network.getNodes().values();
        boolean $i$f$mapNotNull = false;
        Iterable iterable = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv$iv$iv.iterator();
        while (iterator.hasNext()) {
            Pair it$iv$iv;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator.next();
            boolean bl = false;
            Node node = (Node)element$iv$iv;
            boolean bl2 = false;
            List<String> matches = this.mapToMatchingUserIds(node, userId, email);
            if ((matches.isEmpty() ? null : TuplesKt.to((Object)node, matches)) == null) continue;
            it$iv$iv = it$iv$iv;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        List candidates = (List)destination$iv$iv;
        List results = new ArrayList();
        Iterable $this$forEach$iv = candidates;
        boolean $i$f$forEach2 = false;
        for (Object element$iv : $this$forEach$iv) {
            Pair it = (Pair)element$iv;
            boolean bl = false;
            Node node = (Node)it.getFirst();
            List userIds = (List)it.getSecond();
            for (String mUserId : userIds) {
                AuthenticateAPI.Result result = this.authenticate(node.getFingerprint(), mUserId, email);
                boolean bl4 = false;
                if (!(!((Collection)result.getBinding().getPaths().getPaths()).isEmpty())) continue;
                results.add(result.getBinding());
            }
        }
        return new LookupAPI.Result(results, this.trustAmount);
    }

    @Override
    @NotNull
    public PathAPI.Result path(@NotNull Identifier rootFingerprint, @NotNull List<Identifier> pathFingerprints, @NotNull String userId) {
        Intrinsics.checkNotNullParameter((Object)rootFingerprint, (String)"rootFingerprint");
        Intrinsics.checkNotNullParameter(pathFingerprints, (String)"pathFingerprints");
        Intrinsics.checkNotNullParameter((Object)userId, (String)"userId");
        String string = "Not yet implemented";
        throw new NotImplementedError("An operation is not implemented: " + string);
    }

    private final List<String> mapToMatchingUserIds(Node $this$mapToMatchingUserIds, String userId, boolean email) {
        List list = new ArrayList();
        Map<String, RevocationState> $this$forEach$iv = $this$mapToMatchingUserIds.getUserIds();
        boolean $i$f$forEach = false;
        Iterator<Map.Entry<String, RevocationState>> iterator = $this$forEach$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<String, RevocationState> element$iv;
            Map.Entry<String, RevocationState> entry = element$iv = iterator.next();
            boolean bl = false;
            if (email) {
                if (!StringsKt.contains$default((CharSequence)entry.getKey(), (CharSequence)('<' + userId + '>'), (boolean)false, (int)2, null)) continue;
                list.add(entry.getKey());
                continue;
            }
            if (!Intrinsics.areEqual((Object)entry.getKey(), (Object)userId)) continue;
            list.add(entry.getKey());
        }
        return list;
    }
}

