/*
 * Decompiled with CFR 0.152.
 */
package org.pgpainless.wot.network;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.pgpainless.wot.network.Node;
import org.pgpainless.wot.network.RegexSet;
import org.pgpainless.wot.network.TrustDepth;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010 \n\u0002\b\u0007\u0018\u00002\u00020\u0001:\u0003 !\"B\u0017\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0005B\u000f\b\u0016\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bB=\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\n\u0012\u0018\u0010\f\u001a\u0014\u0012\u0004\u0012\u00020\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000f0\n0\r\u00a2\u0006\u0002\u0010\u0010J\u000e\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u0006\u001a\u00020\u0007J\u001a\u0010\u001a\u001a\u0016\u0012\u0006\u0012\u0004\u0018\u00010\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00070\u001c0\u001bJ\u000e\u0010\u001d\u001a\u00020\u00002\u0006\u0010\u001e\u001a\u00020\u0000J\b\u0010\u001f\u001a\u00020\u000eH\u0016R#\u0010\f\u001a\u0014\u0012\u0004\u0012\u00020\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000f0\n0\r\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0017\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0016\u00a8\u0006#"}, d2={"Lorg/pgpainless/wot/network/Edge;", "", "issuer", "Lorg/pgpainless/wot/network/Node;", "target", "(Lorg/pgpainless/wot/network/Node;Lorg/pgpainless/wot/network/Node;)V", "component", "Lorg/pgpainless/wot/network/Edge$Component;", "(Lorg/pgpainless/wot/network/Edge$Component;)V", "delegations", "", "Lorg/pgpainless/wot/network/Edge$Delegation;", "certifications", "", "", "Lorg/pgpainless/wot/network/Edge$Certification;", "(Lorg/pgpainless/wot/network/Node;Lorg/pgpainless/wot/network/Node;Ljava/util/Set;Ljava/util/Map;)V", "getCertifications", "()Ljava/util/Map;", "getDelegations", "()Ljava/util/Set;", "getIssuer", "()Lorg/pgpainless/wot/network/Node;", "getTarget", "addComponent", "", "components", "", "", "join", "other", "toString", "Certification", "Component", "Delegation", "wot-generic"})
@SourceDebugExtension(value={"SMAP\nEdge.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Edge.kt\norg/pgpainless/wot/network/Edge\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n+ 4 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n*L\n1#1,159:1\n1855#2,2:160\n1855#2,2:163\n1549#2:174\n1620#2,3:175\n1549#2:179\n1620#2,3:180\n1855#2,2:183\n215#3:162\n216#3:165\n215#3:173\n216#3:178\n361#4,7:166\n*S KotlinDebug\n*F\n+ 1 Edge.kt\norg/pgpainless/wot/network/Edge\n*L\n42#1:160,2\n46#1:163,2\n94#1:174\n94#1:175,3\n97#1:179\n97#1:180,3\n104#1:183,2\n45#1:162\n45#1:165\n93#1:173\n93#1:178\n59#1:166,7\n*E\n"})
public final class Edge {
    @NotNull
    private final Node issuer;
    @NotNull
    private final Node target;
    @NotNull
    private final Set<Delegation> delegations;
    @NotNull
    private final Map<String, Set<Certification>> certifications;

    public Edge(@NotNull Node issuer, @NotNull Node target, @NotNull Set<Delegation> delegations, @NotNull Map<String, Set<Certification>> certifications) {
        Intrinsics.checkNotNullParameter((Object)issuer, (String)"issuer");
        Intrinsics.checkNotNullParameter((Object)target, (String)"target");
        Intrinsics.checkNotNullParameter(delegations, (String)"delegations");
        Intrinsics.checkNotNullParameter(certifications, (String)"certifications");
        this.issuer = issuer;
        this.target = target;
        this.delegations = delegations;
        this.certifications = certifications;
    }

    @NotNull
    public final Node getIssuer() {
        return this.issuer;
    }

    @NotNull
    public final Node getTarget() {
        return this.target;
    }

    @NotNull
    public final Set<Delegation> getDelegations() {
        return this.delegations;
    }

    @NotNull
    public final Map<String, Set<Certification>> getCertifications() {
        return this.certifications;
    }

    public Edge(@NotNull Node issuer, @NotNull Node target) {
        Intrinsics.checkNotNullParameter((Object)issuer, (String)"issuer");
        Intrinsics.checkNotNullParameter((Object)target, (String)"target");
        this(issuer, target, new LinkedHashSet(), new LinkedHashMap());
    }

    /*
     * WARNING - void declaration
     */
    public Edge(@NotNull Component component) {
        Object $this$_init__u24lambda_u240;
        Intrinsics.checkNotNullParameter((Object)component, (String)"component");
        Object object = SetsKt.createSetBuilder();
        Set set = object;
        Node node = component.getTarget();
        Node node2 = component.getIssuer();
        Edge edge = this;
        boolean bl = false;
        if (component instanceof Delegation) {
            $this$_init__u24lambda_u240.add(component);
        }
        Object object2 = Unit.INSTANCE;
        Set set2 = CollectionsKt.toMutableSet((Iterable)SetsKt.build((Set)object));
        $this$_init__u24lambda_u240 = object = MapsKt.createMapBuilder();
        object2 = set2;
        boolean bl2 = false;
        if (component instanceof Certification) {
            void $this$_init__u24lambda_u241;
            Object[] objectArray = new Certification[]{component};
            $this$_init__u24lambda_u241.put(((Certification)component).getUserId(), SetsKt.mutableSetOf((Object[])objectArray));
        }
        Unit unit = Unit.INSTANCE;
        edge(node2, node, (Set<Delegation>)object2, MapsKt.toMutableMap((Map)MapsKt.build((Map)object)));
    }

    @NotNull
    public final Edge join(@NotNull Edge other) {
        Object element$iv;
        Edge edge;
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        if (!Intrinsics.areEqual((Object)this.issuer.getFingerprint(), (Object)other.issuer.getFingerprint())) {
            String string = "Failed requirement.";
            throw new IllegalArgumentException(string.toString());
        }
        if (!Intrinsics.areEqual((Object)this.target.getFingerprint(), (Object)other.target.getFingerprint())) {
            String string = "Failed requirement.";
            throw new IllegalArgumentException(string.toString());
        }
        if (other == this) {
            return this;
        }
        Edge $this$join_u24lambda_u245 = edge = this;
        boolean bl = false;
        Object $this$forEach$iv = other.delegations;
        boolean $i$f$forEach = false;
        Iterator<Object> iterator = $this$forEach$iv.iterator();
        while (iterator.hasNext()) {
            element$iv = iterator.next();
            Delegation it = (Delegation)element$iv;
            boolean bl2 = false;
            $this$join_u24lambda_u245.addComponent(it);
        }
        $this$forEach$iv = other.certifications;
        $i$f$forEach = false;
        iterator = $this$forEach$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            Object e = element$iv = (Map.Entry)iterator.next();
            boolean bl3 = false;
            Iterable $this$forEach$iv2 = (Iterable)e.getValue();
            boolean $i$f$forEach2 = false;
            for (Object element$iv2 : $this$forEach$iv2) {
                Certification it = (Certification)element$iv2;
                boolean bl4 = false;
                $this$join_u24lambda_u245.addComponent(it);
            }
        }
        return edge;
    }

    /*
     * WARNING - void declaration
     */
    public final void addComponent(@NotNull Component component) {
        Intrinsics.checkNotNullParameter((Object)component, (String)"component");
        if (!Intrinsics.areEqual((Object)this.issuer.getFingerprint(), (Object)component.getIssuer().getFingerprint())) {
            String string = "Failed requirement.";
            throw new IllegalArgumentException(string.toString());
        }
        if (!Intrinsics.areEqual((Object)this.target.getFingerprint(), (Object)component.getTarget().getFingerprint())) {
            String string = "Failed requirement.";
            throw new IllegalArgumentException(string.toString());
        }
        if (component instanceof Certification) {
            Set forUserId;
            Object object;
            void $this$getOrPut$iv;
            Map<String, Set<Certification>> map = this.certifications;
            String key$iv = ((Certification)component).getUserId();
            boolean $i$f$getOrPut = false;
            Object value$iv = $this$getOrPut$iv.get(key$iv);
            if (value$iv == null) {
                boolean bl = false;
                Set answer$iv = new LinkedHashSet();
                $this$getOrPut$iv.put(key$iv, answer$iv);
                object = answer$iv;
            } else {
                object = value$iv;
            }
            if ((forUserId = (Set)object).isEmpty()) {
                forUserId.add(component);
                return;
            }
            Certification existing = (Certification)CollectionsKt.first((Iterable)forUserId);
            if (existing.getCreationTime().compareTo(component.getCreationTime()) < 0) {
                forUserId.clear();
            }
            if (component.getCreationTime().compareTo(existing.getCreationTime()) >= 0) {
                forUserId.add(component);
            }
        } else {
            if (this.delegations.isEmpty()) {
                this.delegations.add((Delegation)component);
                return;
            }
            Delegation existing = (Delegation)CollectionsKt.first((Iterable)this.delegations);
            if (existing.getCreationTime().compareTo(component.getCreationTime()) < 0) {
                this.delegations.clear();
            }
            if (component.getCreationTime().compareTo(existing.getCreationTime()) >= 0) {
                this.delegations.add((Delegation)component);
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final Map<String, List<Component>> components() {
        Object certs;
        Map map;
        Map $this$components_u24lambda_u2410 = map = (Map)new LinkedHashMap();
        boolean bl = false;
        Object $this$forEach$iv = this.certifications;
        boolean $i$f$forEach = false;
        Iterator<Map.Entry<String, Set<Certification>>> iterator = $this$forEach$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            Collection<void> collection;
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            Map.Entry<String, Set<Certification>> element$iv;
            Map.Entry<String, Set<Certification>> entry = element$iv = iterator.next();
            boolean bl2 = false;
            String uid = entry.getKey();
            certs = entry.getValue();
            Iterable iterable = (Iterable)certs;
            String string = uid;
            Map map2 = $this$components_u24lambda_u2410;
            boolean $i$f$map = false;
            void var16_19 = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                Certification certification = (Certification)item$iv$iv;
                collection = destination$iv$iv;
                boolean bl3 = false;
                collection.add(it);
            }
            collection = (List)destination$iv$iv;
            map2.put(string, collection);
        }
        if (!((Collection)this.delegations).isEmpty()) {
            Collection<void> collection;
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            $this$forEach$iv = this.delegations;
            Object k = null;
            Map map3 = $this$components_u24lambda_u2410;
            boolean $i$f$map = false;
            iterator = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                certs = (Delegation)item$iv$iv;
                collection = destination$iv$iv;
                boolean bl4 = false;
                collection.add(it);
            }
            collection = (List)destination$iv$iv;
            map3.put(k, collection);
        }
        return map;
    }

    @NotNull
    public String toString() {
        StringBuilder stringBuilder;
        StringBuilder $this$toString_u24lambda_u2412 = stringBuilder = new StringBuilder();
        boolean bl = false;
        Iterable $this$forEach$iv = CollectionsKt.flatten((Iterable)this.components().values());
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Component it = (Component)element$iv;
            boolean bl2 = false;
            StringBuilder stringBuilder2 = $this$toString_u24lambda_u2412.append(it.toString());
            Intrinsics.checkNotNullExpressionValue((Object)stringBuilder2, (String)"append(value)");
            Intrinsics.checkNotNullExpressionValue((Object)stringBuilder2.append('\n'), (String)"append('\\n')");
        }
        String string = stringBuilder.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"StringBuilder().apply(builderAction).toString()");
        return string;
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u00002\u00020\u0001BW\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\b\u0010\t\u001a\u0004\u0018\u00010\b\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\b\u0010\f\u001a\u0004\u0018\u00010\r\u0012\b\u0010\u000e\u001a\u0004\u0018\u00010\u000f\u0012\n\b\u0002\u0010\u0010\u001a\u0004\u0018\u00010\u0011\u00a2\u0006\u0002\u0010\u0012J\b\u0010\u0015\u001a\u00020\u0006H\u0016R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014\u00a8\u0006\u0016"}, d2={"Lorg/pgpainless/wot/network/Edge$Certification;", "Lorg/pgpainless/wot/network/Edge$Component;", "issuer", "Lorg/pgpainless/wot/network/Node;", "target", "userId", "", "creationTime", "Ljava/util/Date;", "expirationTime", "exportable", "", "trustAmount", "", "trustDepth", "Lorg/pgpainless/wot/network/TrustDepth;", "regexes", "Lorg/pgpainless/wot/network/RegexSet;", "(Lorg/pgpainless/wot/network/Node;Lorg/pgpainless/wot/network/Node;Ljava/lang/String;Ljava/util/Date;Ljava/util/Date;ZLjava/lang/Integer;Lorg/pgpainless/wot/network/TrustDepth;Lorg/pgpainless/wot/network/RegexSet;)V", "getUserId", "()Ljava/lang/String;", "toString", "wot-generic"})
    public static final class Certification
    extends Component {
        @NotNull
        private final String userId;

        public Certification(@NotNull Node issuer, @NotNull Node target, @NotNull String userId, @NotNull Date creationTime, @Nullable Date expirationTime, boolean exportable, @Nullable Integer trustAmount, @Nullable TrustDepth trustDepth, @Nullable RegexSet regexes) {
            RegexSet regexSet;
            Intrinsics.checkNotNullParameter((Object)issuer, (String)"issuer");
            Intrinsics.checkNotNullParameter((Object)target, (String)"target");
            Intrinsics.checkNotNullParameter((Object)userId, (String)"userId");
            Intrinsics.checkNotNullParameter((Object)creationTime, (String)"creationTime");
            Integer n = trustAmount;
            int n2 = n != null ? n : 120;
            TrustDepth trustDepth2 = trustDepth;
            if (trustDepth2 == null) {
                trustDepth2 = TrustDepth.Companion.limited(0);
            }
            if ((regexSet = regexes) == null) {
                regexSet = RegexSet.Companion.wildcard();
            }
            super(issuer, target, creationTime, expirationTime, exportable, n2, trustDepth2, regexSet);
            this.userId = userId;
        }

        public /* synthetic */ Certification(Node node, Node node2, String string, Date date, Date date2, boolean bl, Integer n, TrustDepth trustDepth, RegexSet regexSet, int n2, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n2 & 0x100) != 0) {
                regexSet = RegexSet.Companion.wildcard();
            }
            this(node, node2, string, date, date2, bl, n, trustDepth, regexSet);
        }

        @NotNull
        public final String getUserId() {
            return this.userId;
        }

        @NotNull
        public String toString() {
            return this.getIssuer().getFingerprint() + " certifies binding: " + this.userId + " <-> " + this.getTarget().getFingerprint() + " [" + this.getTrustAmount() + ']';
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0010\b&\u0018\u00002\u00020\u0001BG\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\b\u0010\u0007\u001a\u0004\u0018\u00010\u0006\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\f\u001a\u00020\r\u0012\u0006\u0010\u000e\u001a\u00020\u000f\u00a2\u0006\u0002\u0010\u0010R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0013\u0010\u0007\u001a\u0004\u0018\u00010\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0012R\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017R\u0011\u0010\u000e\u001a\u00020\u000f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0019R\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u0017R\u0011\u0010\n\u001a\u00020\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u001cR\u0011\u0010\f\u001a\u00020\r\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001d\u0010\u001e\u00a8\u0006\u001f"}, d2={"Lorg/pgpainless/wot/network/Edge$Component;", "", "issuer", "Lorg/pgpainless/wot/network/Node;", "target", "creationTime", "Ljava/util/Date;", "expirationTime", "exportable", "", "trustAmount", "", "trustDepth", "Lorg/pgpainless/wot/network/TrustDepth;", "regexes", "Lorg/pgpainless/wot/network/RegexSet;", "(Lorg/pgpainless/wot/network/Node;Lorg/pgpainless/wot/network/Node;Ljava/util/Date;Ljava/util/Date;ZILorg/pgpainless/wot/network/TrustDepth;Lorg/pgpainless/wot/network/RegexSet;)V", "getCreationTime", "()Ljava/util/Date;", "getExpirationTime", "getExportable", "()Z", "getIssuer", "()Lorg/pgpainless/wot/network/Node;", "getRegexes", "()Lorg/pgpainless/wot/network/RegexSet;", "getTarget", "getTrustAmount", "()I", "getTrustDepth", "()Lorg/pgpainless/wot/network/TrustDepth;", "wot-generic"})
    public static abstract class Component {
        @NotNull
        private final Node issuer;
        @NotNull
        private final Node target;
        @NotNull
        private final Date creationTime;
        @Nullable
        private final Date expirationTime;
        private final boolean exportable;
        private final int trustAmount;
        @NotNull
        private final TrustDepth trustDepth;
        @NotNull
        private final RegexSet regexes;

        public Component(@NotNull Node issuer, @NotNull Node target, @NotNull Date creationTime, @Nullable Date expirationTime, boolean exportable, int trustAmount, @NotNull TrustDepth trustDepth, @NotNull RegexSet regexes) {
            Intrinsics.checkNotNullParameter((Object)issuer, (String)"issuer");
            Intrinsics.checkNotNullParameter((Object)target, (String)"target");
            Intrinsics.checkNotNullParameter((Object)creationTime, (String)"creationTime");
            Intrinsics.checkNotNullParameter((Object)trustDepth, (String)"trustDepth");
            Intrinsics.checkNotNullParameter((Object)regexes, (String)"regexes");
            this.issuer = issuer;
            this.target = target;
            this.creationTime = creationTime;
            this.expirationTime = expirationTime;
            this.exportable = exportable;
            this.trustAmount = trustAmount;
            this.trustDepth = trustDepth;
            this.regexes = regexes;
        }

        @NotNull
        public final Node getIssuer() {
            return this.issuer;
        }

        @NotNull
        public final Node getTarget() {
            return this.target;
        }

        @NotNull
        public final Date getCreationTime() {
            return this.creationTime;
        }

        @Nullable
        public final Date getExpirationTime() {
            return this.expirationTime;
        }

        public final boolean getExportable() {
            return this.exportable;
        }

        public final int getTrustAmount() {
            return this.trustAmount;
        }

        @NotNull
        public final TrustDepth getTrustDepth() {
            return this.trustDepth;
        }

        @NotNull
        public final RegexSet getRegexes() {
            return this.regexes;
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\u0018\u00002\u00020\u0001BG\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\b\u0010\u0007\u001a\u0004\u0018\u00010\u0006\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\f\u001a\u00020\r\u0012\u0006\u0010\u000e\u001a\u00020\u000f\u00a2\u0006\u0002\u0010\u0010J\b\u0010\u0011\u001a\u00020\u0012H\u0016\u00a8\u0006\u0013"}, d2={"Lorg/pgpainless/wot/network/Edge$Delegation;", "Lorg/pgpainless/wot/network/Edge$Component;", "issuer", "Lorg/pgpainless/wot/network/Node;", "target", "creationTime", "Ljava/util/Date;", "expirationTime", "exportable", "", "trustAmount", "", "trustDepth", "Lorg/pgpainless/wot/network/TrustDepth;", "regexes", "Lorg/pgpainless/wot/network/RegexSet;", "(Lorg/pgpainless/wot/network/Node;Lorg/pgpainless/wot/network/Node;Ljava/util/Date;Ljava/util/Date;ZILorg/pgpainless/wot/network/TrustDepth;Lorg/pgpainless/wot/network/RegexSet;)V", "toString", "", "wot-generic"})
    public static final class Delegation
    extends Component {
        public Delegation(@NotNull Node issuer, @NotNull Node target, @NotNull Date creationTime, @Nullable Date expirationTime, boolean exportable, int trustAmount, @NotNull TrustDepth trustDepth, @NotNull RegexSet regexes) {
            Intrinsics.checkNotNullParameter((Object)issuer, (String)"issuer");
            Intrinsics.checkNotNullParameter((Object)target, (String)"target");
            Intrinsics.checkNotNullParameter((Object)creationTime, (String)"creationTime");
            Intrinsics.checkNotNullParameter((Object)trustDepth, (String)"trustDepth");
            Intrinsics.checkNotNullParameter((Object)regexes, (String)"regexes");
            super(issuer, target, creationTime, expirationTime, exportable, trustAmount, trustDepth, regexes);
        }

        @NotNull
        public String toString() {
            return this.getIssuer().getFingerprint() + " certifies binding: null <-> " + this.getTarget().getFingerprint() + " [" + this.getTrustAmount() + ']';
        }
    }
}

