/*
 * Decompiled with CFR 0.152.
 */
package org.pgpainless.wot.network;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.MapsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.pgpainless.wot.network.Edge;
import org.pgpainless.wot.network.Identifier;
import org.pgpainless.wot.network.Node;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010 \n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\u0003\u0018\u0000 \u001c2\u00020\u0001:\u0002\u001b\u001cB\u0007\b\u0016\u00a2\u0006\u0002\u0010\u0002B9\u0012\u0012\u0010\u0003\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u0004\u0012\u001e\u0010\u0007\u001a\u001a\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00050\b\u0012\u0004\u0012\u00020\t0\u0004\u00a2\u0006\u0002\u0010\nJ\u0014\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\t0\u00152\u0006\u0010\u0016\u001a\u00020\u0005J\u0014\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\t0\u00152\u0006\u0010\u0018\u001a\u00020\u0005J\b\u0010\u0019\u001a\u00020\u001aH\u0016R)\u0010\u0007\u001a\u001a\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00050\b\u0012\u0004\u0012\u00020\t0\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u001d\u0010\u0003\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\fR\u0011\u0010\u000e\u001a\u00020\u000f8F\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u0011R\u0011\u0010\u0012\u001a\u00020\u000f8F\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\u0011\u00a8\u0006\u001d"}, d2={"Lorg/pgpainless/wot/network/Network;", "", "()V", "nodes", "", "Lorg/pgpainless/wot/network/Identifier;", "Lorg/pgpainless/wot/network/Node;", "edges", "Lkotlin/Pair;", "Lorg/pgpainless/wot/network/Edge;", "(Ljava/util/Map;Ljava/util/Map;)V", "getEdges", "()Ljava/util/Map;", "getNodes", "numberOfEdges", "", "getNumberOfEdges", "()I", "numberOfSignatures", "getNumberOfSignatures", "getIssuedBy", "", "issuer", "getIssuedFor", "target", "toString", "", "Builder", "Companion", "wot-generic"})
@SourceDebugExtension(value={"SMAP\nNetwork.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Network.kt\norg/pgpainless/wot/network/Network\n+ 2 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 3 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,87:1\n515#2:88\n500#2,6:89\n515#2:99\n500#2,6:100\n125#3:95\n152#3,3:96\n125#3:106\n152#3,3:107\n1#4:110\n*S KotlinDebug\n*F\n+ 1 Network.kt\norg/pgpainless/wot/network/Network\n*L\n25#1:88\n25#1:89,6\n34#1:99\n34#1:100,6\n25#1:95\n25#1:96,3\n34#1:106\n34#1:107,3\n*E\n"})
public final class Network {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Map<Identifier, Node> nodes;
    @NotNull
    private final Map<Pair<Identifier, Identifier>, Edge> edges;

    public Network(@NotNull Map<Identifier, Node> nodes, @NotNull Map<Pair<Identifier, Identifier>, Edge> edges) {
        Intrinsics.checkNotNullParameter(nodes, (String)"nodes");
        Intrinsics.checkNotNullParameter(edges, (String)"edges");
        this.nodes = nodes;
        this.edges = edges;
    }

    @NotNull
    public final Map<Identifier, Node> getNodes() {
        return this.nodes;
    }

    @NotNull
    public final Map<Pair<Identifier, Identifier>, Edge> getEdges() {
        return this.edges;
    }

    public Network() {
        this(MapsKt.emptyMap(), MapsKt.emptyMap());
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<Edge> getIssuedBy(@NotNull Identifier issuer) {
        void $this$mapTo$iv$iv;
        Map.Entry it;
        Map $this$filterTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)issuer, (String)"issuer");
        Map<Pair<Identifier, Identifier>, Edge> $this$filter$iv = this.edges;
        boolean $i$f$filter = false;
        Map<Pair<Identifier, Identifier>, Edge> map = $this$filter$iv;
        Object destination$iv$iv = new LinkedHashMap();
        boolean $i$f$filterTo = false;
        Iterator iterator = $this$filterTo$iv$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry element$iv$iv;
            it = element$iv$iv = iterator.next();
            boolean bl = false;
            if (!Intrinsics.areEqual((Object)((Pair)it.getKey()).getFirst(), (Object)issuer)) continue;
            destination$iv$iv.put(element$iv$iv.getKey(), element$iv$iv.getValue());
        }
        Map $this$map$iv = destination$iv$iv;
        boolean $i$f$map = false;
        $this$filterTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList($this$map$iv.size());
        boolean $i$f$mapTo = false;
        for (Map.Entry item$iv$iv : $this$mapTo$iv$iv.entrySet()) {
            it = item$iv$iv;
            Object object = destination$iv$iv;
            boolean bl = false;
            object.add((Edge)it.getValue());
        }
        return (List)destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<Edge> getIssuedFor(@NotNull Identifier target) {
        void $this$mapTo$iv$iv;
        Map.Entry it;
        Map $this$filterTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)target, (String)"target");
        Map<Pair<Identifier, Identifier>, Edge> $this$filter$iv = this.edges;
        boolean $i$f$filter = false;
        Map<Pair<Identifier, Identifier>, Edge> map = $this$filter$iv;
        Object destination$iv$iv = new LinkedHashMap();
        boolean $i$f$filterTo = false;
        Iterator iterator = $this$filterTo$iv$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry element$iv$iv;
            it = element$iv$iv = iterator.next();
            boolean bl = false;
            if (!Intrinsics.areEqual((Object)((Pair)it.getKey()).getSecond(), (Object)target)) continue;
            destination$iv$iv.put(element$iv$iv.getKey(), element$iv$iv.getValue());
        }
        Map $this$map$iv = destination$iv$iv;
        boolean $i$f$map = false;
        $this$filterTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList($this$map$iv.size());
        boolean $i$f$mapTo = false;
        for (Map.Entry item$iv$iv : $this$mapTo$iv$iv.entrySet()) {
            it = item$iv$iv;
            Object object = destination$iv$iv;
            boolean bl = false;
            object.add((Edge)it.getValue());
        }
        return (List)destination$iv$iv;
    }

    public final int getNumberOfEdges() {
        return this.edges.size();
    }

    /*
     * WARNING - void declaration
     */
    public final int getNumberOfSignatures() {
        Iterable iterable = this.edges.values();
        int n = 0;
        for (Object t : iterable) {
            void edge;
            Edge edge2 = (Edge)t;
            int n2 = n;
            boolean bl = false;
            Iterable iterable2 = edge.components().values();
            int n3 = 0;
            for (Object t2 : iterable2) {
                void it;
                List list = (List)t2;
                int n4 = n3;
                boolean bl2 = false;
                int n5 = it.size();
                n3 = n4 + n5;
            }
            int n6 = n3;
            n = n2 + n6;
        }
        return n;
    }

    @NotNull
    public String toString() {
        StringBuilder stringBuilder;
        StringBuilder $this$toString_u24lambda_u246 = stringBuilder = new StringBuilder();
        boolean bl = false;
        StringBuilder stringBuilder2 = $this$toString_u24lambda_u246.append("Network with " + this.nodes.size() + " nodes, " + this.getNumberOfEdges() + " edges:");
        Intrinsics.checkNotNullExpressionValue((Object)stringBuilder2, (String)"append(value)");
        Intrinsics.checkNotNullExpressionValue((Object)stringBuilder2.append('\n'), (String)"append('\\n')");
        for (Edge component : this.edges.values()) {
            $this$toString_u24lambda_u246.append(component);
        }
        String string = stringBuilder.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"StringBuilder().apply(builderAction).toString()");
        return string;
    }

    @JvmStatic
    @NotNull
    public static final Builder builder() {
        return Companion.builder();
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0007\b\u0000\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\f\u001a\u00020\u00002\u0006\u0010\r\u001a\u00020\u000eJ\u000e\u0010\u000f\u001a\u00020\u00002\u0006\u0010\u0010\u001a\u00020\u0006J\u0006\u0010\u0011\u001a\u00020\u0012R\u001d\u0010\u0003\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR&\u0010\t\u001a\u001a\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00050\n\u0012\u0004\u0012\u00020\u000b0\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lorg/pgpainless/wot/network/Network$Builder;", "", "()V", "nodes", "", "Lorg/pgpainless/wot/network/Identifier;", "Lorg/pgpainless/wot/network/Node;", "getNodes", "()Ljava/util/Map;", "protoEdges", "Lkotlin/Pair;", "Lorg/pgpainless/wot/network/Edge;", "addEdge", "edge", "Lorg/pgpainless/wot/network/Edge$Component;", "addNode", "node", "build", "Lorg/pgpainless/wot/network/Network;", "wot-generic"})
    @SourceDebugExtension(value={"SMAP\nNetwork.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Network.kt\norg/pgpainless/wot/network/Network$Builder\n+ 2 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n*L\n1#1,87:1\n361#2,7:88\n*S KotlinDebug\n*F\n+ 1 Network.kt\norg/pgpainless/wot/network/Network$Builder\n*L\n77#1:88,7\n*E\n"})
    public static final class Builder {
        @NotNull
        private final Map<Identifier, Node> nodes = new LinkedHashMap();
        @NotNull
        private final Map<Pair<Identifier, Identifier>, Edge> protoEdges = new LinkedHashMap();

        @NotNull
        public final Map<Identifier, Node> getNodes() {
            return this.nodes;
        }

        @NotNull
        public final Builder addNode(@NotNull Node node) {
            Intrinsics.checkNotNullParameter((Object)node, (String)"node");
            this.nodes.put(node.getFingerprint(), node);
            return this;
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        public final Builder addEdge(@NotNull Edge.Component edge) {
            Object object;
            void $this$getOrPut$iv;
            Intrinsics.checkNotNullParameter((Object)edge, (String)"edge");
            Map<Pair<Identifier, Identifier>, Edge> map = this.protoEdges;
            Pair key$iv = new Pair((Object)edge.getIssuer().getFingerprint(), (Object)edge.getTarget().getFingerprint());
            boolean $i$f$getOrPut = false;
            Object value$iv = $this$getOrPut$iv.get(key$iv);
            if (value$iv == null) {
                boolean bl = false;
                Edge answer$iv = new Edge(edge.getIssuer(), edge.getTarget());
                $this$getOrPut$iv.put(key$iv, answer$iv);
                object = answer$iv;
            } else {
                object = value$iv;
            }
            ((Edge)object).addComponent(edge);
            return this;
        }

        @NotNull
        public final Network build() {
            return new Network(this.nodes, this.protoEdges);
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0003\u001a\u00020\u0004H\u0007\u00a8\u0006\u0005"}, d2={"Lorg/pgpainless/wot/network/Network$Companion;", "", "()V", "builder", "Lorg/pgpainless/wot/network/Network$Builder;", "wot-generic"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @NotNull
        public final Builder builder() {
            return new Builder();
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

