/*
 * Decompiled with CFR 0.152.
 */
package org.pgpainless.wot.query;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.pgpainless.wot.network.Edge;
import org.pgpainless.wot.network.Node;
import org.pgpainless.wot.network.TrustDepth;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\b\u000f\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0000\u0018\u00002\u00020\u0001B\u000f\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004B#\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ\u000e\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020\u0007J\u0016\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020\u00072\u0006\u0010\"\u001a\u00020#J\b\u0010$\u001a\u00020%H\u0016R\u0011\u0010\u000b\u001a\u00020\f8F\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000eR\u0017\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00030\u00108F\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u0012R\u0017\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00070\u00108F\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0012R\u0014\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0015\u001a\u00020\f8F\u00a2\u0006\u0006\u001a\u0004\b\u0016\u0010\u000eR\u001a\u0010\b\u001a\u00020\tX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0017\u0010\u0018\"\u0004\b\u0019\u0010\u001aR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u001cR\u0011\u0010\u001d\u001a\u00020\u00038F\u00a2\u0006\u0006\u001a\u0004\b\u001e\u0010\u001c\u00a8\u0006&"}, d2={"Lorg/pgpainless/wot/query/Path;", "", "root", "Lorg/pgpainless/wot/network/Node;", "(Lorg/pgpainless/wot/network/Node;)V", "edges", "", "Lorg/pgpainless/wot/network/Edge$Component;", "residualDepth", "Lorg/pgpainless/wot/network/TrustDepth;", "(Lorg/pgpainless/wot/network/Node;Ljava/util/List;Lorg/pgpainless/wot/network/TrustDepth;)V", "amount", "", "getAmount", "()I", "certificates", "", "getCertificates", "()Ljava/util/List;", "certifications", "getCertifications", "length", "getLength", "getResidualDepth", "()Lorg/pgpainless/wot/network/TrustDepth;", "setResidualDepth", "(Lorg/pgpainless/wot/network/TrustDepth;)V", "getRoot", "()Lorg/pgpainless/wot/network/Node;", "target", "getTarget", "append", "", "nComponent", "certificationNetwork", "", "toString", "", "wot-generic"})
@SourceDebugExtension(value={"SMAP\nPath.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Path.kt\norg/pgpainless/wot/query/Path\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,146:1\n1#2:147\n1549#3:148\n1620#3,3:149\n*S KotlinDebug\n*F\n+ 1 Path.kt\norg/pgpainless/wot/query/Path\n*L\n144#1:148\n144#1:149,3\n*E\n"})
public final class Path {
    @NotNull
    private final Node root;
    @NotNull
    private final List<Edge.Component> edges;
    @NotNull
    private TrustDepth residualDepth;

    public Path(@NotNull Node root, @NotNull List<Edge.Component> edges, @NotNull TrustDepth residualDepth) {
        Intrinsics.checkNotNullParameter((Object)root, (String)"root");
        Intrinsics.checkNotNullParameter(edges, (String)"edges");
        Intrinsics.checkNotNullParameter((Object)residualDepth, (String)"residualDepth");
        this.root = root;
        this.edges = edges;
        this.residualDepth = residualDepth;
    }

    @NotNull
    public final Node getRoot() {
        return this.root;
    }

    @NotNull
    public final TrustDepth getResidualDepth() {
        return this.residualDepth;
    }

    public final void setResidualDepth(@NotNull TrustDepth trustDepth) {
        Intrinsics.checkNotNullParameter((Object)trustDepth, (String)"<set-?>");
        this.residualDepth = trustDepth;
    }

    public Path(@NotNull Node root) {
        Intrinsics.checkNotNullParameter((Object)root, (String)"root");
        this(root, new ArrayList(), TrustDepth.Companion.unlimited());
    }

    @NotNull
    public final Node getTarget() {
        return this.edges.isEmpty() ? this.root : ((Edge.Component)CollectionsKt.last(this.edges)).getTarget();
    }

    @NotNull
    public final List<Node> getCertificates() {
        Node[] nodeArray = new Node[]{this.root};
        List certs = CollectionsKt.mutableListOf((Object[])nodeArray);
        for (Edge.Component certification : this.edges) {
            certs.add(certification.getTarget());
        }
        return certs;
    }

    public final int getLength() {
        return this.edges.size() + 1;
    }

    @NotNull
    public final List<Edge.Component> getCertifications() {
        return CollectionsKt.toList((Iterable)this.edges);
    }

    /*
     * WARNING - void declaration
     */
    public final int getAmount() {
        int n;
        if (this.edges.isEmpty()) {
            n = 120;
        } else {
            void var1_1;
            int min = 255;
            for (Edge.Component edge : this.edges) {
                min = Math.min(min, edge.getTrustAmount());
            }
            n = var1_1;
        }
        return n;
    }

    public final void append(@NotNull Edge.Component nComponent) {
        Intrinsics.checkNotNullParameter((Object)nComponent, (String)"nComponent");
        this.append(nComponent, false);
    }

    public final void append(@NotNull Edge.Component nComponent, boolean certificationNetwork) {
        Intrinsics.checkNotNullParameter((Object)nComponent, (String)"nComponent");
        if (!Intrinsics.areEqual((Object)this.getTarget().getFingerprint(), (Object)nComponent.getIssuer().getFingerprint())) {
            boolean $i$a$-require-Path$append$42 = false;
            String $i$a$-require-Path$append$42 = "Cannot append edge to path: Path's tail is not issuer of the edge.";
            throw new IllegalArgumentException($i$a$-require-Path$append$42.toString());
        }
        if (!(certificationNetwork || this.residualDepth.compareTo(0) > 0)) {
            boolean bl = false;
            String string = "Not enough depth.";
            throw new IllegalArgumentException(string.toString());
        }
        boolean cyclic = false;
        if (this.edges.size() > 0 && Intrinsics.areEqual((Object)this.root.getFingerprint(), (Object)nComponent.getTarget().getFingerprint())) {
            cyclic = true;
        }
        if (this.edges.size() == 0 && Intrinsics.areEqual((Object)this.root.getFingerprint(), (Object)nComponent.getTarget().getFingerprint()) && nComponent instanceof Edge.Delegation) {
            cyclic = true;
        }
        Iterator<Edge.Component> iterator = this.edges.iterator();
        int n = 0;
        while (iterator.hasNext()) {
            int i = n++;
            Edge.Component component = iterator.next();
            if (cyclic) break;
            if (!Intrinsics.areEqual((Object)nComponent.getTarget().getFingerprint(), (Object)component.getTarget().getFingerprint())) continue;
            cyclic = CollectionsKt.getLastIndex(this.edges) != i ? true : nComponent instanceof Edge.Certification && component instanceof Edge.Certification && Intrinsics.areEqual((Object)((Edge.Certification)nComponent).getUserId(), (Object)((Edge.Certification)component).getUserId());
        }
        if (!(!cyclic)) {
            boolean bl = false;
            String string = "Adding the edge to the path would create a cycle.";
            throw new IllegalArgumentException(string.toString());
        }
        if (!certificationNetwork) {
            this.residualDepth = nComponent.getTrustDepth().min(this.residualDepth.reduce(1));
        }
        this.edges.add(nComponent);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public String toString() {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Iterable iterable = this.edges;
        StringBuilder stringBuilder = new StringBuilder().append('{').append(this.root.getFingerprint()).append("} => {");
        boolean $i$f$map = false;
        void var3_4 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            Edge.Component component = (Edge.Component)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it.getTarget());
        }
        return stringBuilder.append(CollectionsKt.joinToString$default((Iterable)((List)destination$iv$iv), (CharSequence)" -> ", null, null, (int)0, null, null, (int)62, null)).append("} (residual {").append(this.residualDepth).append("})").toString();
    }
}

