/*
 * Decompiled with CFR 0.152.
 */
package org.pharmgkb.common.io.google;

import com.google.api.client.googleapis.auth.oauth2.GoogleCredential;
import com.google.api.client.googleapis.javanet.GoogleNetHttpTransport;
import com.google.api.client.http.HttpTransport;
import com.google.api.client.json.JsonFactory;
import com.google.api.client.json.gson.GsonFactory;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import java.io.IOException;
import java.lang.invoke.MethodHandles;
import java.security.GeneralSecurityException;
import java.security.KeyFactory;
import java.security.PrivateKey;
import java.security.spec.PKCS8EncodedKeySpec;
import java.util.Collection;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Nonnull;
import javax.xml.bind.DatatypeConverter;
import org.slf4j.LoggerFactory;

public class GoogleApiHelper
implements AutoCloseable {
    private static final Pattern sf_privateKeyPattern = Pattern.compile("-----BEGIN .*?PRIVATE KEY-----(.*)-----END .*?PRIVATE KEY-----");
    private HttpTransport m_httpTransport;
    private JsonFactory m_jsonFactory;
    private GoogleCredential m_credential;

    public GoogleApiHelper(@Nonnull String userId, @Nonnull String privateKey, String ... scopes) throws IOException, GeneralSecurityException {
        Preconditions.checkNotNull((Object)userId);
        Preconditions.checkNotNull((Object)privateKey);
        this.m_jsonFactory = GsonFactory.getDefaultInstance();
        this.m_httpTransport = GoogleNetHttpTransport.newTrustedTransport();
        this.m_credential = new GoogleCredential.Builder().setTransport(this.m_httpTransport).setJsonFactory(this.m_jsonFactory).setServiceAccountId(userId).setServiceAccountPrivateKey(GoogleApiHelper.getPrivateKey(privateKey)).setServiceAccountScopes((Collection)Lists.newArrayList((Object[])scopes)).build();
    }

    @Override
    public void close() {
        try {
            this.m_httpTransport.shutdown();
        }
        catch (IOException ex) {
            LoggerFactory.getLogger(MethodHandles.lookup().lookupClass()).error("Problem shutting down", (Throwable)ex);
        }
    }

    public JsonFactory getJsonFactory() {
        return this.m_jsonFactory;
    }

    public HttpTransport getHttpTransport() {
        return this.m_httpTransport;
    }

    public GoogleCredential getCredential() {
        return this.m_credential;
    }

    private static PrivateKey getPrivateKey(String key) throws GeneralSecurityException {
        key = GoogleApiHelper.stripKey(key);
        PKCS8EncodedKeySpec keySpec = new PKCS8EncodedKeySpec(DatatypeConverter.parseBase64Binary((String)key));
        KeyFactory keyFactory = KeyFactory.getInstance("RSA");
        return keyFactory.generatePrivate(keySpec);
    }

    static String stripKey(String key) {
        Matcher m = sf_privateKeyPattern.matcher(key = key.replaceAll("\\r|\\n", ""));
        if (m.find()) {
            return m.group(1);
        }
        return key;
    }
}

