/*
 * Decompiled with CFR 0.152.
 */
package org.pharmgkb.common.io.google;

import com.google.api.client.auth.oauth2.Credential;
import com.google.gdata.client.spreadsheet.SpreadsheetService;
import com.google.gdata.data.spreadsheet.CellEntry;
import com.google.gdata.data.spreadsheet.CellFeed;
import com.google.gdata.data.spreadsheet.SpreadsheetEntry;
import com.google.gdata.data.spreadsheet.SpreadsheetFeed;
import com.google.gdata.data.spreadsheet.WorksheetEntry;
import com.google.gdata.util.ServiceException;
import com.google.gdata.util.common.base.Joiner;
import java.io.IOException;
import java.io.PrintWriter;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.security.GeneralSecurityException;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Nonnull;
import org.pharmgkb.common.io.google.GoogleApiHelper;

public class GoogleSheetsHelper
implements AutoCloseable {
    public static final String SHEETS_SCOPE = "https://spreadsheets.google.com/feeds";
    private static final Pattern sf_rcPattern = Pattern.compile(".*/R(\\d+)C(\\d+)$");
    private final URL m_spreadsheetUrl = new URL("https://spreadsheets.google.com/feeds/spreadsheets/private/full");
    private boolean m_isPersonalApiHelper;
    private GoogleApiHelper m_googleApiHelper;
    private SpreadsheetService m_sheetsService;

    public GoogleSheetsHelper(@Nonnull String userId, @Nonnull String privateKey, @Nonnull String service) throws IOException, GeneralSecurityException {
        this.m_googleApiHelper = new GoogleApiHelper(userId, privateKey, SHEETS_SCOPE);
        this.m_isPersonalApiHelper = true;
        this.m_sheetsService = new SpreadsheetService(service);
        this.m_sheetsService.setOAuth2Credentials((Credential)this.m_googleApiHelper.getCredential());
    }

    public GoogleSheetsHelper(@Nonnull GoogleApiHelper apiHelper, @Nonnull String service) throws IOException, GeneralSecurityException {
        this.m_googleApiHelper = apiHelper;
        this.m_sheetsService = new SpreadsheetService(service);
        this.m_sheetsService.setOAuth2Credentials((Credential)this.m_googleApiHelper.getCredential());
    }

    @Override
    public void close() {
        if (this.m_isPersonalApiHelper) {
            this.m_googleApiHelper.close();
        }
    }

    public SpreadsheetService getService() {
        return this.m_sheetsService;
    }

    public List<SpreadsheetEntry> getSheets() throws IOException, ServiceException {
        return ((SpreadsheetFeed)this.m_sheetsService.getFeed(this.m_spreadsheetUrl, SpreadsheetFeed.class)).getEntries();
    }

    public void exportToTsv(String fileId, Path tsvFile) throws IOException, ServiceException {
        this.exportToTsv(new URL("https://spreadsheets.google.com/feeds/spreadsheets/" + fileId), tsvFile);
    }

    public void exportToTsv(URL url, Path tsvFile) throws IOException, ServiceException {
        SpreadsheetEntry spreadsheet = (SpreadsheetEntry)this.m_sheetsService.getEntry(url, SpreadsheetEntry.class);
        this.exportToTsv(spreadsheet.getDefaultWorksheet(), tsvFile);
    }

    public void exportToTsv(String fileId, Path tsvFile, int sheetNumber) throws IOException, ServiceException {
        this.exportToTsv(new URL("https://spreadsheets.google.com/feeds/spreadsheets/" + fileId), tsvFile, sheetNumber);
    }

    public void exportToTsv(URL url, Path tsvFile, int sheetNumber) throws IOException, ServiceException {
        SpreadsheetEntry spreadsheet = (SpreadsheetEntry)this.m_sheetsService.getEntry(url, SpreadsheetEntry.class);
        List sheets = spreadsheet.getWorksheets();
        if (sheetNumber >= sheets.size()) {
            throw new IOException("No sheet " + sheetNumber + ", only has " + sheets.size() + " sheets");
        }
        this.exportToTsv((WorksheetEntry)sheets.get(sheetNumber), tsvFile);
    }

    public void exportToTsv(String fileId, Path tsvFile, String sheetName) throws IOException, ServiceException {
        this.exportToTsv(new URL("https://spreadsheets.google.com/feeds/spreadsheets/" + fileId), tsvFile, sheetName);
    }

    public void exportToTsv(URL url, Path tsvFile, String sheetName) throws IOException, ServiceException {
        SpreadsheetEntry spreadsheet = (SpreadsheetEntry)this.m_sheetsService.getEntry(url, SpreadsheetEntry.class);
        List sheets = spreadsheet.getWorksheets();
        for (WorksheetEntry sheet : sheets) {
            if (!sheet.getTitle().getPlainText().equals(sheetName)) continue;
            this.exportToTsv(sheet, tsvFile);
            break;
        }
    }

    private void exportToTsv(@Nonnull WorksheetEntry worksheet, @Nonnull Path tsvFile) throws IOException, ServiceException {
        int colCount = worksheet.getColCount();
        Joiner tsvJoiner = Joiner.on((String)"\t").useForNull("");
        URL cellFeedUrl = worksheet.getCellFeedUrl();
        CellFeed cellFeed = (CellFeed)this.m_sheetsService.getFeed(cellFeedUrl, CellFeed.class);
        try (PrintWriter writer = new PrintWriter(Files.newBufferedWriter(tsvFile, new OpenOption[0]));){
            int curRow = 1;
            int curCol = 1;
            Object[] currentLine = new String[colCount];
            for (CellEntry cell : cellFeed.getEntries()) {
                Matcher m = sf_rcPattern.matcher(cell.getId());
                if (!m.matches()) {
                    throw new IOException("Unexpected cell id (" + cell.getId() + ").  Cannot determine row/column.");
                }
                int row = Integer.parseInt(m.group(1));
                int col = Integer.parseInt(m.group(2));
                while (curRow < row) {
                    writer.write(tsvJoiner.join(currentLine));
                    writer.println();
                    currentLine = new String[colCount];
                    ++curRow;
                    curCol = 1;
                }
                while (curCol < col) {
                    ++curCol;
                }
                currentLine[col - 1] = cell.getCell().getValue();
            }
            writer.write(tsvJoiner.join(currentLine));
            writer.println();
        }
    }
}

