/*
 * Decompiled with CFR 0.152.
 */
package org.pharmgkb.common.io.util;

import com.google.common.collect.Lists;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.Collections;
import java.util.List;
import java.util.function.Function;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.DefaultParser;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.commons.lang3.StringUtils;
import org.checkerframework.checker.nullness.qual.Nullable;

public class CliHelper {
    private static final String sf_verboseFlag = "verbose";
    private static final String sf_helpFlag = "help";
    private String m_name;
    private Options m_helpOptions = new Options();
    private Options m_options = new Options();
    private CommandLine m_commandLine;
    private String m_error;

    public CliHelper(Class cls) {
        this.m_name = cls.getSimpleName();
        Option opt = new Option("h", sf_helpFlag, false, "print this message");
        this.m_helpOptions.addOption(opt);
        this.m_options.addOption(opt);
        opt = new Option("v", sf_verboseFlag, false, "enable verbose output");
        this.m_helpOptions.addOption(opt);
        this.m_options.addOption(opt);
    }

    public CliHelper addOption(Option option) {
        if (option.getArgName().equals("h") || option.getArgName().equals("v")) {
            throw new IllegalArgumentException("-h and -v are reserved arguments");
        }
        if (option.isRequired()) {
            this.m_helpOptions.addOption(new Option(option.getOpt(), option.getLongOpt(), option.hasArg(), option.getDescription()));
        } else {
            this.m_helpOptions.addOption(option);
        }
        this.m_options.addOption(option);
        return this;
    }

    public CliHelper addOption(String shortName, String longName, String description) {
        if (shortName.equals("h") || shortName.equals("v")) {
            throw new IllegalArgumentException("-h and -v are reserved arguments");
        }
        Option opt = Option.builder((String)shortName).longOpt(longName).desc(description).hasArg(false).build();
        this.m_helpOptions.addOption(opt);
        this.m_options.addOption(opt);
        return this;
    }

    public CliHelper addOption(String shortName, String longName, String description, boolean isOptionRequired, String argName) {
        return this.addOption(shortName, longName, description, isOptionRequired, argName, 1, true);
    }

    public CliHelper addOption(String shortName, String longName, String description, boolean isOptionRequired, String argName, int numArgs, boolean argsAreRequired) {
        if (shortName.equals("h") || shortName.equals("v")) {
            throw new IllegalArgumentException("-h and -v are reserved arguments");
        }
        this.m_helpOptions.addOption(this.buildOption(shortName, longName, description, false, argName, numArgs, argsAreRequired));
        this.m_options.addOption(this.buildOption(shortName, longName, description, isOptionRequired, argName, numArgs, argsAreRequired));
        return this;
    }

    private Option buildOption(String shortName, String longName, String description, boolean isOptionRequired, String argName, int numArgs, boolean argsAreRequired) {
        Option.Builder optBuilder = Option.builder((String)shortName).longOpt(longName).desc(description).argName(argName).numberOfArgs(numArgs);
        if (argsAreRequired) {
            optBuilder.hasArg();
        } else {
            optBuilder.optionalArg(true);
        }
        if (isOptionRequired) {
            optBuilder.required();
        }
        return optBuilder.build();
    }

    public boolean parse(String[] args) {
        try {
            DefaultParser parser = new DefaultParser();
            this.m_commandLine = parser.parse(this.m_helpOptions, args);
            if (this.isHelpRequested()) {
                this.printHelp();
                return false;
            }
            parser = new DefaultParser();
            this.m_commandLine = parser.parse(this.m_options, args);
            return true;
        }
        catch (ParseException ex) {
            this.m_error = ex.getMessage();
            System.err.println(this.m_error);
            System.err.println();
            this.printHelp();
            return false;
        }
    }

    public void execute(String[] args, Function<CliHelper, Integer> function) {
        if (!this.parse(args)) {
            if (this.isHelpRequested()) {
                System.exit(0);
            }
            System.exit(1);
        }
        System.exit(function.apply(this));
    }

    public boolean hasOption(String opt) {
        return this.m_commandLine.hasOption(opt);
    }

    public @Nullable String getValue(String opt) {
        return StringUtils.stripToNull((String)this.m_commandLine.getOptionValue(opt));
    }

    public List<String> getValues(String opt) {
        Object[] vals = this.m_commandLine.getOptionValues(opt);
        if (vals == null) {
            return Collections.emptyList();
        }
        return Lists.newArrayList((Object[])vals);
    }

    public int getIntValue(String opt) {
        return Integer.parseInt(this.m_commandLine.getOptionValue(opt));
    }

    public Path getValidDirectory(String opt, boolean createIfNotExist) throws IOException {
        String val = this.getValue(opt);
        if (val == null) {
            throw new IllegalArgumentException("Missing option '" + opt + "'");
        }
        Path dir = Paths.get(val, new String[0]);
        if (Files.exists(dir, new LinkOption[0])) {
            if (Files.isDirectory(dir, new LinkOption[0])) {
                return dir;
            }
            throw new IOException("Not a valid directory: " + dir);
        }
        if (createIfNotExist) {
            Files.createDirectories(dir, new FileAttribute[0]);
            return dir;
        }
        throw new IllegalArgumentException("No such directory: " + dir);
    }

    public Path getPath(String opt) {
        String val = this.getValue(opt);
        if (val == null) {
            throw new IllegalArgumentException("Missing option '" + opt + "'");
        }
        return Paths.get(val, new String[0]);
    }

    public Path getValidFile(String opt, boolean mustExist) {
        Path p = this.getPath(opt);
        if (!Files.exists(p, new LinkOption[0])) {
            if (mustExist) {
                throw new IllegalArgumentException("File '" + p.toString() + "' does not exist");
            }
        } else if (!Files.isRegularFile(p, new LinkOption[0])) {
            throw new IllegalArgumentException("Not a file: '" + p.toString());
        }
        return p;
    }

    public List getArguments() {
        return this.m_commandLine.getArgList();
    }

    public boolean isVerbose() {
        return this.m_commandLine.hasOption(sf_verboseFlag);
    }

    public boolean hasError() {
        return this.m_error != null;
    }

    public @Nullable String getError() {
        return this.m_error;
    }

    public boolean isHelpRequested() {
        return this.m_commandLine != null && this.m_commandLine.hasOption(sf_helpFlag);
    }

    public void printHelp() {
        HelpFormatter formatter = new HelpFormatter();
        formatter.printHelp(this.m_name, this.m_options);
    }
}

