/*
 * Decompiled with CFR 0.152.
 */
package org.pharmgkb.common.io.util;

import com.google.common.io.Closeables;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Path;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.apache.commons.lang3.StringUtils;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.pharmgkb.common.io.util.StreamUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StaxReader
implements Closeable,
AutoCloseable {
    private static final Logger sf_logger = LoggerFactory.getLogger(StaxReader.class);
    private InputStream m_inputStream;
    private XMLStreamReader m_xmlReader;

    public StaxReader(File file) throws IOException {
        this(file.toPath());
    }

    public StaxReader(Path file) throws IOException {
        try {
            this.m_inputStream = StreamUtils.openInputStream(file);
            this.m_xmlReader = XMLInputFactory.newInstance().createXMLStreamReader(this.m_inputStream);
        }
        catch (XMLStreamException ex) {
            throw new IOException("Error reading " + file, ex);
        }
    }

    @Override
    public void close() {
        if (this.m_xmlReader != null) {
            try {
                this.m_xmlReader.close();
            }
            catch (Exception ex) {
                sf_logger.warn("Error closing XML reader", (Throwable)ex);
            }
        }
        Closeables.closeQuietly((InputStream)this.m_inputStream);
    }

    public boolean hasNext() throws XMLStreamException {
        return this.m_xmlReader.hasNext();
    }

    public int next() throws XMLStreamException {
        return this.m_xmlReader.next();
    }

    public @Nullable String getAttributeValue(String attName) {
        for (int x = 0; x < this.m_xmlReader.getAttributeCount(); ++x) {
            if (!this.m_xmlReader.getAttributeLocalName(x).equalsIgnoreCase(attName)) continue;
            return StringUtils.stripToNull((String)this.m_xmlReader.getAttributeValue(x));
        }
        return null;
    }

    public String getLocalName() {
        return this.m_xmlReader.getLocalName();
    }

    public @Nullable String getTextTrimmedToNull() throws XMLStreamException {
        while (this.m_xmlReader.hasNext()) {
            switch (this.m_xmlReader.next()) {
                case 4: {
                    return StringUtils.trimToNull((String)this.m_xmlReader.getText());
                }
                case 2: {
                    return null;
                }
            }
        }
        return null;
    }

    public @Nullable StaxReader startElement(String name) throws XMLStreamException {
        return this.startElement(name, null);
    }

    public @Nullable StaxReader startElement(String name, @Nullable String parentName) throws XMLStreamException {
        while (this.m_xmlReader.hasNext()) {
            int code = this.m_xmlReader.next();
            switch (code) {
                case 1: {
                    if (!name.equals(this.m_xmlReader.getLocalName())) break;
                    return this;
                }
                case 2: {
                    if (parentName == null || !parentName.equals(this.m_xmlReader.getLocalName())) break;
                    return null;
                }
            }
        }
        return null;
    }

    public @Nullable StaxReader startElementUnless(String name, @Nullable String parentName, String ... untilStartNames) throws XMLStreamException {
        block4: while (this.m_xmlReader.hasNext()) {
            int code = this.m_xmlReader.next();
            switch (code) {
                case 1: {
                    String localName = this.m_xmlReader.getLocalName();
                    if (name.equals(localName)) {
                        return this;
                    }
                    for (String n : untilStartNames) {
                        if (!n.equals(localName)) continue;
                        return null;
                    }
                    continue block4;
                }
                case 2: {
                    if (parentName == null || !parentName.equals(this.m_xmlReader.getLocalName())) break;
                    return null;
                }
            }
        }
        return null;
    }

    public @Nullable StaxReader endElement(String name) throws XMLStreamException {
        while (this.m_xmlReader.hasNext()) {
            if (this.m_xmlReader.next() != 2 || !name.equals(this.m_xmlReader.getLocalName())) continue;
            return this;
        }
        return null;
    }
}

