/*
 * Decompiled with CFR 0.152.
 */
package org.pharmgkb.common.io.util;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;

public class ZippedFileInputStream
extends InputStream {
    private ZipInputStream m_zipInputStream;

    public ZippedFileInputStream(Path zipFile) throws IOException {
        String zipFilename = zipFile.getName(zipFile.getNameCount() - 1).toString();
        if (!zipFilename.toLowerCase().endsWith(".zip")) {
            throw new IllegalArgumentException("File does not end with .zip");
        }
        String baseFilename = zipFilename.substring(0, zipFilename.length() - 4);
        this.findFile(Files.newInputStream(zipFile, new OpenOption[0]), baseFilename);
    }

    public ZippedFileInputStream(Path zipFile, String filename) throws IOException {
        String zipFilename = zipFile.getName(zipFile.getNameCount() - 1).toString();
        if (!zipFilename.toLowerCase().endsWith(".zip")) {
            throw new IllegalArgumentException("File does not end with .zip");
        }
        this.findFile(Files.newInputStream(zipFile, new OpenOption[0]), filename);
    }

    public ZippedFileInputStream(InputStream in, String filename) throws IOException {
        this.findFile(in, filename);
    }

    private void findFile(InputStream in, String filename) throws IOException {
        ZipEntry entry;
        this.m_zipInputStream = in instanceof ZipInputStream ? (ZipInputStream)in : new ZipInputStream(in);
        boolean foundFile = false;
        while ((entry = this.m_zipInputStream.getNextEntry()) != null) {
            if (!entry.getName().equals(filename)) continue;
            foundFile = true;
            break;
        }
        if (!foundFile) {
            throw new FileNotFoundException("Cannot find " + filename + " in zipped file");
        }
    }

    @Override
    public int available() throws IOException {
        return this.m_zipInputStream.available();
    }

    @Override
    public void close() throws IOException {
        this.m_zipInputStream.close();
    }

    @Override
    public synchronized void mark(int readlimit) {
        this.m_zipInputStream.mark(readlimit);
    }

    @Override
    public boolean markSupported() {
        return this.m_zipInputStream.markSupported();
    }

    @Override
    public int read() throws IOException {
        return this.m_zipInputStream.read();
    }

    @Override
    public int read(byte[] b) throws IOException {
        return this.m_zipInputStream.read(b);
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        return this.m_zipInputStream.read(b, off, len);
    }

    @Override
    public synchronized void reset() throws IOException {
        this.m_zipInputStream.reset();
    }

    @Override
    public long skip(long n) throws IOException {
        return this.m_zipInputStream.skip(n);
    }
}

