/*
 * Decompiled with CFR 0.152.
 */
package org.pharmgkb.common.comparator;

import java.util.Comparator;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;

public class HaplotypeNameComparator
implements Comparator<String> {
    private static final Pattern sf_starPattern = Pattern.compile("(.*)(\\d+)(.*)");
    private static final Comparator<String> sf_comparator = new HaplotypeNameComparator();

    public static Comparator<String> getComparator() {
        return sf_comparator;
    }

    @Override
    public int compare(String name1, String name2) {
        if (name1 == name2) {
            return 0;
        }
        if (name1 == null) {
            return -1;
        }
        if (name2 == null) {
            return 1;
        }
        Matcher matcher1 = sf_starPattern.matcher(name1);
        Matcher matcher2 = sf_starPattern.matcher(name2);
        if (matcher1.matches() && matcher2.matches()) {
            String prePortion2;
            String prePortion1 = StringUtils.trimToNull((String)matcher1.group(1));
            int rez = ObjectUtils.compare((Comparable)((Object)prePortion1), (Comparable)((Object)(prePortion2 = StringUtils.trimToNull((String)matcher2.group(1)))));
            if (rez != 0) {
                return rez;
            }
            String starPortion1 = matcher1.group(2);
            String starPortion2 = matcher2.group(2);
            int star1 = Integer.parseInt(starPortion1);
            int star2 = Integer.parseInt(starPortion2);
            rez = ObjectUtils.compare((Comparable)Integer.valueOf(star1), (Comparable)Integer.valueOf(star2));
            if (rez != 0) {
                return rez;
            }
            String restPortion1 = StringUtils.trimToNull((String)matcher1.group(3));
            String restPortion2 = StringUtils.trimToNull((String)matcher2.group(3));
            return ObjectUtils.compare((Comparable)((Object)restPortion1), (Comparable)((Object)restPortion2));
        }
        return ObjectUtils.compare((Comparable)((Object)name1), (Comparable)((Object)name2));
    }
}

