/*
 * Decompiled with CFR 0.152.
 */
package org.pharmgkb.common.util;

import com.google.common.base.Preconditions;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.file.Path;
import java.nio.file.Paths;
import javax.annotation.Nonnull;

public final class PathUtils {
    private PathUtils() {
    }

    @Nonnull
    public static String getFilename(@Nonnull Path file) {
        Preconditions.checkNotNull((Object)file);
        return file.getName(file.getNameCount() - 1).toString();
    }

    @Nonnull
    public static String getBaseFilename(@Nonnull Path file) {
        Preconditions.checkNotNull((Object)file);
        String fileName = PathUtils.getFilename(file);
        int idx = fileName.lastIndexOf(".");
        if (idx == -1) {
            return fileName;
        }
        return fileName.substring(0, idx);
    }

    @Nonnull
    public static Path getPathToResource(@Nonnull String filename) {
        Preconditions.checkNotNull((Object)filename);
        URL url = PathUtils.class.getClassLoader().getResource(filename);
        if (url == null) {
            throw new IllegalArgumentException("No such resource: " + filename);
        }
        try {
            return Paths.get(url.toURI());
        }
        catch (URISyntaxException ex) {
            throw new IllegalStateException("Filename '" + filename + "' translated to invalid URI (" + url + ")", ex);
        }
    }
}

