/*
 * Decompiled with CFR 0.152.
 */
package org.pharmgkb.parser.vcf.model.genotype;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;
import org.pharmgkb.parser.vcf.VcfUtils;

@Immutable
public class VcfAllele {
    private final String m_string;

    public VcfAllele(@Nonnull String string) {
        if (!VcfUtils.ALT_BASE_PATTERN.matcher(string).matches()) {
            throw new IllegalArgumentException(string + " does not look like an allele");
        }
        this.m_string = string;
    }

    @Nonnull
    public String toString() {
        return this.m_string;
    }

    public int length() throws IllegalArgumentException {
        if (this.isSymbolic() || this.isBreakpoint() || this.isDeleted()) {
            throw new IllegalArgumentException("Length could not be determined because the allele \"" + this.m_string + "\"is symbolic, deleted upstream, or a breakpoint");
        }
        return this.m_string.length();
    }

    public boolean isBreakpoint() {
        return this.m_string.contains("[") || this.m_string.contains("]");
    }

    public boolean isSymbolic() {
        return this.m_string.contains("<");
    }

    public boolean isAmbigious() {
        return this.containsBase('N', 'n');
    }

    public boolean isDeleted() {
        return this.m_string.equals("*");
    }

    public boolean isSimple() {
        return !this.isBreakpoint() && !this.isSymbolic() && !this.isDeleted();
    }

    public PrimaryType getPrimaryType() {
        if (this.isBreakpoint()) {
            return PrimaryType.BREAKPOINT;
        }
        if (this.isDeleted()) {
            return PrimaryType.DELETED;
        }
        if (this.isSymbolic()) {
            return PrimaryType.SYMBOLIC;
        }
        int length = this.length();
        if (length == 0) {
            return PrimaryType.NO_VARIATION;
        }
        if (length == 1) {
            return PrimaryType.SINGLE_BASE;
        }
        return PrimaryType.MULTI_BASE;
    }

    @Nonnull
    public String withLowercaseBases() {
        if (!this.isSymbolic()) {
            return this.m_string.toLowerCase();
        }
        boolean isInside = false;
        char[] lowercase = new char[this.m_string.length()];
        for (int i = 0; i < this.m_string.length(); ++i) {
            char c = this.m_string.charAt(i);
            if (c == '<') {
                isInside = true;
            } else if (c == '>') {
                isInside = false;
            }
            lowercase[i] = isInside ? c : Character.toLowerCase(c);
        }
        return new String(lowercase);
    }

    public boolean equalsIgnoreCase(@Nullable VcfAllele allele) {
        return allele != null && this.withLowercaseBases().equals(allele.withLowercaseBases());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        VcfAllele allele = (VcfAllele)o;
        return this.m_string.equals(allele.m_string);
    }

    public int hashCode() {
        return this.m_string.hashCode();
    }

    public boolean containsBase(char ... bases) {
        boolean isInside = false;
        for (char c : this.m_string.toCharArray()) {
            if (c == '<') {
                isInside = true;
                continue;
            }
            if (c == '>') {
                isInside = false;
                continue;
            }
            if (isInside) continue;
            for (char base : bases) {
                if (c != base) continue;
                return true;
            }
        }
        return false;
    }

    public static enum PrimaryType {
        SINGLE_BASE,
        MULTI_BASE,
        SYMBOLIC,
        BREAKPOINT,
        DELETED,
        NO_VARIATION;

    }
}

