/*
 * Decompiled with CFR 0.152.
 */
package org.pharmgkb.parser.vcf;

import com.google.common.base.Joiner;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;
import org.pharmgkb.parser.vcf.model.ReservedFormatProperty;
import org.pharmgkb.parser.vcf.model.VcfMetadata;
import org.pharmgkb.parser.vcf.model.VcfPosition;
import org.pharmgkb.parser.vcf.model.VcfSample;

public class MemoryMappedVcfDataStore {
    private VcfMetadata m_metadata;
    private Map<String, VcfPosition> m_idToPosition = new HashMap<String, VcfPosition>();
    private Map<Locus, VcfPosition> m_locusToPosition = new HashMap<Locus, VcfPosition>();
    private Map<String, List<VcfSample>> m_idToSamples = new HashMap<String, List<VcfSample>>();
    private Map<Locus, List<VcfSample>> m_locusToSamples = new HashMap<Locus, List<VcfSample>>();

    @Nullable
    public Collection<VcfPosition> getAllPositions() {
        if (this.m_metadata == null) {
            return null;
        }
        return this.m_locusToPosition.values();
    }

    @Nullable
    public Collection<List<VcfSample>> getAllSamples() {
        if (this.m_metadata == null) {
            return null;
        }
        return this.m_locusToSamples.values();
    }

    @Nullable
    public VcfMetadata getMetadata() {
        return this.m_metadata;
    }

    protected void setMetadata(VcfMetadata metadata) {
        this.m_metadata = metadata;
    }

    @Nullable
    public VcfPosition getPositionForId(@Nonnull String id) {
        return this.m_idToPosition.get(id);
    }

    @Nullable
    public List<VcfSample> getSamplesForId(@Nonnull String id) {
        return this.m_idToSamples.get(id);
    }

    @Nullable
    public VcfPosition getPositionAtLocus(@Nonnull String chromosome, long position) {
        return this.m_locusToPosition.get(new Locus(chromosome, position));
    }

    @Nullable
    public List<VcfSample> getSamplesAtLocus(@Nonnull String chromosome, long position) {
        return this.m_locusToSamples.get(new Locus(chromosome, position));
    }

    @Nullable
    public VcfSample getSampleForId(@Nonnull String positionId, @Nonnull String sampleId) {
        return this.m_idToSamples.get(positionId).get(this.m_metadata.getSampleIndex(sampleId));
    }

    @Nullable
    public VcfSample getSampleForId(@Nonnull String positionId, int sampleIndex) {
        return this.m_idToSamples.get(positionId).get(sampleIndex);
    }

    @Nullable
    public VcfSample getSampleAtLocus(@Nonnull String chromosome, long position, @Nonnull String sampleId) {
        return this.m_locusToSamples.get(new Locus(chromosome, position)).get(this.m_metadata.getSampleIndex(sampleId));
    }

    @Nullable
    public VcfSample getSampleAtLocus(@Nonnull String chromosome, long position, int sampleIndex) {
        return this.m_locusToSamples.get(new Locus(chromosome, position)).get(sampleIndex);
    }

    @Nullable
    public Genotype getGenotypeForId(@Nonnull String positionId, String sampleId) {
        VcfPosition position = this.m_idToPosition.get(positionId);
        VcfSample sample = this.m_idToSamples.get(positionId).get(this.m_metadata.getSampleIndex(sampleId));
        return this.doGetGenotype(position, sample);
    }

    @Nullable
    public Genotype getGenotypeAtLocus(@Nonnull String chromosome, long position, String sampleId) {
        VcfPosition position1 = this.m_locusToPosition.get(new Locus(chromosome, position));
        VcfSample sample = this.m_locusToSamples.get(new Locus(chromosome, position)).get(this.m_metadata.getSampleIndex(sampleId));
        return this.doGetGenotype(position1, sample);
    }

    @Nullable
    public Genotype getGenotypeForId(@Nonnull String positionId, int sampleIndex) {
        VcfPosition position = this.m_idToPosition.get(positionId);
        VcfSample sample = this.m_idToSamples.get(positionId).get(sampleIndex);
        return this.doGetGenotype(position, sample);
    }

    @Nullable
    public Genotype getGenotypeAtLocus(@Nonnull String chromosome, long position, int sampleIndex) {
        VcfPosition position1 = this.m_locusToPosition.get(new Locus(chromosome, position));
        VcfSample sample = this.m_locusToSamples.get(new Locus(chromosome, position)).get(sampleIndex);
        return this.doGetGenotype(position1, sample);
    }

    @Nullable
    private Genotype doGetGenotype(VcfPosition position, VcfSample sample) {
        String genotype = (String)sample.getProperty(ReservedFormatProperty.Genotype);
        if (genotype == null || genotype.isEmpty() || genotype.equals(".")) {
            return null;
        }
        boolean isPhased = genotype.contains("|");
        String[] bases = genotype.split("[\\|/]");
        ArrayList<String> alleles = new ArrayList<String>(bases.length);
        for (String base : bases) {
            alleles.add(position.getAllele(Integer.parseInt(base)));
        }
        return new Genotype(alleles, isPhased);
    }

    protected Map<String, VcfPosition> getIdToPosition() {
        return this.m_idToPosition;
    }

    protected void setIdToPosition(Map<String, VcfPosition> idToPosition) {
        this.m_idToPosition = idToPosition;
    }

    protected Map<Locus, VcfPosition> getLocusToPosition() {
        return this.m_locusToPosition;
    }

    protected void setLocusToPosition(Map<Locus, VcfPosition> locusToPosition) {
        this.m_locusToPosition = locusToPosition;
    }

    protected Map<String, List<VcfSample>> getIdToSamples() {
        return this.m_idToSamples;
    }

    protected void setIdToSamples(Map<String, List<VcfSample>> idToSamples) {
        this.m_idToSamples = idToSamples;
    }

    protected Map<Locus, List<VcfSample>> getLocusToSamples() {
        return this.m_locusToSamples;
    }

    protected void setLocusToSamples(Map<Locus, List<VcfSample>> locusToSamples) {
        this.m_locusToSamples = locusToSamples;
    }

    @Immutable
    protected static class Locus {
        private final String m_chromosome;
        private final long m_position;

        public Locus(String chromosome, long position) {
            this.m_chromosome = chromosome;
            this.m_position = position;
        }

        public String getChromosome() {
            return this.m_chromosome;
        }

        public long getPosition() {
            return this.m_position;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Locus locus = (Locus)o;
            return Objects.equals(this.m_position, locus.getPosition()) && Objects.equals(this.m_chromosome, locus.getChromosome());
        }

        public int hashCode() {
            return Objects.hash(this.m_chromosome, this.m_position);
        }

        public String toString() {
            return this.m_chromosome + ":" + this.m_position;
        }
    }

    @Immutable
    public static class Genotype {
        private final List<String> m_alleles;
        private final boolean m_isPhased;

        public Genotype(List<String> alleles, boolean isPhased) {
            this.m_alleles = alleles;
            this.m_isPhased = isPhased;
        }

        public List<String> getAlleles() {
            return this.m_alleles;
        }

        public boolean isPhased() {
            return this.m_isPhased;
        }

        public String toString() {
            return Joiner.on((String)(this.m_isPhased ? "|" : "/")).join(this.m_alleles);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Genotype genotype = (Genotype)o;
            return Objects.equals(this.m_isPhased, genotype.isPhased()) && Objects.equals(this.m_alleles, genotype.getAlleles());
        }

        public int hashCode() {
            return Objects.hash(this.m_alleles, this.m_isPhased);
        }
    }
}

