/*
 * Decompiled with CFR 0.152.
 */
package org.pharmgkb.parser.vcf.model;

import java.lang.invoke.MethodHandles;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.pharmgkb.parser.vcf.model.IdMetadata;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IdDescriptionMetadata
extends IdMetadata {
    private static final Logger sf_logger = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    public static final String ID = "ID";
    public static final String DESCRIPTION = "Description";

    public IdDescriptionMetadata(@Nonnull String id, @Nonnull String description) {
        this(id, description, true);
    }

    public IdDescriptionMetadata(@Nonnull Map<String, String> properties, boolean isBaseType) {
        super(properties, false);
        this.init(isBaseType);
    }

    protected IdDescriptionMetadata(@Nonnull String id, @Nonnull String description, boolean isBaseType) {
        super(id);
        this.putAndQuoteProperty(DESCRIPTION, description);
        this.init(isBaseType);
    }

    private void init(boolean isBaseType) {
        if (this.getPropertyRaw(DESCRIPTION) == null) {
            sf_logger.warn("Required metadata property \"{}\" is missing", (Object)DESCRIPTION);
        }
        if (isBaseType) {
            this.ensureNoExtras(ID, DESCRIPTION);
        }
    }

    @Nullable
    public String getDescription() {
        return this.getPropertyUnquoted(DESCRIPTION);
    }
}

