/*
 * Decompiled with CFR 0.152.
 */
package org.pharmgkb.parser.vcf.model;

import java.lang.invoke.MethodHandles;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.pharmgkb.parser.vcf.VcfUtils;
import org.pharmgkb.parser.vcf.model.IdDescriptionMetadata;
import org.pharmgkb.parser.vcf.model.InfoType;
import org.pharmgkb.parser.vcf.model.SpecialVcfNumber;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InfoMetadata
extends IdDescriptionMetadata {
    private static final Logger sf_logger = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    public static final String ID = "ID";
    public static final String DESCRIPTION = "Description";
    public static final String NUMBER = "Number";
    public static final String TYPE = "Type";
    public static final String SOURCE = "Source";
    public static final String VERSION = "Version";
    private InfoType m_type;

    public InfoMetadata(@Nonnull String id, @Nonnull String description, @Nonnull InfoType type, @Nonnull String number, @Nullable String source, @Nullable String version) {
        super(id, description);
        this.putPropertyRaw(NUMBER, number);
        this.putPropertyRaw(TYPE, type.name());
        if (source != null) {
            this.putAndQuoteProperty(SOURCE, source);
        }
        if (version != null) {
            this.putAndQuoteProperty(VERSION, version);
        }
        this.init();
    }

    public InfoMetadata(@Nonnull Map<String, String> properties) {
        super(properties, false);
        this.init();
    }

    private void init() {
        String number = this.getPropertyRaw(NUMBER);
        assert (number != null);
        if (!VcfUtils.NUMBER_PATTERN.matcher(number).matches()) {
            sf_logger.warn("{} is not a number: '{}'", (Object)NUMBER, (Object)number);
        }
        this.m_type = InfoType.valueOf(this.getPropertyRaw(TYPE));
        this.ensureNoExtras(ID, DESCRIPTION, NUMBER, TYPE, SOURCE, VERSION);
    }

    @Nullable
    public String getNumber() {
        return this.getPropertyRaw(NUMBER);
    }

    @Nullable
    public SpecialVcfNumber getReservedNumber() {
        return SpecialVcfNumber.fromId(this.getPropertyRaw(NUMBER));
    }

    @Nullable
    public InfoType getType() {
        return this.m_type;
    }

    @Nullable
    public String getSource() {
        return this.getPropertyUnquoted(SOURCE);
    }

    @Nullable
    public String getVersion() {
        return this.getPropertyUnquoted(VERSION);
    }
}

