/*
 * Decompiled with CFR 0.152.
 */
package org.pharmgkb.parser.vcf.model;

import java.math.BigDecimal;
import javax.annotation.Nonnull;
import org.pharmgkb.parser.vcf.model.ReservedProperty;

public enum ReservedInfoProperty implements ReservedProperty
{
    AncestralAllele("AA", "Ancestral allele", String.class, false, "1"),
    AlleleCount("AC", "Allele count in genotypes, for each ALT allele, in the same order as listed", Long.class, true, "A"),
    AlleleFrequency("AF", "Allele frequency for each ALT allele in the same order as listed: use this when estimatedfrom primary data, not called genotypes", BigDecimal.class, true, "A"),
    AlleleNumber("AN", "Total number of alleles in called genotypes", Long.class, false, "1"),
    BaseQuality("BQ", "RMS base quality at this position", BigDecimal.class, false, "1"),
    Cigar("CIGAR", "Cigar string describing how to align an alternate allele to the reference allele", String.class, false, "1"),
    Dbsnp("DB", "dbSNP membership", Boolean.class, false, "0"),
    Depth("DP", "Combined depth across samples", BigDecimal.class, false, "1"),
    Hapmap2("H2", "Membership in HapMap2", Boolean.class, false, "0"),
    Hapmap3("H3", "Membership in HapMap2", Boolean.class, false, "0"),
    MappingQuality("MQ", "RMS mapping quality, e.g. MQ=52", Float.class, false, "1"),
    MappingQualityZeroCount("MQ0", "Number of MAPQ == 0 reads covering this record", Long.class, false, "1"),
    NumberOfSamples("NS", "Number of samples with data", Long.class, false, "1"),
    StrandBias("SB", "Strand bias at this position", Long.class, true, "."),
    SomaticMutation("SOMATIC", "Indicates that the record is a somatic mutation", Boolean.class, false, "0"),
    Validated("VALIDATED", "Validated by follow-up experiment", Boolean.class, false, "0"),
    ThousandGenomes("1000G", "Is a member of 1000 genomes", Boolean.class, false, "0"),
    Imprecise("IMPRECISE", "Imprecise structural variation", Boolean.class, false, "0"),
    Novel("NOVEL", "Indicates a novel structural variation", Boolean.class, false, "0"),
    End("END", "End position of the variant described in this record", Long.class, false, "1"),
    StructuralVariantType("SVTYPE", "Type of structural variant", String.class, false, "1"),
    StructuralVariantLength("SVLEN", "Difference in length between REF and ALT alleles", Long.class, false, "."),
    ConfidenceIntervalForPosition("CIPOS", "Confidence interval around POS for imprecise variants", Long.class, true, "2"),
    ConfidenceIntervalForEnd("CIEND", "Confidence interval around END for imprecise variants", Long.class, true, "2"),
    HomologyLength("HOMLEN", "Length of base pair identical micro-homology at event breakpoints", Long.class, false, "."),
    HomologySequence("HOMLEN", "Sequence of base pair identical micro-homology at event breakpoints", String.class, false, "."),
    BreakpointId("BKPTID", "ID of the assembled alternate allele in the assembly file", String.class, false, "."),
    MobileElementInfo("MEINFO", "Mobile element info of the form NAME,START,END,POLARITY", String.class, true, "4"),
    MobileElementTransduction("METRANS", "Mobile element transduction info of the form CHR,START,END,POLARITY", String.class, true, "4"),
    DgvId("DGVID", "ID of this element in Database of Genomic Variation", String.class, false, "1"),
    DbvarId("DBVARID", "ID of this element in DBVAR", String.class, false, "1"),
    DbripId("DBRIPID", "ID of this element in DBRIP", String.class, false, "1"),
    MateId("MATEID", "ID of mate breakends", String.class, false, "."),
    PartnerId("PARID", "ID of partner breakend", String.class, false, "1"),
    EventId("EVENT", "ID of event associated to breakend", String.class, false, "1"),
    ConfidenceIntervalForInsertedMaterial("CILEN", "Confidence interval around the inserted material between breakends", Long.class, true, "2"),
    ReadDepthOfAdjacency("DPADJ", "Read Depth of adjacency", Long.class, true, "."),
    CopyNumberOfSegment("CN", "Copy number of segment containing breakend", Long.class, false, "1"),
    CopyNumberOfAdjacency("CNADJ", "Copy number of adjacency", Long.class, true, "."),
    ConfidenceIntervalForSegmentCopyNumber("CICN", "Confidence interval around copy number for the segment", Long.class, true, "2"),
    ConfidenceIntervalForAdjacencyCopyNumber("CICNADJ", "Confidence interval around copy number for the adjacency", Long.class, true, "2");

    @Nonnull
    private final String m_id;
    @Nonnull
    private final String m_description;
    @Nonnull
    private final Class m_type;
    @Nonnull
    private final String m_number;
    private final boolean m_isList;

    private ReservedInfoProperty(@Nonnull String id, String description, @Nonnull Class type, boolean isList, String number) {
        this.m_id = id;
        this.m_description = description;
        this.m_type = type;
        this.m_isList = isList;
        this.m_number = number;
    }

    @Override
    @Nonnull
    public String getId() {
        return this.m_id;
    }

    @Override
    @Nonnull
    public String getDescription() {
        return this.m_description;
    }

    @Override
    @Nonnull
    public Class getType() {
        return this.m_type;
    }

    @Nonnull
    public String getNumber() {
        return this.m_number;
    }

    @Override
    public boolean isList() {
        return this.m_isList;
    }
}

