/*
 * Decompiled with CFR 0.152.
 */
package org.pharmgkb.parser.vcf;

import java.io.Closeable;
import java.io.IOException;
import java.io.PrintWriter;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import org.pharmgkb.parser.vcf.VcfLineParser;
import org.pharmgkb.parser.vcf.VcfTransformation;
import org.pharmgkb.parser.vcf.VcfWriter;
import org.pharmgkb.parser.vcf.model.VcfMetadata;
import org.pharmgkb.parser.vcf.model.VcfPosition;
import org.pharmgkb.parser.vcf.model.VcfSample;

public class TransformingVcfLineParser
implements VcfLineParser,
Closeable {
    private int m_lines;
    private final List<VcfTransformation> m_transformations;
    private final List<VcfWriter> m_writers;

    private TransformingVcfLineParser(@Nonnull List<VcfTransformation> transformations, @Nonnull List<VcfWriter> writer) {
        this.m_transformations = transformations;
        this.m_writers = writer;
    }

    @Override
    public void parseLine(@Nonnull VcfMetadata metadata, @Nonnull VcfPosition position, @Nonnull List<VcfSample> sampleData) {
        for (int i = 0; i < this.m_transformations.size(); ++i) {
            boolean keep;
            if (this.m_lines == 0) {
                this.m_transformations.get(i).transformMetadata(metadata);
                this.m_writers.get(i).writeHeader(metadata);
            }
            if (!(keep = this.m_transformations.get(i).transformDataLine(metadata, position, sampleData))) continue;
            this.m_writers.get(i).writeLine(metadata, position, sampleData);
        }
        ++this.m_lines;
    }

    @Override
    public void close() {
        this.m_writers.forEach(VcfWriter::close);
    }

    public static class Builder {
        private final List<VcfTransformation> m_transformations = new ArrayList<VcfTransformation>();
        private final List<VcfWriter> m_writers = new ArrayList<VcfWriter>();

        @Nonnull
        public Builder addTransformation(@Nonnull VcfTransformation transformation, @Nonnull Path outputFile) throws IOException {
            this.m_transformations.add(transformation);
            this.m_writers.add(new VcfWriter.Builder().toFile(outputFile).build());
            return this;
        }

        @Nonnull
        public Builder addTransformation(@Nonnull VcfTransformation transformation, @Nonnull PrintWriter writer) throws IOException {
            this.m_transformations.add(transformation);
            this.m_writers.add(new VcfWriter.Builder().toWriter(writer).build());
            return this;
        }

        @Nonnull
        public Builder addTransformation(@Nonnull VcfTransformation transformation, @Nonnull VcfWriter writer) throws IOException {
            this.m_transformations.add(transformation);
            this.m_writers.add(writer);
            return this;
        }

        @Nonnull
        public TransformingVcfLineParser build() {
            if (this.m_transformations.isEmpty()) {
                throw new IllegalStateException("Must add at least one transformation");
            }
            return new TransformingVcfLineParser(this.m_transformations, this.m_writers);
        }
    }
}

