/*
 * Decompiled with CFR 0.152.
 */
package org.pharmgkb.parser.vcf;

import com.google.common.base.Preconditions;
import org.apache.commons.lang3.StringUtils;

public class VcfFormatException
extends RuntimeException {
    private int m_lineNumber;
    private String m_section;
    private final String m_baseMessage;

    public VcfFormatException(String msg) {
        Preconditions.checkNotNull((Object)msg);
        this.m_baseMessage = msg;
    }

    public VcfFormatException(String msg, Throwable ex) {
        super(ex);
        this.m_baseMessage = StringUtils.stripToNull((String)msg);
    }

    public VcfFormatException(int lineNumber, String section, Throwable ex) {
        super(ex);
        this.m_lineNumber = lineNumber;
        this.m_section = section;
        this.m_baseMessage = StringUtils.stripToNull((String)ex.getMessage());
    }

    public void addMetadata(int lineNumber, String section) {
        this.m_lineNumber = lineNumber;
        this.m_section = section;
    }

    @Override
    public String getMessage() {
        if (this.m_section == null) {
            return this.m_baseMessage;
        }
        StringBuilder builder = new StringBuilder().append("[Line #").append(this.m_lineNumber).append("] Error parsing ").append(this.m_section);
        if (this.m_baseMessage != null) {
            builder.append(": ").append(this.m_baseMessage);
        }
        return builder.toString();
    }

    @Override
    public String toString() {
        return this.getMessage();
    }
}

