/*
 * Decompiled with CFR 0.152.
 */
package org.pharmgkb.parser.vcf.model;

import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.pharmgkb.parser.vcf.VcfFormatException;
import org.pharmgkb.parser.vcf.model.ReservedStructuralVariantCode;

public class AltStructuralVariant {
    private static final Pattern sf_colon = Pattern.compile(":");
    private final List<String> m_components;

    public AltStructuralVariant(@Nonnull String string) {
        if (string.isEmpty()) {
            throw new VcfFormatException("Structural variant code must not be empty");
        }
        String[] components = sf_colon.split(string);
        this.m_components = new ArrayList<String>(components.length);
        for (int level = 0; level < components.length; ++level) {
            ReservedStructuralVariantCode realParent;
            ReservedStructuralVariantCode type = ReservedStructuralVariantCode.fromId(components[level]);
            if (type == null && level == 0) {
                throw new VcfFormatException("Top-level structural variant code was " + components[level] + " but must be a top-level reserved code (e.g. DEL or CNV)");
            }
            if (type != null && level != type.getLevelInSpecification()) {
                throw new VcfFormatException("Structural variant code " + components[level] + " is a reserved code of level " + type.getLevelInSpecification() + ", not " + level);
            }
            if (type != null && level > 0 && (realParent = ReservedStructuralVariantCode.fromId(this.m_components.get(level - 1))) != null) {
                boolean foundMatch = false;
                for (ReservedStructuralVariantCode parent : type.getParentCodes()) {
                    if (realParent != parent) continue;
                    foundMatch = true;
                    break;
                }
                if (!foundMatch) {
                    throw new VcfFormatException("Structural variant code " + components[level] + " was not a child of reserved code " + realParent.getId());
                }
            }
            this.m_components.add(components[level]);
        }
    }

    @Nonnull
    public List<String> getComponents() {
        return this.m_components;
    }

    @Nonnull
    public String getComponent(int level) {
        return this.m_components.get(level);
    }

    @Nullable
    public ReservedStructuralVariantCode getReservedComponent(int level) {
        return ReservedStructuralVariantCode.fromId(this.m_components.get(level));
    }

    @Nonnull
    public String toString() {
        StringBuilder sb = new StringBuilder(this.m_components.get(0));
        for (int i = 1; i < this.m_components.size(); ++i) {
            sb.append(":").append(this.m_components.get(i));
        }
        return sb.toString();
    }
}

