/*
 * Decompiled with CFR 0.152.
 */
package org.pharmgkb.parser.vcf.model;

import java.lang.invoke.MethodHandles;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.pharmgkb.parser.vcf.VcfFormatException;
import org.pharmgkb.parser.vcf.VcfUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BaseMetadata {
    private static final Logger sf_logger = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private final Map<String, String> m_properties;

    public BaseMetadata(@Nonnull Map<String, String> properties) {
        for (Map.Entry<String, String> entry : properties.entrySet()) {
            if (!entry.getKey().contains("\n") && !entry.getValue().contains("\n")) continue;
            throw new VcfFormatException("INFO [[[" + entry.getKey() + "=" + entry.getValue() + "]]] contains a newline");
        }
        this.m_properties = properties;
    }

    @Nullable
    public String getPropertyUnquoted(@Nonnull String key) {
        String got = this.m_properties.get(key);
        if (got == null) {
            return null;
        }
        return VcfUtils.unquote(got);
    }

    @Nullable
    public String getPropertyRaw(@Nonnull String key) {
        return this.m_properties.get(key);
    }

    @Nonnull
    public Map<String, String> getPropertiesUnquoted() {
        HashMap<String, String> map = new HashMap<String, String>();
        for (Map.Entry<String, String> entry : this.m_properties.entrySet()) {
            map.put(entry.getKey(), VcfUtils.unquote(entry.getValue()));
        }
        return map;
    }

    @Nonnull
    public Map<String, String> getPropertiesRaw() {
        return this.m_properties;
    }

    @Nonnull
    public Set<String> getPropertyKeys() {
        return this.m_properties.keySet();
    }

    public void putAndQuoteProperty(@Nonnull String key, @Nullable String value) {
        if (value == null) {
            this.m_properties.remove(key);
        } else {
            this.m_properties.put(key, VcfUtils.quote(value));
        }
    }

    public void putPropertyRaw(@Nonnull String key, @Nullable String value) {
        this.m_properties.put(key, value);
    }

    protected void ensureNoExtras(String ... names) {
        HashSet set = new HashSet();
        Collections.addAll(set, names);
        this.m_properties.keySet().stream().filter(property -> !set.contains(property)).forEach(property -> sf_logger.warn("Metadata line contains unexpected property {}", property));
    }
}

