/*
 * Decompiled with CFR 0.152.
 */
package org.pharmgkb.parser.vcf.model;

import java.lang.invoke.MethodHandles;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.pharmgkb.parser.vcf.model.IdMetadata;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ContigMetadata
extends IdMetadata {
    private static final Logger sf_logger = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    public static final String ID = "ID";
    public static final String LENGTH = "length";
    public static final String ASSEMBLY = "assembly";
    public static final String MD5 = "md5";
    public static final String SPECIES = "species";
    public static final String TAXONOMY = "taxonomy";
    public static final String URL = "URL";

    public ContigMetadata(@Nonnull String id, long length, @Nonnull String assembly, @Nullable String md5, @Nullable String species, @Nullable String taxonomy, @Nullable String url) {
        super(id, false);
        this.putPropertyRaw(LENGTH, String.valueOf(length));
        this.putPropertyRaw(ASSEMBLY, assembly);
        if (md5 != null) {
            this.putPropertyRaw(MD5, md5);
        }
        if (species != null) {
            this.putAndQuoteProperty(SPECIES, species);
        }
        if (taxonomy != null) {
            this.putPropertyRaw(TAXONOMY, taxonomy);
        }
        if (url != null) {
            try {
                new URL(url);
            }
            catch (MalformedURLException e) {
                sf_logger.warn("URL {} is malformed", (Object)url, (Object)e);
            }
        }
        this.putPropertyRaw(URL, url);
        this.init();
    }

    public ContigMetadata(@Nonnull Map<String, String> properties) {
        super(properties, false);
        this.init();
    }

    public long getLength() {
        return Long.parseLong(this.getPropertyRaw(LENGTH));
    }

    @Nullable
    public String getAssembly() {
        return this.getPropertyRaw(ASSEMBLY);
    }

    @Nullable
    public String getTaxonomy() {
        return this.getPropertyRaw(TAXONOMY);
    }

    @Nullable
    public String getSpecies() {
        return this.getPropertyUnquoted(SPECIES);
    }

    @Nullable
    public String getMd5() {
        return this.getPropertyRaw(MD5);
    }

    @Nullable
    public String getUrl() {
        return this.getPropertyRaw(URL);
    }

    private void init() {
        String length;
        if (this.getPropertyUnquoted(ASSEMBLY) == null) {
            sf_logger.warn("Required metadata property \"{}\" is missing", (Object)ASSEMBLY);
        }
        if ((length = this.getPropertyUnquoted(LENGTH)) == null) {
            sf_logger.warn("Required metadata property \"{}\" is missing", (Object)LENGTH);
        } else {
            try {
                Long.parseLong(length);
            }
            catch (NumberFormatException e) {
                sf_logger.warn("Length is not a number", (Throwable)e);
            }
        }
        this.ensureNoExtras(ID, LENGTH, ASSEMBLY, MD5, SPECIES, TAXONOMY, URL);
    }
}

