/*
 * Decompiled with CFR 0.152.
 */
package org.pharmgkb.parser.vcf.model;

import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.pharmgkb.parser.vcf.VcfFormatException;
import org.pharmgkb.parser.vcf.VcfUtils;
import org.pharmgkb.parser.vcf.model.ReservedFormatProperty;

public class VcfSample {
    private LinkedHashMap<String, String> m_properties = new LinkedHashMap();

    public VcfSample(@Nullable List<String> keys, @Nullable List<String> values) {
        if (keys == null) {
            if (values == null || values.size() == 0) {
                return;
            }
            throw new VcfFormatException("Sample keys is null but values is not");
        }
        if (values == null) {
            throw new VcfFormatException("Sample values is null but keys is not");
        }
        if (keys.size() != values.size()) {
            throw new VcfFormatException("Number of FORMAT entries does not match number of sample entries");
        }
        for (int x = 0; x < keys.size(); ++x) {
            this.m_properties.put(keys.get(x), values.get(x));
        }
        this.init();
    }

    public VcfSample(@Nonnull LinkedHashMap<String, String> properties) {
        this.m_properties = properties;
        this.init();
    }

    private void init() {
        for (Map.Entry<String, String> entry : this.m_properties.entrySet()) {
            if (!entry.getKey().contains("\n") && !entry.getValue().contains("\n")) continue;
            throw new VcfFormatException("FORMAT [[[" + entry.getKey() + "=" + entry.getValue() + "]]] contains a newline");
        }
    }

    @Nullable
    public String getProperty(@Nonnull String key) {
        return this.m_properties.get(key);
    }

    @Nullable
    public <T> T getProperty(@Nonnull ReservedFormatProperty key) {
        return VcfUtils.convertProperty(key, this.getProperty(key.getId()));
    }

    public boolean containsProperty(@Nonnull String key) {
        return this.m_properties.containsKey(key);
    }

    public boolean containsProperty(@Nonnull ReservedFormatProperty key) {
        return this.m_properties.containsKey(key.getId());
    }

    public void putProperty(@Nonnull String key, @Nullable String value) {
        this.m_properties.put(key, value);
    }

    public void putProperty(@Nonnull ReservedFormatProperty key, @Nullable String value) {
        this.m_properties.put(key.getId(), value);
    }

    public void removeProperty(@Nonnull String key) {
        this.m_properties.remove(key);
    }

    public void removeProperty(@Nonnull ReservedFormatProperty key) {
        this.m_properties.remove(key.getId());
    }

    public void clearProperties() {
        this.m_properties.clear();
    }

    @Nonnull
    public Set<String> getPropertyKeys() {
        return this.m_properties.keySet();
    }

    @Nonnull
    public Set<Map.Entry<String, String>> propertyEntrySet() {
        return this.m_properties.entrySet();
    }
}

