/*
 * Decompiled with CFR 0.152.
 */
package org.pharmgkb.parser.vcf;

import java.util.List;
import javax.annotation.Nonnull;
import org.pharmgkb.parser.vcf.MemoryMappedVcfDataStore;
import org.pharmgkb.parser.vcf.VcfFormatException;
import org.pharmgkb.parser.vcf.VcfLineParser;
import org.pharmgkb.parser.vcf.model.VcfMetadata;
import org.pharmgkb.parser.vcf.model.VcfPosition;
import org.pharmgkb.parser.vcf.model.VcfSample;

public class MemoryMappedVcfLineParser
implements VcfLineParser {
    private MemoryMappedVcfDataStore m_dataStore = new MemoryMappedVcfDataStore();
    private DuplicateHandler m_duplicateIdHandler;
    private DuplicateHandler m_duplicateLocusHandler;

    private MemoryMappedVcfLineParser(@Nonnull DuplicateHandler idHandler, @Nonnull DuplicateHandler locusHandler) {
        this.m_duplicateIdHandler = idHandler;
        this.m_duplicateLocusHandler = locusHandler;
    }

    @Nonnull
    public MemoryMappedVcfDataStore getDataStore() {
        return this.m_dataStore;
    }

    @Override
    public void parseLine(VcfMetadata metadata, VcfPosition position, List<VcfSample> sampleData) {
        this.m_dataStore.setMetadata(metadata);
        MemoryMappedVcfDataStore.Locus locus = new MemoryMappedVcfDataStore.Locus(position.getChromosome(), position.getPosition());
        boolean containsPosition = this.m_dataStore.getLocusToPosition().containsKey(locus);
        if (containsPosition && this.m_duplicateLocusHandler == DuplicateHandler.FAIL) {
            throw new VcfFormatException("Duplicate VCF record for position " + locus);
        }
        if (!containsPosition || this.m_duplicateLocusHandler == DuplicateHandler.KEEP_LAST) {
            this.m_dataStore.getLocusToPosition().put(locus, position);
            this.m_dataStore.getLocusToSamples().put(locus, sampleData);
        }
        for (String id : position.getIds()) {
            boolean containsId = this.m_dataStore.getIdToPosition().containsKey(id);
            if (containsId && this.m_duplicateIdHandler == DuplicateHandler.FAIL) {
                throw new VcfFormatException("Duplicate VCF record for ID " + id);
            }
            if (containsId && this.m_duplicateIdHandler != DuplicateHandler.KEEP_LAST) continue;
            this.m_dataStore.getIdToPosition().put(id, position);
            this.m_dataStore.getIdToSamples().put(id, sampleData);
        }
    }

    public static enum DuplicateHandler {
        FAIL,
        KEEP_FIRST,
        KEEP_LAST;

    }

    public static class Builder {
        private DuplicateHandler m_duplicateIdHandler = DuplicateHandler.FAIL;
        private DuplicateHandler m_duplicateLocusHandler = DuplicateHandler.FAIL;

        @Nonnull
        public Builder setDuplicateIdHandler(@Nonnull DuplicateHandler handler) {
            this.m_duplicateIdHandler = handler;
            return this;
        }

        @Nonnull
        public Builder setDuplicateLocusHandler(@Nonnull DuplicateHandler handler) {
            this.m_duplicateLocusHandler = handler;
            return this;
        }

        public MemoryMappedVcfLineParser build() {
            return new MemoryMappedVcfLineParser(this.m_duplicateIdHandler, this.m_duplicateLocusHandler);
        }
    }
}

