/*
 * Decompiled with CFR 0.152.
 */
package org.pharmgkb.parser.vcf.model;

import java.util.Arrays;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public enum ReservedStructuralVariantCode {
    Deletion("DEL"),
    Insertion("INS"),
    Duplication("DUP"),
    Inversion("INV"),
    Cnv("CNV"),
    Tandem("TANDEM", 1, Duplication),
    MobileElement("ME", 1, Insertion, Deletion);

    private final String m_id;
    private final int m_level;
    private final List<ReservedStructuralVariantCode> m_parentCodes;

    @Nullable
    public static ReservedStructuralVariantCode fromId(@Nonnull String id) {
        switch (id) {
            case "DEL": {
                return Deletion;
            }
            case "INS": {
                return Insertion;
            }
            case "DUP": {
                return Duplication;
            }
            case "INV": {
                return Inversion;
            }
            case "TANDEM": {
                return Tandem;
            }
            case "ME": {
                return MobileElement;
            }
        }
        return null;
    }

    private ReservedStructuralVariantCode(String id) {
        this(id, 0, new ReservedStructuralVariantCode[0]);
    }

    private ReservedStructuralVariantCode(@Nonnull String id, int level, ReservedStructuralVariantCode ... parentCodes) {
        this.m_id = id;
        this.m_level = level;
        this.m_parentCodes = Arrays.asList(parentCodes);
    }

    public String getId() {
        return this.m_id;
    }

    public int getLevelInSpecification() {
        return this.m_level;
    }

    public List<ReservedStructuralVariantCode> getParentCodes() {
        return this.m_parentCodes;
    }
}

