/*
 * Decompiled with CFR 0.152.
 */
package org.pharmgkb.parser.vcf.model;

import com.google.common.base.Preconditions;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.ListMultimap;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.SortedSet;
import java.util.TreeSet;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.pharmgkb.parser.vcf.VcfFormatException;
import org.pharmgkb.parser.vcf.VcfUtils;
import org.pharmgkb.parser.vcf.model.BaseMetadata;
import org.pharmgkb.parser.vcf.model.ContigMetadata;
import org.pharmgkb.parser.vcf.model.FormatMetadata;
import org.pharmgkb.parser.vcf.model.IdDescriptionMetadata;
import org.pharmgkb.parser.vcf.model.InfoMetadata;

public class VcfMetadata {
    private String m_fileFormat;
    private final Map<String, IdDescriptionMetadata> m_alt;
    private final Map<String, InfoMetadata> m_info;
    private final Map<String, IdDescriptionMetadata> m_filter;
    private final Map<String, FormatMetadata> m_format;
    private final List<String> m_columns;
    private final ListMultimap<String, String> m_properties;
    private final Map<String, ContigMetadata> m_contig;
    private final Map<String, IdDescriptionMetadata> m_sample;
    private final List<BaseMetadata> m_pedigree;

    private VcfMetadata(@Nonnull String fileFormat, @Nullable Map<String, IdDescriptionMetadata> alt, @Nullable Map<String, InfoMetadata> info, @Nullable Map<String, IdDescriptionMetadata> filter, @Nullable Map<String, FormatMetadata> format, @Nullable Map<String, ContigMetadata> contig, @Nullable Map<String, IdDescriptionMetadata> sample, @Nullable List<BaseMetadata> pedigree, @Nonnull List<String> columns, @Nullable ListMultimap<String, String> properties) {
        Preconditions.checkNotNull((Object)fileFormat);
        Preconditions.checkNotNull(columns);
        this.m_fileFormat = fileFormat;
        this.m_alt = alt == null ? new HashMap() : alt;
        this.m_info = info == null ? new HashMap() : info;
        this.m_filter = filter == null ? new HashMap() : filter;
        this.m_format = format == null ? new HashMap() : format;
        this.m_contig = contig == null ? new HashMap() : contig;
        this.m_sample = sample == null ? new HashMap() : sample;
        this.m_pedigree = pedigree == null ? new ArrayList() : pedigree;
        this.m_properties = properties == null ? ArrayListMultimap.create() : properties;
        this.m_columns = columns;
    }

    @Nonnull
    public String getFileFormat() {
        return this.m_fileFormat;
    }

    public void setFileFormat(@Nonnull String fileFormat) {
        if (!VcfUtils.FILE_FORMAT_PATTERN.matcher(fileFormat).matches()) {
            throw new VcfFormatException("VCF format must look like ex: VCFv4.2; was " + fileFormat);
        }
        this.m_fileFormat = fileFormat;
    }

    @Nonnull
    public Map<String, IdDescriptionMetadata> getAlts() {
        return this.m_alt;
    }

    @Nullable
    public IdDescriptionMetadata getAlt(@Nonnull String id) {
        IdDescriptionMetadata md = this.m_alt.get(id);
        if (md == null && id.startsWith("<") && id.endsWith(">")) {
            md = this.m_alt.get(id.substring(1, id.length() - 1));
        }
        return md;
    }

    @Nonnull
    public Map<String, InfoMetadata> getInfo() {
        return this.m_info;
    }

    @Nonnull
    public Map<String, IdDescriptionMetadata> getFilters() {
        return this.m_filter;
    }

    @Nonnull
    public Map<String, FormatMetadata> getFormats() {
        return this.m_format;
    }

    @Nonnull
    public Map<String, ContigMetadata> getContigs() {
        return this.m_contig;
    }

    @Nonnull
    public List<BaseMetadata> getPedigrees() {
        return this.m_pedigree;
    }

    @Nonnull
    public Map<String, IdDescriptionMetadata> getSamples() {
        return this.m_sample;
    }

    @Nonnull
    public List<String> getAssemblies() {
        return this.m_properties.get((Object)"assembly");
    }

    @Nonnull
    public List<String> getPedigreeDatabases() {
        return this.m_properties.get((Object)"pedigreeDB");
    }

    public void addAlt(@Nonnull IdDescriptionMetadata value) {
        this.m_alt.put(value.getId(), value);
    }

    public void addInfo(@Nonnull InfoMetadata value) {
        this.m_info.put(value.getId(), value);
    }

    public void addFormat(@Nonnull FormatMetadata value) {
        this.m_format.put(value.getId(), value);
    }

    public void addContig(@Nonnull ContigMetadata value) {
        this.m_contig.put(value.getId(), value);
    }

    public void addFilter(@Nonnull IdDescriptionMetadata value) {
        this.m_filter.put(value.getId(), value);
    }

    public void addAssembly(@Nonnull String value) {
        this.m_properties.put((Object)"assembly", (Object)value);
    }

    public void addPedigreeDatabase(@Nonnull String value) {
        if (!value.startsWith("<") || !value.endsWith(">")) {
            throw new VcfFormatException("pedigreeDB string " + value + " should be enclosed in angle brackets according to spec");
        }
        this.m_properties.put((Object)"pedigreeDB", (Object)value);
    }

    public void removeAlt(@Nonnull IdDescriptionMetadata value) {
        this.m_alt.remove(value.getId());
    }

    public void removeInfo(@Nonnull InfoMetadata value) {
        this.m_info.remove(value.getId());
    }

    public void removeFormat(@Nonnull FormatMetadata value) {
        this.m_format.remove(value.getId());
    }

    public void removeContig(@Nonnull ContigMetadata value) {
        this.m_contig.remove(value.getId());
    }

    public void removeFilter(@Nonnull IdDescriptionMetadata value) {
        this.m_filter.remove(value.getId());
    }

    public void removeAssembly(@Nonnull String value) {
        this.m_properties.remove((Object)"assembly", (Object)value);
    }

    public void removePedigreeDb(@Nonnull String value) {
        if (!value.startsWith("<") || !value.endsWith(">")) {
            throw new VcfFormatException("pedigreeDB string " + value + " should be enclosed in angle brackets according to spec");
        }
        this.m_properties.remove((Object)"pedigreeDB", (Object)value);
    }

    @Nonnull
    public ListMultimap<String, String> getRawProperties() {
        return this.m_properties;
    }

    @Nonnull
    public List<String> getRawValuesOfProperty(@Nonnull String propertyKey) {
        return this.m_properties.get((Object)propertyKey);
    }

    @Nonnull
    public SortedSet<String> getRawPropertyKeys() {
        return new TreeSet<String>(this.m_properties.keySet());
    }

    public int getColumnIndex(@Nonnull String column) {
        return this.m_columns.indexOf(column);
    }

    public int getSampleIndex(@Nonnull String sampleId) {
        return this.m_columns.indexOf(sampleId) - 9;
    }

    public int getNumSamples() {
        if (this.m_columns.size() < 9) {
            return 0;
        }
        return this.m_columns.size() - 9;
    }

    public int getNumColumns() {
        return this.m_columns.size();
    }

    @Nonnull
    public String getSampleName(int idx) {
        return this.m_columns.get(9 + idx);
    }

    public static class Builder {
        private String m_fileFormat;
        private final Map<String, IdDescriptionMetadata> m_alt = new HashMap<String, IdDescriptionMetadata>();
        private final Map<String, InfoMetadata> m_info = new HashMap<String, InfoMetadata>();
        private final Map<String, IdDescriptionMetadata> m_filter = new HashMap<String, IdDescriptionMetadata>();
        private final Map<String, FormatMetadata> m_format = new HashMap<String, FormatMetadata>();
        private final Map<String, ContigMetadata> m_contig = new HashMap<String, ContigMetadata>();
        private final Map<String, IdDescriptionMetadata> m_sample = new HashMap<String, IdDescriptionMetadata>();
        private final List<BaseMetadata> m_pedigree = new ArrayList<BaseMetadata>();
        private List<String> m_columns = new ArrayList<String>();
        private final ListMultimap<String, String> m_properties = ArrayListMultimap.create();

        public Builder setFileFormat(@Nonnull String fileFormat) {
            this.m_fileFormat = fileFormat;
            if (!VcfUtils.FILE_FORMAT_PATTERN.matcher(fileFormat).matches()) {
                throw new VcfFormatException("Not a VCF file: fileformat is " + this.m_fileFormat);
            }
            return this;
        }

        public Builder addAlt(@Nonnull IdDescriptionMetadata md) {
            if (this.m_alt.containsKey(md.getId())) {
                throw new VcfFormatException("Duplicate ID " + md.getId() + " for ALT");
            }
            this.m_alt.put(md.getId(), md);
            return this;
        }

        public Builder addInfo(@Nonnull InfoMetadata md) {
            if (this.m_info.containsKey(md.getId())) {
                throw new VcfFormatException("Duplicate ID " + md.getId() + " for INFO");
            }
            this.m_info.put(md.getId(), md);
            return this;
        }

        public Builder addFilter(@Nonnull IdDescriptionMetadata md) {
            if (this.m_filter.containsKey(md.getId())) {
                throw new VcfFormatException("Duplicate ID " + md.getId() + " for FILTER");
            }
            this.m_filter.put(md.getId(), md);
            return this;
        }

        public Builder addFormat(@Nonnull FormatMetadata md) {
            if (this.m_format.containsKey(md.getId())) {
                throw new VcfFormatException("Duplicate ID " + md.getId() + " for FORMAT");
            }
            this.m_format.put(md.getId(), md);
            return this;
        }

        public Builder addContig(@Nonnull ContigMetadata md) {
            if (this.m_contig.containsKey(md.getId())) {
                throw new VcfFormatException("Duplicate ID " + md.getId() + " for CONTIG");
            }
            this.m_contig.put(md.getId(), md);
            return this;
        }

        public Builder addSample(@Nonnull IdDescriptionMetadata md) {
            if (this.m_sample.containsKey(md.getId())) {
                throw new VcfFormatException("Duplicate ID " + md.getId() + " for SAMPLE");
            }
            this.m_sample.put(md.getId(), md);
            return this;
        }

        public Builder addPedigree(@Nonnull BaseMetadata md) {
            this.m_pedigree.add(md);
            return this;
        }

        public Builder addRawProperty(@Nonnull String name, @Nonnull String value) {
            this.m_properties.put((Object)name, (Object)value);
            return this;
        }

        public Builder setColumns(@Nonnull List<String> cols) {
            this.m_columns = cols;
            return this;
        }

        @Nonnull
        public VcfMetadata build() {
            if (this.m_fileFormat == null) {
                throw new VcfFormatException("Not a VCF file: no ##fileformat line");
            }
            return new VcfMetadata(this.m_fileFormat, this.m_alt, this.m_info, this.m_filter, this.m_format, this.m_contig, this.m_sample, this.m_pedigree, this.m_columns, this.m_properties);
        }
    }
}

