/*
 * Decompiled with CFR 0.152.
 */
package org.pharosnet.vertx.pg.dal.core;

import io.vertx.core.AsyncResult;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.logging.Logger;
import io.vertx.core.logging.LoggerFactory;
import io.vertx.sqlclient.RowSet;
import io.vertx.sqlclient.Transaction;
import io.vertx.sqlclient.Tuple;
import java.util.List;
import org.pharosnet.vertx.pg.dal.core.ExecBatchBuilder;
import org.pharosnet.vertx.pg.dal.core.ExecBuilder;

public class Tx {
    private static final Logger log = LoggerFactory.getLogger(Tx.class);
    private Transaction tx;

    public Tx(Transaction tx) {
        this.tx = tx;
    }

    private void rollback(Throwable cause, Handler<AsyncResult<Void>> handler) {
        this.tx.rollback(r -> {
            if (r.failed()) {
                log.error((Object)"tx rollback failed", r.cause());
            }
            this.tx.close();
            handler.handle((Object)Future.failedFuture((Throwable)cause));
        });
    }

    public void rollback(Handler<AsyncResult<Void>> handler) {
        this.tx.rollback(r -> {
            if (r.failed()) {
                log.error((Object)"tx rollback failed", r.cause());
                handler.handle((Object)Future.failedFuture((Throwable)r.cause()));
            }
            handler.handle((Object)Future.succeededFuture());
        });
    }

    public void close() {
        this.tx.close();
    }

    public void commit(Handler<AsyncResult<Void>> handler) {
        this.tx.commit(r -> {
            if (r.failed()) {
                log.error((Object)"tx commit failed", r.cause());
                this.rollback(r.cause(), handler);
                return;
            }
            this.close();
            handler.handle((Object)Future.succeededFuture());
        });
    }

    public void update(String ql, Handler<AsyncResult<Integer>> handler) {
        this.tx.query(ql, r -> {
            if (r.failed()) {
                log.error((Object)"tx update failed", r.cause());
                if (log.isDebugEnabled()) {
                    log.debug((Object)"tx update:\n\tsql:{}", new Object[]{ql});
                }
                this.rollback(r.cause(), (Handler<AsyncResult<Void>>)((Handler)rb -> handler.handle((Object)Future.failedFuture((Throwable)rb.cause()))));
                return;
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)"tx update:\n\tsql:{}\n\tupdated:{}", new Object[]{ql, ((RowSet)r.result()).rowCount()});
            }
            handler.handle((Object)Future.succeededFuture((Object)((RowSet)r.result()).rowCount()));
        });
    }

    public void update(String ql, Tuple args, Handler<AsyncResult<Integer>> handler) {
        this.tx.preparedQuery(ql, args, r -> {
            if (r.failed()) {
                log.error((Object)"tx update failed", r.cause());
                if (log.isDebugEnabled()) {
                    log.debug((Object)"tx update:\n\tsql:{}\n\targs:{}", new Object[]{ql, args.toString()});
                }
                this.rollback(r.cause(), (Handler<AsyncResult<Void>>)((Handler)rb -> handler.handle((Object)Future.failedFuture((Throwable)rb.cause()))));
                return;
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)"tx update:\n\tsql:{}\n\targs:{}\n\tupdated:{}", new Object[]{ql, args.toString(), ((RowSet)r.result()).rowCount()});
            }
            handler.handle((Object)Future.succeededFuture((Object)((RowSet)r.result()).rowCount()));
        });
    }

    public void updateBatch(String ql, List<Tuple> args, Handler<AsyncResult<Integer>> handler) {
        this.tx.preparedBatch(ql, args, r -> {
            if (r.failed()) {
                log.error((Object)"tx update batch failed", r.cause());
                if (log.isDebugEnabled()) {
                    log.debug((Object)"tx update batch:\n\tsql:{}\n\targs:{}", new Object[]{ql, args.toString()});
                }
                this.rollback(r.cause(), (Handler<AsyncResult<Void>>)((Handler)rb -> handler.handle((Object)Future.failedFuture((Throwable)rb.cause()))));
                return;
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)"tx update batch:\n\tsql:{}\n\targs:{}\n\tupdated:{}", new Object[]{ql, args.toString(), ((RowSet)r.result()).rowCount()});
            }
            handler.handle((Object)Future.succeededFuture((Object)((RowSet)r.result()).rowCount()));
        });
    }

    public void update(ExecBuilder builder, Handler<AsyncResult<Integer>> handler) {
        this.update(builder.query(), builder.args(), handler);
    }

    public void updateBatch(ExecBatchBuilder builder, Handler<AsyncResult<Integer>> handler) {
        this.updateBatch(builder.query(), builder.args(), handler);
    }
}

