/*
 * Decompiled with CFR 0.152.
 */
package org.pharosnet.vertx.pg.dal.core.convert;

import io.vertx.core.json.JsonObject;
import io.vertx.sqlclient.Row;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.OffsetDateTime;
import java.time.OffsetTime;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import org.pharosnet.vertx.pg.dal.core.convert.RowConvert;

public class JsonObjectRowConvert
implements RowConvert<JsonObject> {
    @Override
    public JsonObject convert(Row row) {
        JsonObject jsonObject = new JsonObject();
        int size = row.size();
        for (int i = 0; i < size; ++i) {
            Comparable<OffsetDateTime> v;
            String column = row.getColumnName(i);
            Object value = row.getValue(i);
            if (value instanceof OffsetDateTime) {
                v = (OffsetDateTime)value;
                jsonObject.put(column, ((OffsetDateTime)v).toInstant());
                continue;
            }
            if (value instanceof OffsetTime) {
                v = (OffsetTime)value;
                jsonObject.put(column, ((OffsetTime)v).format(DateTimeFormatter.ISO_OFFSET_TIME));
                continue;
            }
            if (value instanceof LocalDateTime) {
                v = (LocalDateTime)value;
                jsonObject.put(column, ZonedDateTime.of((LocalDateTime)v, ZoneId.systemDefault()).toInstant());
                continue;
            }
            if (value instanceof LocalDate) {
                v = (LocalDate)value;
                jsonObject.put(column, ZonedDateTime.of(((LocalDate)v).atTime(0, 0, 0), ZoneId.systemDefault()).toInstant());
                continue;
            }
            jsonObject.put(column, value);
        }
        return jsonObject;
    }
}

