/*
 * Decompiled with CFR 0.152.
 */
package org.pharosnet.vertx.pg.dal.gen;

import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.processing.AbstractProcessor;
import javax.annotation.processing.Filer;
import javax.annotation.processing.Messager;
import javax.annotation.processing.ProcessingEnvironment;
import javax.annotation.processing.RoundEnvironment;
import javax.annotation.processing.SupportedAnnotationTypes;
import javax.annotation.processing.SupportedSourceVersion;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.TypeElement;
import javax.lang.model.util.Elements;
import javax.tools.Diagnostic;
import org.pharosnet.vertx.pg.dal.core.annotations.Dal;
import org.pharosnet.vertx.pg.dal.core.annotations.Table;
import org.pharosnet.vertx.pg.dal.gen.dal.DalGenerator;
import org.pharosnet.vertx.pg.dal.gen.table.TableGenerator;

@SupportedAnnotationTypes(value={"org.pharosnet.vertx.pg.dal.core.annotations.Table", "org.pharosnet.vertx.pg.dal.core.annotations.Dal"})
@SupportedSourceVersion(value=SourceVersion.RELEASE_11)
public class PgCodeGenProcessor
extends AbstractProcessor {
    private Messager messager;
    private Elements elementUtils;
    private Filer filer;

    @Override
    public synchronized void init(ProcessingEnvironment processingEnv) {
        super.init(processingEnv);
        this.elementUtils = processingEnv.getElementUtils();
        this.filer = processingEnv.getFiler();
        this.messager = processingEnv.getMessager();
    }

    @Override
    public boolean process(Set<? extends TypeElement> annotations, RoundEnvironment roundEnv) {
        return this.generateTable(roundEnv) && this.generateDAL(roundEnv);
    }

    private boolean generateTable(RoundEnvironment roundEnv) {
        List tableGenerators = roundEnv.getElementsAnnotatedWith(Table.class).stream().map(e -> new TableGenerator().load(this.elementUtils, (TypeElement)e)).collect(Collectors.toList());
        for (TableGenerator generator : tableGenerators) {
            try {
                generator.generate(this.filer);
            }
            catch (Exception cause) {
                cause.printStackTrace();
                this.messager.printMessage(Diagnostic.Kind.ERROR, cause.getMessage());
                return false;
            }
        }
        return true;
    }

    private boolean generateDAL(RoundEnvironment roundEnv) {
        List dalGenerators = roundEnv.getElementsAnnotatedWith(Dal.class).stream().map(e -> new DalGenerator().load(this.elementUtils, (TypeElement)e)).collect(Collectors.toList());
        for (DalGenerator generator : dalGenerators) {
            try {
                generator.generate(this.filer);
            }
            catch (Exception cause) {
                cause.printStackTrace();
                this.messager.printMessage(Diagnostic.Kind.ERROR, cause.getMessage());
                return false;
            }
        }
        return true;
    }
}

