/*
 * Decompiled with CFR 0.152.
 */
package org.pharosnet.vertx.pg.dal.gen.table;

import java.util.ArrayList;
import java.util.List;
import javax.annotation.processing.Filer;
import javax.lang.model.element.Element;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.Elements;
import org.pharosnet.vertx.pg.dal.core.annotations.Column;
import org.pharosnet.vertx.pg.dal.core.annotations.ColumnKind;
import org.pharosnet.vertx.pg.dal.core.annotations.Table;
import org.pharosnet.vertx.pg.dal.core.annotations.TableKind;
import org.pharosnet.vertx.pg.dal.gen.SourceGenerator;
import org.pharosnet.vertx.pg.dal.gen.table.GenerateDelete;
import org.pharosnet.vertx.pg.dal.gen.table.GenerateDeleteForce;
import org.pharosnet.vertx.pg.dal.gen.table.GenerateInsert;
import org.pharosnet.vertx.pg.dal.gen.table.GenerateRowConvert;
import org.pharosnet.vertx.pg.dal.gen.table.GenerateUpdate;
import org.pharosnet.vertx.pg.dal.gen.table.RowField;

public class TableGenerator
implements SourceGenerator {
    private String pkg;
    private String name;
    private TypeMirror typeMirror;
    private TableKind tableKind;
    private String schemaName;
    private String tableName;
    private List<RowField> ids = new ArrayList<RowField>();
    private RowField createBy;
    private RowField createBY;
    private RowField createAT;
    private RowField modifyBy;
    private RowField modifyAt;
    private RowField deleteBy;
    private RowField deleteAt;
    private RowField version;
    private List<RowField> columns = new ArrayList<RowField>();

    @Override
    public TableGenerator load(Elements elementUtils, TypeElement typeElement) {
        this.pkg = elementUtils.getPackageOf(typeElement).getQualifiedName().toString();
        this.name = typeElement.getSimpleName().toString();
        this.typeMirror = typeElement.asType();
        Table tableAnnotation = typeElement.getAnnotation(Table.class);
        this.tableKind = tableAnnotation.kind();
        this.tableName = tableAnnotation.name().strip();
        this.schemaName = tableAnnotation.schema().strip();
        if (!typeElement.getSuperclass().toString().equals("java.lang.Object")) {
            TypeElement superRow = elementUtils.getTypeElement(typeElement.getSuperclass().toString());
            this.loadColumns(superRow.getEnclosedElements());
        }
        this.loadColumns(typeElement.getEnclosedElements());
        return this;
    }

    private void loadColumns(List<? extends Element> enclosedElements) {
        for (Element element : enclosedElements) {
            VariableElement variableElement;
            Column column;
            if (!(element instanceof VariableElement) || (column = (variableElement = (VariableElement)element).getAnnotation(Column.class)) == null) continue;
            RowField rowField = new RowField();
            rowField.setColumn(column.name());
            rowField.setName(variableElement.getSimpleName().toString());
            rowField.setType(variableElement.asType());
            if (column.kind().equals((Object)ColumnKind.ID)) {
                this.ids.add(rowField);
                continue;
            }
            if (column.kind().equals((Object)ColumnKind.NORMAL)) {
                this.columns.add(rowField);
                continue;
            }
            if (column.kind().equals((Object)ColumnKind.CREATE_BY)) {
                this.createBY = rowField;
                continue;
            }
            if (column.kind().equals((Object)ColumnKind.CREATE_AT)) {
                this.createAT = rowField;
                continue;
            }
            if (column.kind().equals((Object)ColumnKind.MODIFY_BY)) {
                this.modifyBy = rowField;
                continue;
            }
            if (column.kind().equals((Object)ColumnKind.MODIFY_AT)) {
                this.modifyAt = rowField;
                continue;
            }
            if (column.kind().equals((Object)ColumnKind.DELETE_BY)) {
                this.deleteBy = rowField;
                continue;
            }
            if (column.kind().equals((Object)ColumnKind.DELETE_AT)) {
                this.deleteAt = rowField;
                continue;
            }
            if (!column.kind().equals((Object)ColumnKind.VERSION)) continue;
            this.version = rowField;
        }
    }

    @Override
    public TableGenerator generate(Filer filer) throws Exception {
        this.generateRowConvert(filer);
        if (this.tableKind.equals((Object)TableKind.TABLE)) {
            this.generateInsertExecBuilder(filer);
            this.generateInsertBatchExecBuilder(filer);
            this.generateUpdateExecBuilder(filer);
            this.generateUpdateBatchExecBuilder(filer);
            this.generateDeleteExecBuilder(filer);
            this.generateDeleteBatchExecBuilder(filer);
            this.generateDeleteForceExecBuilder(filer);
            this.generateDeleteForceBatchExecBuilder(filer);
        }
        return this;
    }

    private void generateRowConvert(Filer filer) throws Exception {
        GenerateRowConvert.generate(filer, this);
    }

    private void generateInsertExecBuilder(Filer filer) throws Exception {
        GenerateInsert.generate(filer, this);
    }

    private void generateUpdateExecBuilder(Filer filer) throws Exception {
        GenerateUpdate.generate(filer, this);
    }

    private void generateDeleteExecBuilder(Filer filer) throws Exception {
        GenerateDelete.generate(filer, this);
    }

    private void generateDeleteForceExecBuilder(Filer filer) throws Exception {
        GenerateDeleteForce.generate(filer, this);
    }

    private void generateInsertBatchExecBuilder(Filer filer) throws Exception {
        GenerateInsert.generateBatch(filer, this);
    }

    private void generateUpdateBatchExecBuilder(Filer filer) throws Exception {
        GenerateUpdate.generateBatch(filer, this);
    }

    private void generateDeleteBatchExecBuilder(Filer filer) throws Exception {
        GenerateDelete.generateBatch(filer, this);
    }

    private void generateDeleteForceBatchExecBuilder(Filer filer) throws Exception {
        GenerateDeleteForce.generateBatch(filer, this);
    }

    public String getPkg() {
        return this.pkg;
    }

    public void setPkg(String pkg) {
        this.pkg = pkg;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public TableKind getTableKind() {
        return this.tableKind;
    }

    public void setTableKind(TableKind tableKind) {
        this.tableKind = tableKind;
    }

    public String getSchemaName() {
        return this.schemaName;
    }

    public void setSchemaName(String schemaName) {
        this.schemaName = schemaName;
    }

    public String getTableName() {
        return this.tableName;
    }

    public void setTableName(String tableName) {
        this.tableName = tableName;
    }

    public List<RowField> getIds() {
        return this.ids;
    }

    public void setIds(List<RowField> ids) {
        this.ids = ids;
    }

    public RowField getCreateBy() {
        return this.createBy;
    }

    public void setCreateBy(RowField createBy) {
        this.createBy = createBy;
    }

    public RowField getCreateBY() {
        return this.createBY;
    }

    public void setCreateBY(RowField createBY) {
        this.createBY = createBY;
    }

    public RowField getCreateAT() {
        return this.createAT;
    }

    public void setCreateAT(RowField createAT) {
        this.createAT = createAT;
    }

    public RowField getModifyBy() {
        return this.modifyBy;
    }

    public void setModifyBy(RowField modifyBy) {
        this.modifyBy = modifyBy;
    }

    public RowField getModifyAt() {
        return this.modifyAt;
    }

    public void setModifyAt(RowField modifyAt) {
        this.modifyAt = modifyAt;
    }

    public RowField getDeleteBy() {
        return this.deleteBy;
    }

    public void setDeleteBy(RowField deleteBy) {
        this.deleteBy = deleteBy;
    }

    public RowField getDeleteAt() {
        return this.deleteAt;
    }

    public void setDeleteAt(RowField deleteAt) {
        this.deleteAt = deleteAt;
    }

    public RowField getVersion() {
        return this.version;
    }

    public void setVersion(RowField version) {
        this.version = version;
    }

    public List<RowField> getColumns() {
        return this.columns;
    }

    public void setColumns(List<RowField> columns) {
        this.columns = columns;
    }

    public TypeMirror getTypeMirror() {
        return this.typeMirror;
    }

    public void setTypeMirror(TypeMirror typeMirror) {
        this.typeMirror = typeMirror;
    }
}

