/*
 * Decompiled with CFR 0.152.
 */
package org.pharosnet.vertx.pg.dal.gen.table;

import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.FieldSpec;
import com.squareup.javapoet.JavaFile;
import com.squareup.javapoet.MethodSpec;
import com.squareup.javapoet.ParameterizedTypeName;
import com.squareup.javapoet.TypeName;
import com.squareup.javapoet.TypeSpec;
import javax.annotation.processing.Filer;
import javax.lang.model.element.Modifier;
import javax.lang.model.type.TypeMirror;
import org.pharosnet.vertx.pg.dal.gen.commons.StringUtils;
import org.pharosnet.vertx.pg.dal.gen.table.RowField;
import org.pharosnet.vertx.pg.dal.gen.table.TableGenerator;

public class GenerateDeleteForce {
    static void generate(Filer filer, TableGenerator tableGenerator) throws Exception {
        if (tableGenerator.getIds().isEmpty()) {
            return;
        }
        String pkg = tableGenerator.getPkg();
        String className = tableGenerator.getName();
        String newClassName = String.format("%sDeleteForceBuilder", className);
        TypeName rowType = TypeName.get((TypeMirror)tableGenerator.getTypeMirror());
        StringBuilder buildTuples = new StringBuilder();
        int argp = 1;
        StringBuilder sb = new StringBuilder();
        sb.append("DELETE FROM ");
        if (tableGenerator.getSchemaName().length() > 0) {
            sb.append("\"").append(tableGenerator.getSchemaName()).append("\".");
        }
        sb.append("\"").append(tableGenerator.getTableName()).append("\" WHERE ");
        StringBuilder ids = new StringBuilder();
        for (RowField rowField : tableGenerator.getIds()) {
            ids.append("AND ").append("\"").append(rowField.getColumn()).append(String.format("\" = $%d  ", argp));
            ++argp;
            buildTuples.append(", ");
            buildTuples.append("row.get").append(StringUtils.toUpperCaseFirstOne(rowField.getName())).append("()");
        }
        String idCond = ids.toString().substring(4);
        sb.append(idCond);
        if (tableGenerator.getVersion() != null) {
            sb.append("AND ").append("\"").append(tableGenerator.getVersion().getColumn()).append(String.format("\" = $%d  ", argp));
            buildTuples.append(", ");
            buildTuples.append("row.get").append(StringUtils.toUpperCaseFirstOne(tableGenerator.getVersion().getName())).append("()");
        }
        String sql = sb.toString();
        ClassName stringClassName = ClassName.get((String)"java.lang", (String)"String", (String[])new String[0]);
        FieldSpec.Builder staticSqlField = FieldSpec.builder((TypeName)stringClassName, (String)"sql", (Modifier[])new Modifier[]{Modifier.PUBLIC, Modifier.STATIC, Modifier.FINAL}).initializer("$S", new Object[]{sql});
        ClassName tupleClassName = ClassName.get((String)"io.vertx.sqlclient", (String)"Tuple", (String[])new String[0]);
        FieldSpec.Builder argField = FieldSpec.builder((TypeName)tupleClassName, (String)"args", (Modifier[])new Modifier[]{Modifier.PRIVATE});
        MethodSpec.Builder queryMethod = MethodSpec.methodBuilder((String)"query").addModifiers(new Modifier[]{Modifier.PUBLIC}).returns((TypeName)stringClassName).addStatement("return sql", new Object[0]);
        MethodSpec.Builder argsMethod = MethodSpec.methodBuilder((String)"args").addModifiers(new Modifier[]{Modifier.PUBLIC}).returns((TypeName)tupleClassName).addStatement("return args", new Object[0]);
        ClassName rowClassName = ClassName.get((String)pkg, (String)className, (String[])new String[0]);
        ClassName buildClassName = ClassName.get((String)"org.pharosnet.vertx.pg.dal.core", (String)"ExecBuilder", (String[])new String[0]);
        MethodSpec.Builder buildMethod = MethodSpec.methodBuilder((String)"build").addModifiers(new Modifier[]{Modifier.PUBLIC}).returns((TypeName)buildClassName).addParameter((TypeName)rowClassName, "row", new Modifier[0]).addStatement(String.format("this.args = $T.of(%s)", buildTuples.toString().substring(2)), new Object[]{tupleClassName}).addStatement("return this", new Object[0]);
        ClassName superClassName = ClassName.get((String)"org.pharosnet.vertx.pg.dal.core", (String)"ExecBuilder", (String[])new String[0]);
        ParameterizedTypeName superClass = ParameterizedTypeName.get((ClassName)superClassName, (TypeName[])new TypeName[]{rowType});
        TypeSpec typeBuilder = TypeSpec.classBuilder((String)newClassName).addModifiers(new Modifier[]{Modifier.PUBLIC}).addSuperinterface((TypeName)superClass).addField(staticSqlField.build()).addField(argField.build()).addMethod(queryMethod.build()).addMethod(argsMethod.build()).addMethod(buildMethod.build()).build();
        JavaFile javaFile = JavaFile.builder((String)pkg, (TypeSpec)typeBuilder).addFileComment("Generated code from Vertx Pg DAL. Do not modify!", new Object[0]).build();
        javaFile.writeTo(filer);
    }

    static void generateBatch(Filer filer, TableGenerator tableGenerator) throws Exception {
        if (tableGenerator.getIds().isEmpty()) {
            return;
        }
        String pkg = tableGenerator.getPkg();
        String className = tableGenerator.getName();
        String newClassName = String.format("%sDeleteForceBatchBuilder", className);
        StringBuilder buildTuples = new StringBuilder();
        TypeName rowType = TypeName.get((TypeMirror)tableGenerator.getTypeMirror());
        int argp = 1;
        StringBuilder sb = new StringBuilder();
        sb.append("DELETE FROM ");
        if (tableGenerator.getSchemaName().length() > 0) {
            sb.append("\"").append(tableGenerator.getSchemaName()).append("\".");
        }
        sb.append("\"").append(tableGenerator.getTableName()).append("\" WHERE ");
        StringBuilder ids = new StringBuilder();
        for (RowField rowField : tableGenerator.getIds()) {
            ids.append("AND ").append("\"").append(rowField.getColumn()).append(String.format("\" = $%d  ", argp));
            ++argp;
            buildTuples.append(", ");
            buildTuples.append("row.get").append(StringUtils.toUpperCaseFirstOne(rowField.getName())).append("()");
        }
        String idCond = ids.toString().substring(4);
        sb.append(idCond);
        if (tableGenerator.getVersion() != null) {
            sb.append("AND ").append("\"").append(tableGenerator.getVersion().getColumn()).append(String.format("\" = $%d  ", argp));
            buildTuples.append(", ");
            buildTuples.append("row.get").append(StringUtils.toUpperCaseFirstOne(tableGenerator.getVersion().getName())).append("()");
        }
        String sql = sb.toString();
        ClassName stringClassName = ClassName.get((String)"java.lang", (String)"String", (String[])new String[0]);
        FieldSpec.Builder staticSqlField = FieldSpec.builder((TypeName)stringClassName, (String)"sql", (Modifier[])new Modifier[]{Modifier.PUBLIC, Modifier.STATIC, Modifier.FINAL}).initializer("$S", new Object[]{sql});
        ClassName tupleClassName = ClassName.get((String)"io.vertx.sqlclient", (String)"Tuple", (String[])new String[0]);
        ClassName listClassName = ClassName.get((String)"java.util", (String)"List", (String[])new String[0]);
        ParameterizedTypeName listOfTuple = ParameterizedTypeName.get((ClassName)listClassName, (TypeName[])new TypeName[]{tupleClassName});
        FieldSpec.Builder argField = FieldSpec.builder((TypeName)listOfTuple, (String)"args", (Modifier[])new Modifier[]{Modifier.PRIVATE});
        MethodSpec.Builder queryMethod = MethodSpec.methodBuilder((String)"query").addModifiers(new Modifier[]{Modifier.PUBLIC}).returns((TypeName)stringClassName).addStatement("return sql", new Object[0]);
        MethodSpec.Builder argsMethod = MethodSpec.methodBuilder((String)"args").addModifiers(new Modifier[]{Modifier.PUBLIC}).returns((TypeName)listOfTuple).addStatement("return args", new Object[0]);
        ClassName buildClassName = ClassName.get((String)"org.pharosnet.vertx.pg.dal.core", (String)"ExecBatchBuilder", (String[])new String[0]);
        ParameterizedTypeName buildOfRowClassName = ParameterizedTypeName.get((ClassName)buildClassName, (TypeName[])new TypeName[]{rowType});
        ParameterizedTypeName listOfRowClassName = ParameterizedTypeName.get((ClassName)listClassName, (TypeName[])new TypeName[]{rowType});
        ClassName collectorsClassName = ClassName.get((String)"java.util.stream", (String)"Collectors", (String[])new String[0]);
        MethodSpec.Builder buildMethod = MethodSpec.methodBuilder((String)"build").addModifiers(new Modifier[]{Modifier.PUBLIC}).returns((TypeName)buildOfRowClassName).addParameter((TypeName)listOfRowClassName, "rows", new Modifier[0]).addStatement(String.format("this.args = rows.stream().map(row -> $T.of(%s)).collect($T.toList())", buildTuples.toString().substring(2)), new Object[]{tupleClassName, collectorsClassName}).addStatement("return this", new Object[0]);
        ClassName superClassName = ClassName.get((String)"org.pharosnet.vertx.pg.dal.core", (String)"ExecBatchBuilder", (String[])new String[0]);
        ParameterizedTypeName superClass = ParameterizedTypeName.get((ClassName)superClassName, (TypeName[])new TypeName[]{rowType});
        TypeSpec typeBuilder = TypeSpec.classBuilder((String)newClassName).addModifiers(new Modifier[]{Modifier.PUBLIC}).addSuperinterface((TypeName)superClass).addField(staticSqlField.build()).addField(argField.build()).addMethod(queryMethod.build()).addMethod(argsMethod.build()).addMethod(buildMethod.build()).build();
        JavaFile javaFile = JavaFile.builder((String)pkg, (TypeSpec)typeBuilder).addFileComment("Generated code from Vertx Pg DAL. Do not modify!", new Object[0]).build();
        javaFile.writeTo(filer);
    }
}

