/*
 * Decompiled with CFR 0.152.
 */
package org.pharosnet.vertx.pg.dal.gen.table;

import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.FieldSpec;
import com.squareup.javapoet.JavaFile;
import com.squareup.javapoet.MethodSpec;
import com.squareup.javapoet.TypeName;
import com.squareup.javapoet.TypeSpec;
import io.vertx.sqlclient.Row;
import javax.annotation.processing.Filer;
import javax.lang.model.element.Modifier;
import javax.lang.model.type.TypeMirror;
import org.pharosnet.vertx.pg.dal.gen.commons.StringUtils;
import org.pharosnet.vertx.pg.dal.gen.table.RowField;
import org.pharosnet.vertx.pg.dal.gen.table.TableGenerator;

public class GenerateRowConvert {
    static void generate(Filer filer, TableGenerator tableGenerator) throws Exception {
        String pkg = tableGenerator.getPkg();
        String className = tableGenerator.getName();
        String newClassName = String.format("%sConvert", className);
        ClassName newClass = ClassName.get((String)pkg, (String)newClassName, (String[])new String[0]);
        FieldSpec.Builder staticField = FieldSpec.builder((TypeName)newClass, (String)"convert", (Modifier[])new Modifier[]{Modifier.PRIVATE, Modifier.STATIC, Modifier.FINAL}).initializer("new " + newClassName + "()", new Object[0]);
        MethodSpec.Builder staticFunc = MethodSpec.methodBuilder((String)"convert").addModifiers(new Modifier[]{Modifier.PUBLIC}).addModifiers(new Modifier[]{Modifier.STATIC}).returns((TypeName)newClass).addStatement("return convert", new Object[0]);
        MethodSpec.Builder convertFunc = MethodSpec.methodBuilder((String)"convert").addModifiers(new Modifier[]{Modifier.PUBLIC}).addParameter((TypeName)ClassName.get(Row.class), "row", new Modifier[0]).returns(TypeName.get((TypeMirror)tableGenerator.getTypeMirror())).addStatement("$T obj = new $T()", new Object[]{TypeName.get((TypeMirror)tableGenerator.getTypeMirror()), TypeName.get((TypeMirror)tableGenerator.getTypeMirror())});
        for (RowField rowField : tableGenerator.getIds()) {
            GenerateRowConvert.buildRowFieldCode(convertFunc, rowField);
        }
        GenerateRowConvert.buildRowFieldCode(convertFunc, tableGenerator.getCreateBY());
        GenerateRowConvert.buildRowFieldCode(convertFunc, tableGenerator.getCreateAT());
        GenerateRowConvert.buildRowFieldCode(convertFunc, tableGenerator.getModifyBy());
        GenerateRowConvert.buildRowFieldCode(convertFunc, tableGenerator.getModifyAt());
        GenerateRowConvert.buildRowFieldCode(convertFunc, tableGenerator.getDeleteBy());
        GenerateRowConvert.buildRowFieldCode(convertFunc, tableGenerator.getDeleteAt());
        GenerateRowConvert.buildRowFieldCode(convertFunc, tableGenerator.getVersion());
        for (RowField rowField : tableGenerator.getColumns()) {
            GenerateRowConvert.buildRowFieldCode(convertFunc, rowField);
        }
        convertFunc.addStatement("return obj", new Object[0]);
        TypeSpec typeBuilder = TypeSpec.classBuilder((String)newClassName).addModifiers(new Modifier[]{Modifier.PUBLIC}).addField(staticField.build()).addMethod(staticFunc.build()).addMethod(convertFunc.build()).build();
        JavaFile javaFile = JavaFile.builder((String)pkg, (TypeSpec)typeBuilder).addFileComment("Generated code from Vertx Pg DAL. Do not modify!", new Object[0]).build();
        javaFile.writeTo(filer);
    }

    private static void buildRowFieldCode(MethodSpec.Builder methodBuilder, RowField rowField) {
        if (rowField == null) {
            return;
        }
        String typeString = rowField.getType().toString();
        if (typeString.equals("java.lang.String")) {
            methodBuilder.addStatement("obj.set" + StringUtils.toUpperCaseFirstOne(rowField.getName()) + "(row.getString(\"" + rowField.getColumn() + "\"))", new Object[0]);
        } else if (typeString.equals("java.lang.Integer")) {
            methodBuilder.addStatement("obj.set" + StringUtils.toUpperCaseFirstOne(rowField.getName()) + "(row.getInteger(\"" + rowField.getColumn() + "\"))", new Object[0]);
        } else if (typeString.equals("java.lang.Float")) {
            methodBuilder.addStatement("obj.set" + StringUtils.toUpperCaseFirstOne(rowField.getName()) + "(row.getFloat(\"" + rowField.getColumn() + "\"))", new Object[0]);
        } else if (typeString.equals("java.lang.Double")) {
            methodBuilder.addStatement("obj.set" + StringUtils.toUpperCaseFirstOne(rowField.getName()) + "(row.getDouble(\"" + rowField.getColumn() + "\"))", new Object[0]);
        } else if (typeString.equals("java.lang.Long")) {
            methodBuilder.addStatement("obj.set" + StringUtils.toUpperCaseFirstOne(rowField.getName()) + "(row.getLong(\"" + rowField.getColumn() + "\"))", new Object[0]);
        } else if (typeString.equals("java.math.BigDecimal")) {
            methodBuilder.addStatement("obj.set" + StringUtils.toUpperCaseFirstOne(rowField.getName()) + "(row.get$T(\"" + rowField.getColumn() + "\"))", new Object[]{TypeName.get((TypeMirror)rowField.getType())});
        } else if (typeString.equals("java.lang.Boolean")) {
            methodBuilder.addStatement("obj.set" + StringUtils.toUpperCaseFirstOne(rowField.getName()) + "(row.getBoolean(\"" + rowField.getColumn() + "\"))", new Object[0]);
        } else if (typeString.equals("java.lang.Short")) {
            methodBuilder.addStatement("obj.set" + StringUtils.toUpperCaseFirstOne(rowField.getName()) + "(row.getShort(\"" + rowField.getColumn() + "\"))", new Object[0]);
        } else if (typeString.equals("java.util.UUID")) {
            methodBuilder.addStatement("obj.set" + StringUtils.toUpperCaseFirstOne(rowField.getName()) + "(row.get$T(\"" + rowField.getColumn() + "\"))", new Object[]{TypeName.get((TypeMirror)rowField.getType())});
        } else if (typeString.equals("java.time.OffsetDateTime")) {
            methodBuilder.addStatement("obj.set" + StringUtils.toUpperCaseFirstOne(rowField.getName()) + "(row.get$T(\"" + rowField.getColumn() + "\"))", new Object[]{TypeName.get((TypeMirror)rowField.getType())});
        } else if (typeString.equals("java.time.OffsetTime")) {
            methodBuilder.addStatement("obj.set" + StringUtils.toUpperCaseFirstOne(rowField.getName()) + "(row.get$T(\"" + rowField.getColumn() + "\"))", new Object[]{TypeName.get((TypeMirror)rowField.getType())});
        } else if (typeString.equals("java.time.LocalDateTime")) {
            methodBuilder.addStatement("obj.set" + StringUtils.toUpperCaseFirstOne(rowField.getName()) + "(row.get$T(\"" + rowField.getColumn() + "\"))", new Object[]{TypeName.get((TypeMirror)rowField.getType())});
        } else if (typeString.equals("java.time.LocalDate")) {
            methodBuilder.addStatement("obj.set" + StringUtils.toUpperCaseFirstOne(rowField.getName()) + "(row.get$T(\"" + rowField.getColumn() + "\"))", new Object[]{TypeName.get((TypeMirror)rowField.getType())});
        } else if (typeString.equals("io.vertx.core.json.JsonObject")) {
            methodBuilder.addStatement("obj.set" + StringUtils.toUpperCaseFirstOne(rowField.getName()) + "(($T) row.getValue(\"" + rowField.getColumn() + "\"))", new Object[]{TypeName.get((TypeMirror)rowField.getType())});
        } else if (typeString.equals("io.vertx.core.json.JsonArray")) {
            methodBuilder.addStatement("obj.set" + StringUtils.toUpperCaseFirstOne(rowField.getName()) + "(($T) row.getValue(\"" + rowField.getColumn() + "\"))", new Object[]{TypeName.get((TypeMirror)rowField.getType())});
        }
    }
}

