/*
 * Decompiled with CFR 0.152.
 */
package org.pharosnet.vertx.pg.dal.core;

import io.vertx.core.logging.Logger;
import io.vertx.core.logging.LoggerFactory;
import io.vertx.pgclient.PgPool;
import java.io.File;
import java.io.FileFilter;
import java.net.JarURLConnection;
import java.net.URL;
import java.util.Enumeration;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import org.pharosnet.vertx.pg.dal.core.PostgresDAL;
import org.pharosnet.vertx.pg.dal.core.annotations.Dal;

public class PostgresDALs {
    private static final Logger log = LoggerFactory.getLogger(PostgresDALs.class);
    private static Map<String, Object> dals = new ConcurrentHashMap<String, Object>();
    private static Lock lock = new ReentrantLock();

    public static void INIT(PgPool pgPool) {
        PostgresDAL.INTI(pgPool);
    }

    public static void INIT(PgPool pgPool, String basePackage) throws Exception {
        PostgresDAL.INTI(pgPool);
        Enumeration<URL> urlEnumeration = Thread.currentThread().getContextClassLoader().getResources(basePackage.replace(".", "/"));
        while (urlEnumeration.hasMoreElements()) {
            URL url = urlEnumeration.nextElement();
            if (url.getProtocol().equals("jar")) {
                PostgresDALs.scanPackage(url);
                continue;
            }
            File file = new File(url.toURI());
            if (!file.exists()) continue;
            PostgresDALs.scanPackage(basePackage, file);
        }
    }

    private static void scanPackage(String packageName, File currentFile) throws Exception {
        File[] fileList;
        for (File file : fileList = currentFile.listFiles(new FileFilter(){

            @Override
            public boolean accept(File pathname) {
                if (pathname.isDirectory()) {
                    return true;
                }
                return pathname.getName().endsWith(".class");
            }
        })) {
            if (file.isDirectory()) {
                PostgresDALs.scanPackage(packageName + "." + file.getName(), file);
                continue;
            }
            String fileName = file.getName().replace(".class", "");
            String className = packageName + "." + fileName;
            Class<?> clazz = Class.forName(className);
            if (!clazz.isInterface()) continue;
            PostgresDALs.newDAL(clazz);
        }
    }

    private static void scanPackage(URL url) throws Exception {
        JarURLConnection urlConnection = (JarURLConnection)url.openConnection();
        JarFile jarFile = urlConnection.getJarFile();
        Enumeration<JarEntry> jarEntries = jarFile.entries();
        while (jarEntries.hasMoreElements()) {
            String className;
            Class<?> clazz;
            JarEntry jarEntry = jarEntries.nextElement();
            String jarEntryName = jarEntry.getName();
            if (jarEntry.isDirectory() || !jarEntryName.endsWith(".class") || !(clazz = Class.forName(className = jarEntryName.replace(".class", "").replace("/", "."))).isInterface()) continue;
            PostgresDALs.newDAL(clazz);
        }
    }

    private static void newDAL(Class<?> clazz) throws Exception {
        if (!clazz.isAnnotationPresent(Dal.class)) {
            return;
        }
        String className = String.format("%sImpl", clazz.getName());
        if (dals.containsKey(className)) {
            return;
        }
        Class<?> implClass = PostgresDALs.class.getClassLoader().loadClass(className);
        Object impl = implClass.getConstructor(PgPool.class).newInstance(PostgresDAL.get().getClient());
        dals.put(className, impl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <R> R get(Class<R> clazz) {
        if (PostgresDAL.get() == null || PostgresDAL.get().getClient() == null) {
            log.warn((Object)"postgres dal get failed, cause PostgresDAL has no instance, please call PostgresDAL.INIT() first");
            return null;
        }
        String className = String.format("%sImpl", clazz.getName());
        lock.lock();
        if (dals.containsKey(className)) {
            lock.unlock();
            return (R)dals.get(className);
        }
        try {
            Class<?> implClass = PostgresDALs.class.getClassLoader().loadClass(className);
            Object impl = implClass.getConstructor(PgPool.class).newInstance(PostgresDAL.get().getClient());
            dals.put(className, impl);
            Object obj = impl;
            return (R)obj;
        }
        catch (Exception e) {
            log.error((Object)"get postgres dal failed", (Throwable)e);
            R r = null;
            return r;
        }
        finally {
            lock.unlock();
        }
    }
}

