/*
 * Decompiled with CFR 0.152.
 */
package org.pharosnet.vertx.pg.dal.gen.dal;

import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.FieldSpec;
import com.squareup.javapoet.JavaFile;
import com.squareup.javapoet.MethodSpec;
import com.squareup.javapoet.ParameterizedTypeName;
import com.squareup.javapoet.TypeName;
import com.squareup.javapoet.TypeSpec;
import io.vertx.pgclient.PgPool;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.annotation.processing.Filer;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.Elements;
import org.pharosnet.vertx.pg.dal.core.PostgresDAL;
import org.pharosnet.vertx.pg.dal.core.annotations.Arg;
import org.pharosnet.vertx.pg.dal.core.annotations.ArgKind;
import org.pharosnet.vertx.pg.dal.core.annotations.Query;
import org.pharosnet.vertx.pg.dal.gen.SourceGenerator;
import org.pharosnet.vertx.pg.dal.gen.commons.StringUtils;
import org.pharosnet.vertx.pg.dal.gen.dal.MethodParam;
import org.pharosnet.vertx.pg.dal.gen.dal.QueryArg;
import org.pharosnet.vertx.pg.dal.gen.dal.QueryHandler;
import org.pharosnet.vertx.pg.dal.gen.dal.QueryInterface;
import org.pharosnet.vertx.pg.dal.gen.dal.QueryKind;
import org.pharosnet.vertx.pg.dal.gen.dal.QueryMethod;

public class DalGenerator
implements SourceGenerator {
    private QueryInterface queryInterface;

    @Override
    public DalGenerator load(Elements elementUtils, TypeElement typeElement) {
        this.queryInterface = new QueryInterface();
        String pkg = elementUtils.getPackageOf(typeElement).getQualifiedName().toString();
        this.queryInterface.setPkg(pkg);
        String name = typeElement.getSimpleName().toString();
        this.queryInterface.setName(name + "Impl");
        this.queryInterface.setSuperClassName(ClassName.get((String)pkg, (String)name, (String[])new String[0]));
        List<? extends Element> elements = typeElement.getEnclosedElements();
        for (Element element : elements) {
            ExecutableElement funcElement;
            Query query;
            if (!(element instanceof ExecutableElement) || (query = (funcElement = (ExecutableElement)element).getAnnotation(Query.class)) == null) continue;
            String sql = query.value();
            QueryMethod queryMethod = new QueryMethod();
            queryMethod.setSql(sql);
            String funcName = funcElement.getSimpleName().toString();
            queryMethod.setName(funcName);
            List<? extends VariableElement> params = funcElement.getParameters();
            for (VariableElement variableElement : params) {
                Arg arg;
                String paramName = variableElement.getSimpleName().toString();
                TypeName paramTypeName = TypeName.get((TypeMirror)variableElement.asType());
                if (paramTypeName instanceof ParameterizedTypeName) {
                    ParameterizedTypeName parameterizedTypeName = (ParameterizedTypeName)paramTypeName;
                    if (parameterizedTypeName.rawType.toString().equals("io.vertx.core.Handler")) {
                        queryMethod.setHandler(new QueryHandler(paramName, parameterizedTypeName));
                    }
                }
                if ((arg = variableElement.getAnnotation(Arg.class)) == null) continue;
                if (arg.kind() == ArgKind.PLACEHOLDER) {
                    queryMethod.getPlaceholders().add(new QueryArg(paramName, 0, paramTypeName));
                } else {
                    int[] pos;
                    for (int p : pos = arg.value()) {
                        queryMethod.getArgs().add(new QueryArg(paramName, p, paramTypeName));
                    }
                }
                MethodParam methodParam = new MethodParam(paramName, paramTypeName);
                queryMethod.getParams().add(methodParam);
            }
            Collections.sort(queryMethod.getArgs());
            this.queryInterface.getMethods().add(queryMethod);
        }
        return this;
    }

    @Override
    public DalGenerator generate(Filer filer) throws Exception {
        ArrayList<FieldSpec.Builder> sqlFieldBuilders = new ArrayList<FieldSpec.Builder>();
        ArrayList<MethodSpec.Builder> methodBuilders = new ArrayList<MethodSpec.Builder>();
        for (QueryMethod queryMethod : this.queryInterface.getMethods()) {
            String sqlName = String.format("%sSQL", queryMethod.getName());
            ClassName stringClassName = ClassName.get((String)"java.lang", (String)"String", (String[])new String[0]);
            FieldSpec.Builder staticSqlField = FieldSpec.builder((TypeName)stringClassName, (String)sqlName, (Modifier[])new Modifier[]{Modifier.PRIVATE, Modifier.STATIC, Modifier.FINAL}).initializer("$S", new Object[]{queryMethod.getSql()});
            sqlFieldBuilders.add(staticSqlField);
            MethodSpec.Builder buildMethod = MethodSpec.methodBuilder((String)queryMethod.getName()).addModifiers(new Modifier[]{Modifier.PUBLIC}).returns(TypeName.VOID);
            Boolean hasQueryArgs = false;
            if (queryMethod.getParams() != null && !queryMethod.getParams().isEmpty()) {
                for (MethodParam methodParam : queryMethod.getParams()) {
                    buildMethod.addParameter(methodParam.getTypeName(), methodParam.getName(), new Modifier[0]);
                }
                hasQueryArgs = true;
            }
            if (queryMethod.getHandler() == null) {
                throw new IllegalAccessException("miss handler param");
            }
            buildMethod.addParameter((TypeName)queryMethod.getHandler().getTypeName(), queryMethod.getHandler().getName(), new Modifier[0]);
            String argsCode = "";
            if (!queryMethod.getParams().isEmpty()) {
                StringBuilder sb = new StringBuilder();
                for (QueryArg queryArg : queryMethod.getArgs()) {
                    sb.append(", ").append(queryArg.getName());
                }
                argsCode = sb.substring(2);
            }
            if (argsCode.length() > 0) {
                ClassName tupleClassName = ClassName.get((String)"io.vertx.sqlclient", (String)"Tuple", (String[])new String[0]);
                buildMethod.addStatement(String.format("$T args = $T.of(%s)", argsCode), new Object[]{tupleClassName, tupleClassName});
            }
            QueryKind queryKind = new QueryKind();
            this.loadQueryKind(queryKind, queryMethod.getHandler().getTypeName());
            ClassName convertClassName = null;
            convertClassName = queryKind.getName().isBoxedPrimitive() ? ClassName.get((String)"org.pharosnet.vertx.pg.dal.core.convert", (String)String.format("%sRowConvert", queryKind.getName().simpleName()), (String[])new String[0]) : (queryKind.getName().simpleName().equals("JsonObject") ? ClassName.get((String)"org.pharosnet.vertx.pg.dal.core.convert", (String)"JsonObjectRowConvert", (String[])new String[0]) : ClassName.get((String)queryKind.getName().packageName(), (String)(queryKind.getName().simpleName() + "Convert"), (String[])new String[0]));
            String queryMethodArgs = "";
            if (hasQueryArgs.booleanValue()) {
                queryMethodArgs = " args,";
            }
            if (!queryMethod.getPlaceholders().isEmpty()) {
                for (QueryArg phArg : queryMethod.getPlaceholders()) {
                    buildMethod.addCode("String sql = \"\";\n", new Object[0]);
                    String sbName = "sb" + StringUtils.toUpperCaseFirstOne(phArg.getName());
                    buildMethod.addStatement(String.format("StringBuilder %s = new StringBuilder()", sbName), new Object[]{ClassName.get(StringBuilder.class)});
                    ParameterizedTypeName phArgTypeName = (ParameterizedTypeName)phArg.getTypeName();
                    StringBuilder codeB = new StringBuilder();
                    if (((TypeName)phArgTypeName.typeArguments.get(0)).toString().equals("java.lang.String")) {
                        codeB.append("for (String item : ").append(phArg.getName()).append(") {\n");
                        codeB.append("\t").append(sbName).append(".append(\", '\").append(item).append(\"'\");\n");
                    } else {
                        String argTypeName = ((ClassName)phArgTypeName.typeArguments.get(0)).simpleName();
                        codeB.append("for (").append(argTypeName).append(" item : ").append(phArg.getName()).append(") {\n");
                        codeB.append("\t").append(sbName).append(".append(\", \").append(item);\n");
                    }
                    codeB.append("}\n");
                    codeB.append("String ").append("sql").append(StringUtils.toUpperCaseFirstOne(phArg.getName())).append(" = ").append(sbName).append(".toString();\n");
                    codeB.append("if (").append("sql").append(StringUtils.toUpperCaseFirstOne(phArg.getName())).append(".length() > 2) {\n");
                    codeB.append("\t").append("sql").append(StringUtils.toUpperCaseFirstOne(phArg.getName())).append(" = ").append("sql").append(StringUtils.toUpperCaseFirstOne(phArg.getName())).append(".substring(2);\n");
                    codeB.append("}\n");
                    codeB.append("sql = ").append(sqlName).append(".replaceAll(\"%").append(phArg.getName()).append("\", ").append("sql").append(StringUtils.toUpperCaseFirstOne(phArg.getName())).append(");\n");
                    buildMethod.addCode(codeB.toString(), new Object[0]);
                }
                if (queryKind.getOne().booleanValue()) {
                    buildMethod.addStatement(String.format("this.queryOne(sql,%s $T.convert()::convert, %s)", queryMethodArgs, queryMethod.getHandler().getName()), new Object[]{convertClassName});
                } else {
                    buildMethod.addStatement(String.format("this.query(sql,%s $T.convert()::convert, %s)", queryMethodArgs, queryMethod.getHandler().getName()), new Object[]{convertClassName});
                }
            } else if (queryKind.getOne().booleanValue()) {
                buildMethod.addStatement(String.format("this.queryOne(%s,%s $T.convert()::convert, %s)", sqlName, queryMethodArgs, queryMethod.getHandler().getName()), new Object[]{convertClassName});
            } else {
                buildMethod.addStatement(String.format("this.query(%s,%s $T.convert()::convert, %s)", sqlName, queryMethodArgs, queryMethod.getHandler().getName()), new Object[]{convertClassName});
            }
            buildMethod.addStatement("return", new Object[0]);
            methodBuilders.add(buildMethod);
        }
        if (sqlFieldBuilders.size() != methodBuilders.size() || methodBuilders.isEmpty()) {
            throw new IllegalAccessException("no code to be generated");
        }
        MethodSpec constructorBuilder = MethodSpec.constructorBuilder().addModifiers(new Modifier[]{Modifier.PUBLIC}).addParameter(PgPool.class, "client", new Modifier[0]).addStatement("super($N)", new Object[]{"client"}).build();
        TypeSpec.Builder typeBuilder = TypeSpec.classBuilder((String)this.queryInterface.getName()).addModifiers(new Modifier[]{Modifier.PUBLIC}).superclass(PostgresDAL.class).addSuperinterface((TypeName)this.queryInterface.getSuperClassName()).addMethod(constructorBuilder);
        int size = sqlFieldBuilders.size();
        for (int i = 0; i < size; ++i) {
            typeBuilder.addField(((FieldSpec.Builder)sqlFieldBuilders.get(i)).build());
            typeBuilder.addMethod(((MethodSpec.Builder)methodBuilders.get(i)).build());
        }
        JavaFile javaFile = JavaFile.builder((String)this.queryInterface.getPkg(), (TypeSpec)typeBuilder.build()).addFileComment("Generated code from Vertx Pg DAL. Do not modify!", new Object[0]).build();
        javaFile.writeTo(filer);
        return this;
    }

    private void loadQueryKind(QueryKind queryKind, ParameterizedTypeName typeName) {
        List typeArgNames = typeName.typeArguments;
        if (typeArgNames.isEmpty()) {
            return;
        }
        TypeName typeArgName = (TypeName)typeArgNames.get(0);
        if (typeName.rawType.toString().equals("java.util.stream.Stream")) {
            queryKind.setOne(false);
        }
        if (typeArgName instanceof ParameterizedTypeName) {
            this.loadQueryKind(queryKind, (ParameterizedTypeName)typeArgName);
        } else {
            queryKind.setName((ClassName)typeArgName);
        }
    }
}

