/*
 * Decompiled with CFR 0.152.
 */
package org.phenoscape.kb.ingest.xenbase;

import org.apache.commons.lang3.StringUtils;
import org.phenoscape.kb.ingest.util.OBOUtil$;
import org.phenoscape.kb.ingest.util.OntUtil$;
import org.phenoscape.kb.ingest.util.Vocab$;
import org.phenoscape.kb.ingest.xenbase.XenbaseExpressionToOWL$;
import org.phenoscape.kb.ingest.xenbase.XenbaseGenesToOWL$;
import org.phenoscape.scowl.converters.AnnotationValuer;
import org.phenoscape.scowl.package;
import org.phenoscape.scowl.package$;
import org.semanticweb.owlapi.model.IRI;
import org.semanticweb.owlapi.model.OWLAxiom;
import org.semanticweb.owlapi.model.OWLClass;
import org.semanticweb.owlapi.model.OWLClassExpression;
import org.semanticweb.owlapi.model.OWLEntity;
import org.semanticweb.owlapi.model.OWLIndividual;
import org.semanticweb.owlapi.model.OWLNamedIndividual;
import org.semanticweb.owlapi.model.OWLNamedObject;
import org.semanticweb.owlapi.model.OWLObjectPropertyExpression;
import scala.Array$;
import scala.Function1;
import scala.Predef$;
import scala.Serializable;
import scala.collection.Map;
import scala.collection.mutable.Map$;
import scala.collection.mutable.Set;
import scala.collection.mutable.Set$;
import scala.io.Source;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

public final class XenbaseExpressionToOWL$ {
    public static final XenbaseExpressionToOWL$ MODULE$;
    private final OWLNamedIndividual laevis;
    private final OWLNamedIndividual tropicalis;

    static {
        new XenbaseExpressionToOWL$();
    }

    public OWLNamedIndividual laevis() {
        return this.laevis;
    }

    public OWLNamedIndividual tropicalis() {
        return this.tropicalis;
    }

    public scala.collection.immutable.Set<OWLAxiom> convert(Source genepageMappingsFile, Source laevisExpressionFile, Source tropicalisExpressionFile) {
        Map<String, String> mappings = this.indexGenepageMappings(genepageMappingsFile);
        return (scala.collection.immutable.Set)this.convert(laevisExpressionFile, mappings, this.laevis()).$plus$plus(this.convert(tropicalisExpressionFile, mappings, this.tropicalis()));
    }

    /*
     * WARNING - void declaration
     */
    public Map<String, String> indexGenepageMappings(Source mappings) {
        void var2_2;
        scala.collection.mutable.Map index = Map$.MODULE$.empty();
        mappings.getLines().foreach((Function1)new Serializable(index){
            public static final long serialVersionUID = 0L;
            public final scala.collection.mutable.Map index$1;

            public final void apply(String mapping) {
                String[] items = mapping.split("\t", -1);
                String genepageID = StringUtils.stripToNull((String)items[0]);
                Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])items).drop(1)).filter((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final boolean apply(String x$1) {
                        return x$1.startsWith("XB-GENE");
                    }
                })).map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final String apply(String x$2) {
                        return x$2.trim();
                    }
                }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class)))).foreach((Function1)new Serializable(this, genepageID){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ anonfun.indexGenepageMappings.1 $outer;
                    private final String genepageID$1;

                    public final void apply(String geneID) {
                        this.$outer.index$1.update((Object)StringUtils.stripToNull((String)geneID), (Object)this.genepageID$1);
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                        this.genepageID$1 = genepageID$1;
                    }
                });
            }
            {
                this.index$1 = index$1;
            }
        });
        return var2_2;
    }

    public scala.collection.immutable.Set<OWLAxiom> convert(Source expressionData, Map<String, String> genepageMappings, OWLNamedIndividual species) {
        return (scala.collection.immutable.Set)expressionData.getLines().flatMap((Function1)new Serializable(genepageMappings, species){
            public static final long serialVersionUID = 0L;
            private final Map genepageMappings$1;
            private final OWLNamedIndividual species$1;

            public final scala.collection.immutable.Set<OWLAxiom> apply(String x$3) {
                return XenbaseExpressionToOWL$.MODULE$.translate(x$3, (Map<String, String>)this.genepageMappings$1, this.species$1);
            }
            {
                this.genepageMappings$1 = genepageMappings$1;
                this.species$1 = species$1;
            }
        }).toSet().$plus((Object)package.ScowlNamedObject$.MODULE$.Annotation$extension0(package$.MODULE$.ScowlNamedObject((OWLNamedObject)this.laevis()), Vocab$.MODULE$.rdfsLabel(), (Object)"Xenopus laevis", (AnnotationValuer)package$.MODULE$.StringLiterable())).$plus((Object)package.ScowlNamedObject$.MODULE$.Annotation$extension0(package$.MODULE$.ScowlNamedObject((OWLNamedObject)this.tropicalis()), Vocab$.MODULE$.rdfsLabel(), (Object)"Xenopus tropicalis", (AnnotationValuer)package$.MODULE$.StringLiterable()));
    }

    public scala.collection.immutable.Set<OWLAxiom> translate(String expressionLine, Map<String, String> genepageMappings, OWLNamedIndividual species) {
        scala.collection.immutable.Set set;
        String[] items = expressionLine.split("\t");
        String string = StringUtils.stripToEmpty((String)items[3]);
        String string2 = "unspecified";
        if (!(string != null ? !string.equals(string2) : string2 != null)) {
            set = Predef$.MODULE$.Set().empty();
        } else {
            Object object;
            Set axioms = Set$.MODULE$.empty();
            OWLNamedIndividual expression = OntUtil$.MODULE$.nextIndividual();
            axioms.add((Object)package$.MODULE$.Declaration().apply((OWLEntity)expression));
            axioms.add((Object)package.ScowlIndividual$.MODULE$.Type$extension(package$.MODULE$.ScowlIndividual((OWLIndividual)expression), (OWLClassExpression)Vocab$.MODULE$.GeneExpression()));
            String[] structureItems = items[3].split(",", -1);
            Predef$.MODULE$.refArrayOps((Object[])structureItems).foreach((Function1)new Serializable(axioms, expression){
                public static final long serialVersionUID = 0L;
                private final Set axioms$1;
                private final OWLNamedIndividual expression$1;

                public final boolean apply(String structureItem) {
                    String structureID = StringUtils.stripToNull((String)structureItem.trim().split(" ")[0]);
                    OWLClass structureType = (OWLClass)package$.MODULE$.Class().apply(OBOUtil$.MODULE$.iriForTermID(structureID));
                    OWLNamedIndividual punnedStructure = package$.MODULE$.Individual(structureType.getIRI());
                    this.axioms$1.add((Object)package$.MODULE$.Declaration().apply((OWLEntity)punnedStructure));
                    return this.axioms$1.add((Object)package.ScowlIndividual$.MODULE$.Fact$extension0(package$.MODULE$.ScowlIndividual((OWLIndividual)this.expression$1), (OWLObjectPropertyExpression)Vocab$.MODULE$.occurs_in(), (OWLIndividual)punnedStructure));
                }
                {
                    this.axioms$1 = axioms$1;
                    this.expression$1 = expression$1;
                }
            });
            String evidenceText = StringUtils.stripToEmpty((String)items[7]);
            if (evidenceText.contains("XB-IMG")) {
                OWLNamedIndividual image = package$.MODULE$.Individual(OBOUtil$.MODULE$.xenbaseImageIRI(evidenceText));
                object = BoxesRunTime.boxToBoolean((boolean)axioms.add((Object)package.ScowlIndividual$.MODULE$.Fact$extension0(package$.MODULE$.ScowlIndividual((OWLIndividual)expression), (OWLObjectPropertyExpression)Vocab$.MODULE$.dcSource(), (OWLIndividual)image)));
            } else {
                object = BoxedUnit.UNIT;
            }
            String genepageID = (String)genepageMappings.apply((Object)StringUtils.stripToNull((String)items[0]));
            IRI geneIRI = XenbaseGenesToOWL$.MODULE$.getGeneIRI(genepageID);
            OWLNamedIndividual gene = package$.MODULE$.Individual(geneIRI);
            axioms.add((Object)package$.MODULE$.Declaration().apply((OWLEntity)gene));
            axioms.add((Object)package.ScowlIndividual$.MODULE$.Fact$extension0(package$.MODULE$.ScowlIndividual((OWLIndividual)expression), (OWLObjectPropertyExpression)Vocab$.MODULE$.associated_with_gene(), (OWLIndividual)gene));
            axioms.add((Object)package.ScowlIndividual$.MODULE$.Fact$extension0(package$.MODULE$.ScowlIndividual((OWLIndividual)expression), (OWLObjectPropertyExpression)Vocab$.MODULE$.associated_with_taxon(), (OWLIndividual)species));
            set = axioms.toSet();
        }
        return set;
    }

    private XenbaseExpressionToOWL$() {
        MODULE$ = this;
        this.laevis = package$.MODULE$.Individual(Vocab$.MODULE$.XENOPUS_LAEVIS());
        this.tropicalis = package$.MODULE$.Individual(Vocab$.MODULE$.XENOPUS_TROPICALIS());
    }
}

